/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux;

import java.util.Collection;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.Request;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestCorrelator;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestOptions;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux.MuxHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.ClassConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;

public class MuxRequestCorrelator
extends RequestCorrelator {
    protected static final short MUX_ID = ClassConfigurator.getProtocolId(MuxRequestCorrelator.class);
    private final Header header;

    public MuxRequestCorrelator(short id, Protocol transport, RequestHandler handler, Address localAddr) {
        super(ClassConfigurator.getProtocolId(RequestCorrelator.class), transport, handler, localAddr);
        this.header = new MuxHeader(id);
    }

    @Override
    public void sendRequest(Collection<Address> dest_mbrs, Message msg, Request req, RequestOptions options) throws Exception {
        msg.putHeader(MUX_ID, this.header);
        super.sendRequest(dest_mbrs, msg, req, options);
    }

    @Override
    public void sendUnicastRequest(Address target, Message msg, Request req) throws Exception {
        msg.putHeader(MUX_ID, this.header);
        super.sendUnicastRequest(target, msg, req);
    }

    @Override
    protected void prepareResponse(Message rsp) {
        rsp.putHeader(MUX_ID, this.header);
        super.prepareResponse(rsp);
    }
}

