/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.AttributeType;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.Bundler;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TP;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataOutputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public abstract class BaseBundler
implements Bundler {
    protected final Map<Address, List<Message>> msgs = new HashMap<Address, List<Message>>(24);
    protected TP transport;
    protected final ReentrantLock lock = new ReentrantLock();
    protected long count;
    protected ByteArrayDataOutputStream output;
    protected Log log;
    @Property(name="max_size", type=AttributeType.BYTES, description="Maximum number of bytes for messages to be queued until they are sent")
    protected int max_size = 64000;
    @Property(description="The max number of elements in a bundler if the bundler supports size limitations", type=AttributeType.SCALAR)
    protected int capacity = 16384;

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public Bundler setCapacity(int c) {
        this.capacity = c;
        return this;
    }

    @Override
    public int getMaxSize() {
        return this.max_size;
    }

    @Override
    public Bundler setMaxSize(int s) {
        this.max_size = s;
        return this;
    }

    @Override
    public void init(TP transport) {
        this.transport = transport;
        this.log = transport.getLog();
        this.output = new ByteArrayDataOutputStream(this.max_size + 3);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void send(Message msg) throws Exception {
    }

    @Override
    public void viewChange(View view) {
    }

    @Override
    @ManagedAttribute(description="The number of unsent messages in the bundler")
    public int size() {
        this.lock.lock();
        try {
            int n = this.msgs.values().stream().map(List::size).reduce(0, Integer::sum);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @ManagedAttribute(description="Size of the queue (if available")
    public int getQueueSize() {
        return -1;
    }

    protected void sendBundledMessages() {
        for (Map.Entry<Address, List<Message>> entry : this.msgs.entrySet()) {
            List<Message> list = entry.getValue();
            if (list.isEmpty()) continue;
            this.output.position(0);
            if (list.size() == 1) {
                this.sendSingleMessage(list.get(0));
            } else {
                Address dst = entry.getKey();
                this.sendMessageList(dst, list.get(0).getSrc(), list);
                if (this.transport.statsEnabled()) {
                    this.transport.getMessageStats().incrNumBatchesSent(1);
                }
            }
            list.clear();
        }
        this.count = 0L;
    }

    protected void sendSingleMessage(Message msg) {
        Address dest = msg.getDest();
        try {
            Util.writeMessage(msg, this.output, dest == null);
            this.transport.doSend(this.output.buffer(), 0, this.output.position(), dest);
            if (this.transport.statsEnabled()) {
                this.transport.getMessageStats().incrNumSingleMsgsSent(1);
            }
        }
        catch (Throwable e) {
            this.log.trace(Util.getMessage("SendFailure"), this.transport.getAddress(), dest == null ? "cluster" : dest, msg.size(), e.toString(), msg.printHeaders());
        }
    }

    protected void sendMessageList(Address dest, Address src, List<Message> list) {
        try {
            Util.writeMessageList(dest, src, this.transport.cluster_name.chars(), list, this.output, dest == null, this.transport.getId());
            this.transport.doSend(this.output.buffer(), 0, this.output.position(), dest);
        }
        catch (Throwable e) {
            this.log.trace(Util.getMessage("FailureSendingMsgBundle"), this.transport.getAddress(), e);
        }
    }

    protected void addMessage(Message msg, int size) {
        Address dest = msg.getDest();
        List tmp = this.msgs.computeIfAbsent(dest, k -> new ArrayList(16));
        tmp.add(msg);
        this.count += (long)size;
    }
}

