/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay;

import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.RELAY2;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class Route
implements Comparable<Route> {
    protected final Address site_master;
    protected final JChannel bridge;
    protected final RELAY2 relay;
    protected final Log log;
    protected boolean stats = true;

    public Route(Address site_master, JChannel bridge, RELAY2 relay, Log log) {
        this.site_master = site_master;
        this.bridge = bridge;
        this.relay = relay;
        this.log = log;
    }

    public JChannel bridge() {
        return this.bridge;
    }

    public Address siteMaster() {
        return this.site_master;
    }

    public boolean stats() {
        return this.stats;
    }

    public Route stats(boolean f) {
        this.stats = f;
        return this;
    }

    public void send(Address final_destination, Address original_sender, Message msg) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("routing message to " + final_destination + " via " + this.site_master);
        }
        long start = this.stats ? System.nanoTime() : 0L;
        try {
            Message copy = this.createMessage(this.site_master, final_destination, original_sender, msg);
            this.bridge.send(copy);
            if (this.stats) {
                this.relay.addToRelayedTime(System.nanoTime() - start);
                this.relay.incrementRelayed();
            }
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailureRelayingMessage"), e);
        }
    }

    @Override
    public int compareTo(Route o) {
        return this.site_master.compareTo(o.siteMaster());
    }

    public boolean equals(Object obj) {
        return this.compareTo((Route)obj) == 0;
    }

    public int hashCode() {
        return this.site_master.hashCode();
    }

    public String toString() {
        return this.site_master != null ? this.site_master.toString() : "";
    }

    protected Message createMessage(Address target, Address final_destination, Address original_sender, Message msg) {
        Message copy = this.relay.copy(msg).setDest(target).setSrc(null);
        RELAY2.Relay2Header hdr = new RELAY2.Relay2Header(1, final_destination, original_sender);
        copy.putHeader(this.relay.getId(), hdr);
        return copy;
    }
}

