/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.logs;

import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleFactory {
    public static <T> T newBundle(Class<T> type) {
        return BundleFactory.newBundle(type, type.getName());
    }

    public static <T> T newBundle(Class<T> type, String category) {
        Constructor<T> constructor;
        Class<T> implClass;
        String implClassName = type.getName() + "_impl";
        try {
            implClass = Class.forName(implClassName, true, type.getClassLoader()).asSubclass(type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to find class for log/message impl: " + implClassName, e);
        }
        try {
            constructor = implClass.getConstructor(Logger.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to find constructor for log/message impl: " + implClassName, e);
        }
        try {
            Logger logger = LoggerFactory.getLogger(category);
            return type.cast(constructor.newInstance(logger));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create instance for log/message impl: " + implClassName, e);
        }
    }
}

