/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSharedQueueMessage;

public class CreateSharedQueueMessage_V2
extends CreateSharedQueueMessage {
    private RoutingType routingType;

    public CreateSharedQueueMessage_V2(SimpleString address, SimpleString queueName, RoutingType routingType, SimpleString filterString, boolean durable, boolean requiresResponse) {
        this();
        this.address = address;
        this.queueName = queueName;
        this.filterString = filterString;
        this.durable = durable;
        this.requiresResponse = requiresResponse;
        this.routingType = routingType;
    }

    public CreateSharedQueueMessage_V2() {
        super((byte)-13);
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public void setRoutingType(RoutingType routingType) {
        this.routingType = routingType;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", address=" + this.address);
        buff.append(", queueName=" + this.queueName);
        buff.append(", filterString=" + this.filterString);
        buff.append(", durable=" + this.durable);
        buff.append(", requiresResponse=" + this.requiresResponse);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.address);
        buffer.writeSimpleString(this.queueName);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeBoolean(this.durable);
        buffer.writeByte(this.routingType.getType());
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.address = buffer.readSimpleString();
        this.queueName = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        this.durable = buffer.readBoolean();
        this.routingType = RoutingType.getType(buffer.readByte());
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        result = 31 * result + (this.durable ? 1231 : 1237);
        result = 31 * result + this.routingType.getType();
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateSharedQueueMessage_V2)) {
            return false;
        }
        CreateSharedQueueMessage_V2 other = (CreateSharedQueueMessage_V2)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals(other.filterString)) {
            return false;
        }
        if (this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName)) {
            return false;
        }
        if (this.durable != other.durable) {
            return false;
        }
        if (this.routingType != other.routingType) {
            return false;
        }
        return this.requiresResponse == other.requiresResponse;
    }
}

