/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.utils.Env;

public final class KQueue {
    private static final boolean IS_KQUEUE_AVAILABLE = KQueue.isKQueueAvailable();

    private static boolean isKQueueAvailable() {
        try {
            if (Env.is64BitJvm() && Env.isMacOs()) {
                return org.apache.activemq.artemis.shaded.io.netty.channel.kqueue.KQueue.isAvailable();
            }
            return false;
        }
        catch (Throwable e) {
            ActiveMQClientLogger.LOGGER.unableToCheckKQueueAvailability(e);
            return false;
        }
    }

    private KQueue() {
    }

    public static boolean isAvailable() {
        return IS_KQUEUE_AVAILABLE;
    }
}

