/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class Env {
    private static final int OS_PAGE_SIZE;
    private static boolean testEnv;
    private static final String OS;
    private static final boolean IS_LINUX;
    private static final boolean IS_MAC;
    private static final boolean IS_64BIT;

    private Env() {
    }

    public static int osPageSize() {
        return OS_PAGE_SIZE;
    }

    public static boolean isTestEnv() {
        return testEnv;
    }

    public static void setTestEnv(boolean testEnv) {
        Env.testEnv = testEnv;
    }

    public static boolean isLinuxOs() {
        return IS_LINUX;
    }

    public static boolean isMacOs() {
        return IS_MAC;
    }

    public static boolean is64BitJvm() {
        return IS_64BIT;
    }

    private static boolean checkIs64bit() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    static {
        Unsafe instance;
        int osPageSize = 4096;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            instance = (Unsafe)field.get(null);
        }
        catch (Throwable t) {
            try {
                Constructor c = Unsafe.class.getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                instance = (Unsafe)c.newInstance(new Object[0]);
            }
            catch (Throwable t1) {
                instance = null;
            }
        }
        if (instance != null) {
            osPageSize = instance.pageSize();
        }
        OS_PAGE_SIZE = osPageSize;
        testEnv = false;
        OS = System.getProperty("os.name").toLowerCase();
        IS_LINUX = OS.startsWith("linux");
        IS_MAC = OS.startsWith("mac");
        IS_64BIT = Env.checkIs64bit();
    }
}

