/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class ProcessorBase<T> {
    private static final int STATE_NOT_RUNNING = 0;
    private static final int STATE_RUNNING = 1;
    protected final Queue<T> tasks = new ConcurrentLinkedQueue<T>();
    private final Executor delegate;
    private final ExecutorTask task = new ExecutorTask();
    private volatile int state = 0;
    private static final AtomicIntegerFieldUpdater<ProcessorBase> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ProcessorBase.class, "state");

    protected abstract void doTask(T var1);

    public ProcessorBase(Executor parent) {
        this.delegate = parent;
    }

    public final boolean flush() {
        return this.flush(30L, TimeUnit.SECONDS);
    }

    public final boolean flush(long timeout, TimeUnit unit) {
        if (stateUpdater.get(this) == 0) {
            return true;
        }
        long timeLimit = System.currentTimeMillis() + unit.toMillis(timeout);
        try {
            while (stateUpdater.get(this) == 1 && timeLimit > System.currentTimeMillis()) {
                if (this.tasks.isEmpty()) {
                    return true;
                }
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return stateUpdater.get(this) == 0;
    }

    public final boolean isFlushed() {
        return stateUpdater.get(this) == 0;
    }

    protected void task(T command) {
        this.tasks.add(command);
        this.startPoller();
    }

    protected void startPoller() {
        if (stateUpdater.get(this) == 0) {
            this.delegate.execute(this.task);
        }
    }

    private final class ExecutorTask
    implements Runnable {
        private ExecutorTask() {
        }

        @Override
        public void run() {
            do {
                if (stateUpdater.compareAndSet(ProcessorBase.this, 0, 1)) {
                    Object task = ProcessorBase.this.tasks.poll();
                    while (task != null) {
                        ProcessorBase.this.doTask(task);
                        task = ProcessorBase.this.tasks.poll();
                    }
                } else {
                    return;
                }
                stateUpdater.set(ProcessorBase.this, 0);
            } while (!ProcessorBase.this.tasks.isEmpty());
        }
    }
}

