/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.conf;

import java.lang.reflect.Field;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.PropertyConverter;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Configurator;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.IpAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Policy;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.StackType;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public final class PropertyConverters {
    private PropertyConverters() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static class Default
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String propertyValue, boolean check_scope, StackType ip_version) throws Exception {
            if (propertyValue == null) {
                throw new NullPointerException("Property value cannot be null");
            }
            if (Boolean.TYPE.equals(propertyFieldType)) {
                return Boolean.parseBoolean(propertyValue);
            }
            if (Integer.TYPE.equals(propertyFieldType)) {
                return Util.readBytesInteger(propertyValue);
            }
            if (Long.TYPE.equals(propertyFieldType)) {
                return Util.readBytesLong(propertyValue);
            }
            if (Byte.TYPE.equals(propertyFieldType)) {
                return Byte.parseByte(propertyValue);
            }
            if (Double.TYPE.equals(propertyFieldType)) {
                return Util.readBytesDouble(propertyValue);
            }
            if (Short.TYPE.equals(propertyFieldType)) {
                return Short.parseShort(propertyValue);
            }
            if (Float.TYPE.equals(propertyFieldType)) {
                return Float.valueOf(Float.parseFloat(propertyValue));
            }
            if (String[].class.equals(propertyFieldType)) {
                return Util.parseStringArray(propertyValue, ",");
            }
            if (propertyFieldType.isEnum()) {
                return Util.createEnum(propertyValue, propertyFieldType);
            }
            if (InetAddress.class.equals(propertyFieldType)) {
                Inet6Address ret;
                Inet6Address addr;
                int scope;
                InetAddress retval = null;
                if (propertyValue.contains(",")) {
                    List<String> addrs = Util.parseCommaDelimitedStrings(propertyValue);
                    for (String addr2 : addrs) {
                        try {
                            retval = Util.getAddress(addr2, ip_version);
                            if (retval == null) continue;
                            break;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    if (retval == null) {
                        throw new IllegalArgumentException(String.format("failed parsing attribute %s with value %s", propertyName, propertyValue));
                    }
                } else {
                    retval = Util.getAddress(propertyValue, ip_version);
                }
                if (check_scope && retval instanceof Inet6Address && retval.isLinkLocalAddress() && (scope = (addr = (Inet6Address)retval).getScopeId()) == 0 && (ret = Default.getScopedInetAddress(addr)) != null) {
                    retval = ret;
                }
                return retval;
            }
            return propertyValue;
        }

        protected static Inet6Address getScopedInetAddress(Inet6Address addr) {
            if (addr == null) {
                return null;
            }
            ArrayList<InetAddress> retval = new ArrayList<InetAddress>();
            try {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> addrs = intf.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        InetAddress address = addrs.nextElement();
                        if (!address.isLinkLocalAddress() || !(address instanceof Inet6Address) || !address.equals(addr) || ((Inet6Address)address).getScopeId() == 0) continue;
                        retval.add(address);
                    }
                }
                if (retval.size() == 1) {
                    return (Inet6Address)retval.get(0);
                }
                return null;
            }
            catch (SocketException e) {
                return null;
            }
        }

        @Override
        public String toString(Object value) {
            if (value instanceof InetAddress) {
                return ((InetAddress)value).getHostAddress();
            }
            return value != null ? value.toString() : null;
        }
    }

    public static class PolicyConverter
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String val, boolean check_scope, StackType ip_version) throws Exception {
            if (val == null) {
                return null;
            }
            List<String> classes = Util.parseCommaDelimitedStrings(val);
            ArrayList<Policy> l = new ArrayList<Policy>();
            for (String classname : classes) {
                Class<?> clazz = Util.loadClass(classname, this.getClass());
                Policy p = (Policy)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                l.add(p);
            }
            return l;
        }

        @Override
        public String toString(Object value) {
            List l = (List)value;
            return l == null ? "n/a" : l.stream().map(p -> p.getClass().getSimpleName()).collect(Collectors.joining(", "));
        }
    }

    public static class BindInterface
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String propertyValue, boolean check_scope, StackType ip_version) throws Exception {
            InetAddress old_bind_addr = (InetAddress)Configurator.getValueFromObject((Object)((Protocol)obj), "bind_addr");
            InetAddress new_bind_addr = Util.validateBindAddressFromInterface(old_bind_addr, propertyValue, ip_version);
            if (new_bind_addr != null) {
                BindInterface.setBindAddress((Protocol)obj, new_bind_addr);
            }
            return propertyValue != null ? propertyValue : "";
        }

        private static void setBindAddress(Protocol protocol, InetAddress bind_addr) throws Exception {
            Field f = Util.getField(protocol.getClass(), "bind_addr");
            Util.setField(f, protocol, bind_addr);
        }

        @Override
        public String toString(Object value) {
            return (String)value;
        }
    }

    public static class InitialHosts2
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String prop_val, boolean check_scope, StackType ip_version) throws Exception {
            return Util.parseCommaDelimitedHosts2(prop_val, 0);
        }

        @Override
        public String toString(Object value) {
            if (value instanceof Collection) {
                StringBuilder sb = new StringBuilder();
                Collection list = (Collection)value;
                boolean first = true;
                for (InetSocketAddress addr : list) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(addr.getAddress().getHostAddress()).append("[").append(addr.getPort()).append("]");
                }
                return sb.toString();
            }
            return value.getClass().getName();
        }
    }

    public static class InitialHosts
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String prop_val, boolean check_scope, StackType ip_version) throws Exception {
            if (prop_val == null) {
                return null;
            }
            int port_range = InitialHosts.getPortRange((Protocol)obj);
            return Util.parseCommaDelimitedHosts(prop_val, port_range);
        }

        @Override
        public String toString(Object value) {
            if (value instanceof Collection) {
                StringBuilder sb = new StringBuilder();
                Collection list = (Collection)value;
                boolean first = true;
                for (IpAddress addr : list) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(addr.getIpAddress().getHostAddress()).append("[").append(addr.getPort()).append("]");
                }
                return sb.toString();
            }
            return value.getClass().getName();
        }

        private static int getPortRange(Protocol protocol) throws Exception {
            Field f = Util.getField(protocol.getClass(), "port_range");
            return (Integer)Util.getField(f, protocol);
        }
    }

    public static class NetworkInterfaceList
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String propertyValue, boolean check_scope, StackType ip_version) throws Exception {
            return Util.parseInterfaceList(propertyValue);
        }

        @Override
        public String toString(Object value) {
            List list = (List)value;
            return Util.print(list);
        }
    }
}

