/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Bits;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class Relay2Header
extends Header {
    public static final byte DATA = 1;
    public static final byte SITE_UNREACHABLE = 2;
    public static final byte HOST_UNREACHABLE = 3;
    public static final byte SITES_UP = 4;
    public static final byte SITES_DOWN = 5;
    protected byte type;
    protected Address final_dest;
    protected Address original_sender;
    protected Set<String> sites;
    protected Set<String> visited_sites;

    public Relay2Header() {
    }

    public Relay2Header(byte type) {
        this.type = type;
    }

    public Relay2Header(byte type, Address final_dest, Address original_sender) {
        this(type);
        this.final_dest = final_dest;
        this.original_sender = original_sender;
    }

    @Override
    public short getMagicId() {
        return 80;
    }

    @Override
    public Supplier<? extends Header> create() {
        return Relay2Header::new;
    }

    public byte getType() {
        return this.type;
    }

    public Address getFinalDest() {
        return this.final_dest;
    }

    public Relay2Header setFinalDestination(Address d) {
        this.final_dest = d;
        return this;
    }

    public Address getOriginalSender() {
        return this.original_sender;
    }

    public Relay2Header setOriginalSender(Address s) {
        this.original_sender = s;
        return this;
    }

    public Set<String> getSites() {
        return this.sites;
    }

    public Relay2Header setSites(Set<String> s) {
        this.sites = s;
        return this;
    }

    public Relay2Header setSites(String ... s) {
        if (s != null && s.length > 0) {
            if (this.sites == null) {
                this.sites = new HashSet<String>();
            }
            this.sites.addAll(Arrays.asList(s));
        }
        return this;
    }

    public Relay2Header addToVisitedSites(String s) {
        if (this.visited_sites == null) {
            this.visited_sites = new HashSet<String>();
        }
        this.visited_sites.add(s);
        return this;
    }

    public Relay2Header addToVisitedSites(Collection<String> list) {
        if (list == null || list.isEmpty()) {
            return this;
        }
        for (String s : list) {
            this.addToVisitedSites(s);
        }
        return this;
    }

    public boolean hasVisitedSites() {
        return this.visited_sites != null && !this.visited_sites.isEmpty();
    }

    public Set<String> getVisitedSites() {
        return this.visited_sites;
    }

    public Relay2Header copy() {
        Relay2Header hdr = new Relay2Header(this.type, this.final_dest, this.original_sender);
        if (this.sites != null) {
            hdr.sites = new HashSet<String>(this.sites);
        }
        if (this.visited_sites != null) {
            hdr.addToVisitedSites(this.visited_sites);
        }
        return hdr;
    }

    @Override
    public int serializedSize() {
        return 1 + Util.size(this.final_dest) + Util.size(this.original_sender) + Relay2Header.sizeOf(this.sites) + Relay2Header.sizeOf(this.visited_sites);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.type);
        Util.writeAddress(this.final_dest, out);
        Util.writeAddress(this.original_sender, out);
        out.writeInt(this.sites == null ? 0 : this.sites.size());
        if (this.sites != null) {
            for (String s : this.sites) {
                Bits.writeString(s, out);
            }
        }
        out.writeInt(this.visited_sites == null ? 0 : this.visited_sites.size());
        if (this.visited_sites != null) {
            for (String s : this.visited_sites) {
                Bits.writeString(s, out);
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        int i;
        this.type = in.readByte();
        this.final_dest = Util.readAddress(in);
        this.original_sender = Util.readAddress(in);
        int num_elements = in.readInt();
        if (num_elements > 0) {
            this.sites = new HashSet<String>();
            for (i = 0; i < num_elements; ++i) {
                this.sites.add(Bits.readString(in));
            }
        }
        if ((num_elements = in.readInt()) > 0) {
            this.visited_sites = new HashSet<String>();
            for (i = 0; i < num_elements; ++i) {
                this.visited_sites.add(Bits.readString(in));
            }
        }
    }

    @Override
    public String toString() {
        return String.format("%s [final dest=%s, original sender=%s, %s%s]", Relay2Header.typeToString(this.type), this.final_dest, this.original_sender, this.sites + ", sites,", this.visited_sites == null || this.visited_sites.isEmpty() ? "" : String.format(", visited=%s", this.visited_sites));
    }

    protected static String typeToString(byte type) {
        switch (type) {
            case 1: {
                return "DATA";
            }
            case 2: {
                return "SITE_UNREACHABLE";
            }
            case 3: {
                return "HOST_UNREACHABLE";
            }
            case 4: {
                return "SITES_UP";
            }
            case 5: {
                return "SITES_DOWN";
            }
        }
        return "<unknown>";
    }

    protected static int sizeOf(Collection<String> list) {
        int retval = 4;
        if (list != null) {
            for (String s : list) {
                retval += Bits.sizeUTF(s) + 1;
            }
        }
        return retval;
    }
}

