/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.EmptyMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.ObjectMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.PhysicalAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Component;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.XmlElement;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.XmlInclude;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.AttributeType;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.ConfiguratorFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.XmlNode;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.Relay2Header;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.Relayer;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.Route;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.RouteStatusListener;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.SiteAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.SiteMaster;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.SiteMasterPicker;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.SiteUUID;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.TopoHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.Topology;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.config.RelayConfig;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.IpAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ExtendedUUID;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;
import org.apache.activemq.artemis.shaded.org.jgroups.util.NameCache;
import org.apache.activemq.artemis.shaded.org.jgroups.util.SuppressLog;
import org.apache.activemq.artemis.shaded.org.jgroups.util.TimeScheduler;
import org.apache.activemq.artemis.shaded.org.jgroups.util.UUID;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@XmlInclude(schema={"relay.xsd"}, type=XmlInclude.Type.IMPORT, namespace="urn:jgroups:relay:1.0", alias="relay")
@XmlElement(name="RelayConfiguration", type="relay:RelayConfigurationType")
@MBean(description="RELAY2 protocol")
public class RELAY2
extends Protocol {
    public static final short can_become_site_master_flag = 2;
    protected static final short TOPO_ID = 560;
    @Property(description="Name of the site (needs to be defined in the configuration)", writable=false)
    protected String site;
    @Property(description="Name of the relay configuration", writable=false)
    protected String config;
    @Property(description="Whether or not this node can become the site master. If false, and we become the coordinator, we won't start the bridge(s)", writable=false)
    protected boolean can_become_site_master = true;
    @Property(description="Maximum number of site masters. Setting this to a value greater than 1 means that we can have multiple site masters. If the value is greater than the number of cluster nodes, everyone in the site will be a site master (and thus join the global cluster", writable=false)
    protected int max_site_masters = 1;
    @Property(description="Ratio of members that are site masters, out of range [0..1] (0 disables this). The number of site masters is computes as Math.min(max_site_masters, view.size() * site_masters_ratio). See https://issues.redhat.com/browse/JGRP-2581 for details")
    protected double site_masters_ratio;
    @Property(description="Whether or not we generate our own addresses in which we use can_become_site_master. If this property is false, can_become_site_master is ignored")
    protected boolean enable_address_tagging;
    @Deprecated
    @Property(description="Whether or not to relay multicast (dest=null) messages", deprecatedMessage="will be ignored")
    protected boolean relay_multicasts = true;
    @Property(description="If true, the creation of the relay channel (and the connect()) are done in the background. Async relay creation is recommended, so the view callback won't be blocked")
    protected boolean async_relay_creation = true;
    @Property(description="Fully qualified name of a class implementing SiteMasterPicker")
    protected String site_master_picker_impl;
    @Property(description="Time during which identical errors about no route to host will be suppressed. 0 disables this (every error will be logged).", type=AttributeType.TIME)
    protected long suppress_time_no_route_errors = 60000L;
    protected final Map<String, RelayConfig.SiteConfig> sites = new HashMap<String, RelayConfig.SiteConfig>();
    protected RelayConfig.SiteConfig site_config;
    @ManagedAttribute(description="Whether this member is a site master")
    protected volatile boolean is_site_master;
    @ManagedAttribute(description="The first of all site masters broadcasts route-up/down messages to all members of the local cluster")
    protected volatile boolean broadcast_route_notifications;
    @ManagedAttribute(description="The current site masters")
    protected volatile List<Address> site_masters;
    protected SiteMasterPicker site_master_picker;
    protected Consumer<Boolean> site_master_listener;
    protected volatile Relayer relayer;
    protected TimeScheduler timer;
    protected volatile List<Address> members = new ArrayList<Address>(11);
    @Property(description="If true, a site master forwards messages received from other sites to randomly chosen members of the local site for load balancing, reducing work for itself", deprecatedMessage="ignored")
    @Deprecated(since="5.2.15", forRemoval=true)
    protected boolean can_forward_local_cluster;
    @Property(description="Number of millis to wait for topology detection", type=AttributeType.TIME)
    protected long topo_wait_time = 2000L;
    protected short[] prots_above;
    protected volatile RouteStatusListener route_status_listener;
    protected final Set<String> site_cache = new HashSet<String>();
    protected final LongAdder forward_to_site_master = new LongAdder();
    protected final LongAdder forward_sm_time = new LongAdder();
    protected final LongAdder relayed = new LongAdder();
    protected final LongAdder relayed_time = new LongAdder();
    protected final LongAdder forward_to_local_mbr = new LongAdder();
    protected final LongAdder forward_to_local_mbr_time = new LongAdder();
    protected final LongAdder local_deliveries = new LongAdder();
    @Component(description="Maintains a cache of sites and members", name="topo")
    protected Topology topo = new Topology(this);
    protected final LongAdder local_delivery_time = new LongAdder();
    protected SuppressLog<String> suppress_log_no_route;

    public RELAY2 site(String site_name) {
        this.site = site_name;
        return this;
    }

    public RELAY2 config(String cfg) {
        this.config = cfg;
        return this;
    }

    public RELAY2 canBecomeSiteMaster(boolean flag) {
        this.can_become_site_master = flag;
        return this;
    }

    public RELAY2 enableAddressTagging(boolean flag) {
        this.enable_address_tagging = flag;
        return this;
    }

    @Deprecated(since="5.2.15")
    public boolean relayMulticasts() {
        return true;
    }

    @Deprecated(since="5.2.15")
    public RELAY2 relayMulticasts(boolean ignoredFlag) {
        return this;
    }

    public RELAY2 asyncRelayCreation(boolean flag) {
        this.async_relay_creation = flag;
        return this;
    }

    public RELAY2 siteMasterPicker(SiteMasterPicker s) {
        if (s != null) {
            this.site_master_picker = s;
        }
        return this;
    }

    public Topology topo() {
        return this.topo;
    }

    public String site() {
        return this.site;
    }

    public List<Address> siteMasters() {
        return this.site_masters;
    }

    public List<Address> members() {
        return this.members;
    }

    public List<String> siteNames() {
        return this.getSites();
    }

    public String config() {
        return this.config;
    }

    public boolean canBecomeSiteMaster() {
        return this.can_become_site_master;
    }

    public boolean enableAddressTagging() {
        return this.enable_address_tagging;
    }

    public boolean asyncRelayCreation() {
        return this.async_relay_creation;
    }

    public TimeScheduler getTimer() {
        return this.timer;
    }

    public void incrementRelayed() {
        this.relayed.increment();
    }

    public void addToRelayedTime(long delta) {
        this.relayed_time.add(delta);
    }

    public String getSite() {
        return this.site;
    }

    public RELAY2 setSite(String s) {
        this.site = s;
        return this;
    }

    public String getConfig() {
        return this.config;
    }

    public RELAY2 setConfig(String c) {
        this.config = c;
        return this;
    }

    public int getMaxSiteMasters() {
        return this.max_site_masters;
    }

    public RELAY2 setMaxSiteMasters(int m) {
        this.max_site_masters = m;
        return this;
    }

    public double getSiteMastersRatio() {
        return this.site_masters_ratio;
    }

    public RELAY2 setSiteMastersRatio(double r) {
        this.site_masters_ratio = r;
        return this;
    }

    public String getSiteMasterPickerImpl() {
        return this.site_master_picker_impl;
    }

    public RELAY2 setSiteMasterPickerImpl(String s) {
        this.site_master_picker_impl = s;
        return this;
    }

    public boolean broadcastRouteNotifications() {
        return this.broadcast_route_notifications;
    }

    public RELAY2 broadcastRouteNotifications(boolean b) {
        this.broadcast_route_notifications = b;
        return this;
    }

    public boolean canForwardLocalCluster() {
        return this.can_forward_local_cluster;
    }

    public RELAY2 canForwardLocalCluster(boolean c) {
        this.can_forward_local_cluster = c;
        return this;
    }

    public long getTopoWaitTime() {
        return this.topo_wait_time;
    }

    public RELAY2 setTopoWaitTime(long t) {
        this.topo_wait_time = t;
        return this;
    }

    public RouteStatusListener getRouteStatusListener() {
        return this.route_status_listener;
    }

    public void setRouteStatusListener(RouteStatusListener l) {
        this.route_status_listener = l;
    }

    public RELAY2 setSiteMasterListener(Consumer<Boolean> l) {
        this.site_master_listener = l;
        return this;
    }

    @ManagedAttribute(description="Number of messages forwarded to the local SiteMaster")
    public long getNumForwardedToSiteMaster() {
        return this.forward_to_site_master.sum();
    }

    @ManagedAttribute(description="The total time (in ms) spent forwarding messages to the local SiteMaster", type=AttributeType.TIME)
    public long getTimeForwardingToSM() {
        return TimeUnit.MILLISECONDS.convert(this.forward_sm_time.sum(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for forwarding messages to the local SiteMaster")
    public long getAvgMsgsForwardingToSM() {
        return this.getTimeForwardingToSM() > 0L ? (long)((double)this.getNumForwardedToSiteMaster() / ((double)this.getTimeForwardingToSM() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Number of messages sent by this SiteMaster to a remote SiteMaster")
    public long getNumRelayed() {
        return this.relayed.sum();
    }

    @ManagedAttribute(description="The total time (ms) spent relaying messages from this SiteMaster to remote SiteMasters", type=AttributeType.TIME)
    public long getTimeRelaying() {
        return TimeUnit.MILLISECONDS.convert(this.relayed_time.sum(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for relaying messages from this SiteMaster to remote SiteMasters")
    public long getAvgMsgsRelaying() {
        return this.getTimeRelaying() > 0L ? (long)((double)this.getNumRelayed() / ((double)this.getTimeRelaying() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Number of messages (received from a remote Sitemaster and) delivered by this SiteMaster to a local node")
    public long getNumForwardedToLocalMbr() {
        return this.forward_to_local_mbr.sum();
    }

    @ManagedAttribute(description="The total time (in ms) spent forwarding messages to a member in the same site", type=AttributeType.TIME)
    public long getTimeForwardingToLocalMbr() {
        return TimeUnit.MILLISECONDS.convert(this.forward_to_local_mbr_time.sum(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for forwarding messages to a member in the same site")
    public long getAvgMsgsForwardingToLocalMbr() {
        return this.getTimeForwardingToLocalMbr() > 0L ? (long)((double)this.getNumForwardedToLocalMbr() / ((double)this.getTimeForwardingToLocalMbr() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Number of messages delivered locally, e.g. received and delivered to self")
    public long getNumLocalDeliveries() {
        return this.local_deliveries.sum();
    }

    @ManagedAttribute(description="The total time (ms) spent delivering received messages locally", type=AttributeType.TIME)
    public long getTimeDeliveringLocally() {
        return TimeUnit.MILLISECONDS.convert(this.local_delivery_time.sum(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for delivering received messages locally")
    public long getAvgMsgsDeliveringLocally() {
        return this.getTimeDeliveringLocally() > 0L ? (long)((double)this.getNumLocalDeliveries() / ((double)this.getTimeDeliveringLocally() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Whether or not this instance is a site master")
    public boolean isSiteMaster() {
        return this.relayer != null;
    }

    @ManagedAttribute(description="Number of 'no route to site X' errors")
    public int getNumberOfNoRouteErrors() {
        return this.suppress_log_no_route != null ? this.suppress_log_no_route.getCache().size() : 0;
    }

    @ManagedOperation(description="Clears the 'no route to site X' cache")
    public RELAY2 clearNoRouteCache() {
        if (this.suppress_log_no_route != null) {
            this.suppress_log_no_route.getCache().clear();
        }
        return this;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.forward_to_site_master.reset();
        this.forward_sm_time.reset();
        this.relayed.reset();
        this.relayed_time.reset();
        this.forward_to_local_mbr.reset();
        this.forward_to_local_mbr_time.reset();
        this.local_deliveries.reset();
        this.local_delivery_time.reset();
        this.clearNoRouteCache();
    }

    public View getBridgeView(String cluster_name) {
        Relayer tmp = this.relayer;
        return tmp != null ? tmp.getBridgeView(cluster_name) : null;
    }

    public RELAY2 addSite(String site_name, RelayConfig.SiteConfig cfg) {
        this.sites.put(site_name, cfg);
        return this;
    }

    public List<String> getSites() {
        return this.sites.isEmpty() ? Collections.emptyList() : new ArrayList<String>(this.sites.keySet());
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.configure();
        if (this.site_master_picker == null) {
            this.site_master_picker = new SiteMasterPicker(){

                @Override
                public Address pickSiteMaster(List<Address> site_masters, Address original_sender) {
                    return Util.pickRandomElement(site_masters);
                }

                @Override
                public Route pickRoute(String site, List<Route> routes, Address original_sender) {
                    return Util.pickRandomElement(routes);
                }
            };
        }
        if (this.suppress_time_no_route_errors > 0L) {
            this.suppress_log_no_route = new SuppressLog(this.log, "RelayNoRouteToSite", "SuppressMsgRelay");
        }
    }

    public void configure() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.site == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        if (this.max_site_masters < 1) {
            this.log.warn("max_size_masters was " + this.max_site_masters + ", changed to 1");
            this.max_site_masters = 1;
        }
        if (this.site_masters_ratio < 0.0) {
            this.log.warn("%s: changing incorrect site_masters_ratio of %.2f to 0", this.local_addr, this.site_masters_ratio);
            this.site_masters_ratio = 0.0;
        } else if (this.site_masters_ratio > 1.0) {
            this.log.warn("%s: changing incorrect site_masters_ratio of %.2f to 1", this.local_addr, this.site_masters_ratio);
            this.site_masters_ratio = 1.0;
        }
        if (this.site_master_picker_impl != null) {
            Class<?> clazz = Util.loadClass(this.site_master_picker_impl, (Class)null);
            this.site_master_picker = (SiteMasterPicker)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (this.config != null) {
            this.parseSiteConfiguration(this.sites);
        }
        this.site_config = this.sites.get(this.site);
        if (this.site_config == null) {
            throw new Exception("site configuration for \"" + this.site + "\" not found in " + this.config);
        }
        this.log.trace("site configuration:\n" + this.site_config);
        if (this.enable_address_tagging) {
            JChannel ch = this.getProtocolStack().getChannel();
            ch.addAddressGenerator(() -> {
                ExtendedUUID retval = ExtendedUUID.randomUUID();
                if (this.can_become_site_master) {
                    retval.setFlag((short)2);
                }
                return retval;
            });
        }
        this.prots_above = this.getIdsAbove();
    }

    @Override
    public void stop() {
        super.stop();
        this.is_site_master = false;
        this.log.trace(this.local_addr + ": ceased to be site master; closing bridges");
        if (this.relayer != null) {
            this.relayer.stop();
        }
    }

    protected void parseSiteConfiguration(Map<String, RelayConfig.SiteConfig> map) throws Exception {
        try (InputStream input = ConfiguratorFactory.getConfigStream(this.config);){
            RelayConfig.parse(input, map);
        }
    }

    @Override
    public void parse(XmlNode node) throws Exception {
        RelayConfig.parse(node, this.sites);
    }

    @ManagedOperation(description="Prints the contents of the routing table. Only available if we're the current coordinator (site master)")
    public String printRoutes() {
        return this.relayer != null ? this.relayer.printRoutes() : "n/a (not site master)";
    }

    @ManagedOperation(description="Prints the routes that are currently up. Only available if we're the current coordinator (site master)")
    public String printSites() {
        return this.relayer != null ? Util.print(this.relayer.getSiteNames()) : "n/a (not site master)";
    }

    @ManagedOperation(description="Prints the topology (site masters and local members) of this site")
    public String printTopology(boolean all_sites) {
        if (!all_sites) {
            return this.printLocalTopology();
        }
        return this.topo.print();
    }

    @ManagedOperation(description="Prints the topology (site masters and local members) of this site")
    public String printLocalTopology() {
        return this.topo.print(this.site);
    }

    public JChannel getBridge(String site_name) {
        Relayer tmp = this.relayer;
        Route route = tmp != null ? tmp.getRoute(site_name) : null;
        return route != null ? route.bridge() : null;
    }

    public Route getRoute(String site_name) {
        Relayer tmp = this.relayer;
        return tmp != null ? tmp.getRoute(site_name) : null;
    }

    public List<String> getCurrentSites() {
        Relayer rel = this.relayer;
        return rel == null ? null : rel.getSiteNames();
    }

    @Override
    public Object down(Event evt) {
        if (evt.getType() == 6) {
            this.handleView((View)evt.getArg());
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        SiteUUID sender;
        Address dest = msg.getDest();
        if (!(dest instanceof SiteAddress)) {
            return this.down_prot.down(msg);
        }
        SiteAddress target = (SiteAddress)dest;
        Address src = msg.getSrc();
        SiteUUID siteUUID = sender = src instanceof SiteMaster ? new SiteMaster(((SiteMaster)src).getSite()) : new SiteUUID((UUID)this.local_addr, NameCache.get(this.local_addr), this.site);
        if (this.local_addr instanceof ExtendedUUID) {
            ((ExtendedUUID)sender).addContents((ExtendedUUID)this.local_addr);
        }
        if (target.getSite().equals(this.site)) {
            if (this.local_addr.equals(target) || target instanceof SiteMaster && this.is_site_master) {
                long start = this.stats ? System.nanoTime() : 0L;
                this.forwardTo(this.local_addr, target, sender, msg, false);
                if (this.stats) {
                    this.local_delivery_time.add(System.nanoTime() - start);
                    this.local_deliveries.increment();
                }
            } else {
                this.deliverLocally(target, sender, msg);
            }
            return null;
        }
        if (!this.is_site_master) {
            long start = this.stats ? System.nanoTime() : 0L;
            Address site_master = this.pickSiteMaster(sender);
            if (site_master == null) {
                throw new IllegalStateException("site master is null");
            }
            this.forwardTo(site_master, target, sender, msg, this.max_site_masters == 1);
            if (this.stats) {
                this.forward_sm_time.add(System.nanoTime() - start);
                this.forward_to_site_master.increment();
            }
        } else {
            this.route(target, sender, msg);
        }
        return null;
    }

    @Override
    public Object up(Event evt) {
        if (evt.getType() == 6) {
            this.handleView((View)evt.getArg());
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        Address sender;
        Relay2Header hdr = (Relay2Header)msg.getHeader(this.id);
        Address dest = msg.getDest();
        Address address = sender = hdr != null && hdr.original_sender != null ? hdr.original_sender : msg.src();
        if (dest == null && this.is_site_master && !msg.isFlagSet(Message.Flag.NO_RELAY)) {
            this.sendToBridges(msg);
        }
        if (hdr == null) {
            TopoHeader topo_hdr = (TopoHeader)msg.getHeader((short)560);
            if (topo_hdr != null) {
                this.handleTopo(topo_hdr, sender, msg, false);
                return null;
            }
            this.deliver(dest, sender, msg);
        } else {
            if (this.handleAdminMessage(hdr)) {
                return null;
            }
            if (dest != null) {
                this.handleMessage(hdr, msg);
            } else {
                this.deliver(dest, sender, msg);
            }
        }
        return null;
    }

    @Override
    public void up(MessageBatch batch) {
        ArrayList<SiteAddress> unreachable_sites = null;
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Address sender;
            Message msg = it.next();
            Relay2Header hdr = (Relay2Header)msg.getHeader(this.id);
            Address dest = msg.getDest();
            Address address = sender = hdr != null && hdr.original_sender != null ? hdr.original_sender : batch.sender();
            if (dest == null && this.is_site_master && !msg.isFlagSet(Message.Flag.NO_RELAY)) {
                this.sendToBridges(msg);
            }
            if (hdr == null) {
                TopoHeader topo_hdr = (TopoHeader)msg.getHeader((short)560);
                if (topo_hdr == null) continue;
                this.handleTopo(topo_hdr, sender, msg, false);
                it.remove();
                continue;
            }
            it.remove();
            if (this.handleAdminMessage(hdr)) continue;
            if (dest != null) {
                if (hdr.getType() == 2) {
                    boolean contains;
                    SiteAddress site_addr = (SiteAddress)hdr.final_dest;
                    String site_name = site_addr.getSite();
                    if (unreachable_sites == null) {
                        unreachable_sites = new ArrayList<SiteAddress>();
                    }
                    if (contains = unreachable_sites.stream().anyMatch(sa -> sa.getSite().equals(site_name))) continue;
                    unreachable_sites.add(site_addr);
                    continue;
                }
                this.handleMessage(hdr, msg);
                continue;
            }
            this.deliver(null, hdr.original_sender, msg);
        }
        if (unreachable_sites != null) {
            for (SiteAddress sa2 : unreachable_sites) {
                this.triggerSiteUnreachableEvent(sa2);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void handleTopo(TopoHeader hdr, Address sender, Message msg, boolean send_rsps_for_entire_view) {
        switch (hdr.type()) {
            case 0: {
                List<Address> targets = send_rsps_for_entire_view ? new ArrayList<Address>(this.members) : List.of(this.local_addr);
                for (Address t : targets) {
                    this.sendResponseFor(t, sender);
                }
                break;
            }
            case 1: {
                Topology.MemberInfo mi = (Topology.MemberInfo)msg.getObject();
                this.topo.handleResponse(mi.site(), mi);
            }
        }
    }

    protected void sendResponseFor(Address mbr, Address dest) {
        SiteUUID my_addr = mbr instanceof SiteMaster ? new SiteMaster(((SiteMaster)mbr).getSite()) : new SiteUUID((UUID)mbr, NameCache.get(mbr), this.site);
        Topology.MemberInfo mi = new Topology.MemberInfo(this.site, my_addr, (IpAddress)this.getPhysicalAddress(mbr), this.site_masters.contains(mbr));
        Message rsp = new ObjectMessage(dest, mi).putHeader((short)560, new TopoHeader(1));
        this.down(rsp);
    }

    protected PhysicalAddress getPhysicalAddress(Address mbr) {
        return mbr != null ? (PhysicalAddress)this.down(new Event(87, mbr)) : null;
    }

    public void handleView(View view) {
        this.members = view.getMembers();
        int max_num_site_masters = this.max_site_masters;
        if (this.site_masters_ratio > 0.0) {
            max_num_site_masters = (int)Math.max((double)this.max_site_masters, this.site_masters_ratio * (double)view.size());
        }
        List<Address> old_site_masters = this.site_masters;
        List<Address> new_site_masters = RELAY2.determineSiteMasters(view, max_num_site_masters);
        boolean become_site_master = new_site_masters.contains(this.local_addr) && (old_site_masters == null || !old_site_masters.contains(this.local_addr));
        boolean cease_site_master = old_site_masters != null && old_site_masters.contains(this.local_addr) && !new_site_masters.contains(this.local_addr);
        this.site_masters = new_site_masters;
        if (!this.site_masters.isEmpty() && this.site_masters.get(0).equals(this.local_addr)) {
            this.broadcast_route_notifications = true;
        }
        if (become_site_master) {
            this.is_site_master = true;
            String bridge_name = "_" + NameCache.get(this.local_addr);
            if (this.relayer != null) {
                this.relayer.stop();
            }
            Relayer tmp = this.relayer = new Relayer(this, this.log);
            if (this.async_relay_creation) {
                this.timer.execute(() -> this.startRelayer(tmp, bridge_name));
            } else {
                this.startRelayer(this.relayer, bridge_name);
            }
            this.notifySiteMasterListener(true);
        } else if (cease_site_master) {
            this.is_site_master = false;
            this.notifySiteMasterListener(false);
            this.log.trace(this.local_addr + ": ceased to be site master; closing bridges");
            if (this.relayer != null) {
                this.relayer.stop();
            }
        }
        if (this.suppress_log_no_route != null) {
            this.suppress_log_no_route.removeExpired(this.suppress_time_no_route_errors);
        }
        this.topo().adjust(this.site, view.getMembers());
    }

    protected void handleRelayMessage(Relay2Header hdr, Message msg) {
        if (hdr.final_dest != null) {
            this.handleMessage(hdr, msg);
        } else {
            Message copy = this.copy(msg).setDest(null).setSrc(null).putHeader(this.id, hdr);
            this.down_prot.down(copy);
        }
    }

    protected boolean handleAdminMessage(Relay2Header hdr) {
        switch (hdr.type) {
            case 4: 
            case 5: {
                Set<String> tmp_sites = hdr.getSites();
                if (this.route_status_listener != null && tmp_sites != null) {
                    tmp_sites.remove(this.site);
                    if (hdr.type == 4) {
                        tmp_sites.removeAll(this.site_cache);
                        this.site_cache.addAll(tmp_sites);
                    }
                    if (tmp_sites.isEmpty()) {
                        return true;
                    }
                    String[] tmp = tmp_sites.toArray(new String[0]);
                    if (hdr.type == 4) {
                        this.route_status_listener.sitesUp(tmp);
                    } else {
                        this.route_status_listener.sitesDown(tmp);
                        this.site_cache.removeAll(tmp_sites);
                        this.topo.removeAll(tmp_sites);
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected void handleMessage(Relay2Header hdr, Message msg) {
        switch (hdr.type) {
            case 1: {
                this.route((SiteAddress)hdr.final_dest, (SiteAddress)hdr.original_sender, msg);
                break;
            }
            case 2: {
                this.triggerSiteUnreachableEvent((SiteAddress)hdr.final_dest);
                break;
            }
            default: {
                this.log.error("type " + hdr.type + " unknown");
            }
        }
    }

    protected void route(SiteAddress dest, SiteAddress sender, Message msg) {
        String target_site = dest.getSite();
        if (target_site.equals(this.site)) {
            if (this.local_addr.equals(dest) || dest instanceof SiteMaster && this.is_site_master) {
                this.deliver(dest, sender, msg);
            } else {
                this.deliverLocally(dest, sender, msg);
            }
            return;
        }
        Relayer tmp = this.relayer;
        if (tmp == null) {
            this.log.warn(this.local_addr + ": not site master; dropping message");
            return;
        }
        Route route = tmp.getRoute(target_site, sender);
        if (route == null) {
            route = tmp.getForwardingRouteMatching(target_site, sender);
        }
        if (route == null) {
            if (this.suppress_log_no_route != null) {
                this.suppress_log_no_route.log(SuppressLog.Level.error, target_site, this.suppress_time_no_route_errors, sender, target_site);
            } else {
                this.log.error(Util.getMessage("RelayNoRouteToSite"), this.local_addr, target_site);
            }
            this.sendSiteUnreachableTo(msg.getSrc(), target_site);
        } else {
            route.send(dest, sender, msg);
        }
    }

    protected void sendToBridges(Message msg) {
        Address original_sender;
        Map<String, List<Route>> routes;
        Relayer tmp = this.relayer;
        Map<String, List<Route>> map = routes = tmp != null ? tmp.routes : null;
        if (routes == null || routes.isEmpty()) {
            return;
        }
        Address src = msg.getSrc();
        Relay2Header hdr = (Relay2Header)msg.getHeader(this.id);
        Address address = original_sender = hdr != null && hdr.original_sender != null ? hdr.getOriginalSender() : new SiteUUID((UUID)src, NameCache.get(src), this.site);
        if (src instanceof ExtendedUUID) {
            ((ExtendedUUID)original_sender).addContents((ExtendedUUID)src);
        }
        HashSet<String> visited_sites = new HashSet<String>(routes.keySet());
        HashSet<String> sites_to_visit = new HashSet<String>(routes.keySet());
        if (this.site != null) {
            visited_sites.add(this.site);
            sites_to_visit.remove(this.site);
        }
        if (hdr != null && hdr.hasVisitedSites()) {
            visited_sites.addAll(hdr.getVisitedSites());
            sites_to_visit.removeAll(hdr.getVisitedSites());
        }
        block2: for (String dest_site : sites_to_visit) {
            List<Route> val = routes.get(dest_site);
            if (val == null) continue;
            for (Route route : val) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.local_addr + ": relaying multicast message from " + original_sender + " via route " + route);
                }
                try {
                    route.send(null, original_sender, msg, visited_sites);
                    continue block2;
                }
                catch (Exception ex) {
                    this.log.error(this.local_addr + ": failed relaying message from " + original_sender + " via route " + route, ex);
                }
            }
        }
    }

    protected void sendSiteUnreachableTo(Address src, String target_site) {
        if (src == null || src.equals(this.local_addr)) {
            this.triggerSiteUnreachableEvent(new SiteMaster(target_site));
            return;
        }
        Message msg = new EmptyMessage(src).setFlag(Message.Flag.OOB).putHeader(this.id, new Relay2Header(2, new SiteMaster(target_site), null));
        this.down_prot.down(msg);
    }

    protected void forwardTo(Address next_dest, SiteAddress final_dest, Address original_sender, Message msg, boolean forward_to_current_coord) {
        Relay2Header hdr;
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": forwarding message to final destination " + final_dest + " to " + (Comparable)(forward_to_current_coord ? " the current coordinator" : next_dest));
        }
        if ((hdr = (Relay2Header)msg.getHeader(this.id)) != null) {
            hdr.setOriginalSender(original_sender).setFinalDestination(final_dest);
        } else {
            hdr = new Relay2Header(1, final_dest, original_sender);
        }
        Message copy = this.copy(msg).setDest(next_dest).setSrc(null).putHeader(this.id, hdr);
        this.down_prot.down(copy);
    }

    protected void deliverLocally(SiteAddress dest, SiteAddress sender, Message msg) {
        Address local_dest;
        boolean send_to_coord = false;
        if (dest instanceof SiteUUID) {
            if (dest instanceof SiteMaster) {
                local_dest = this.pickSiteMaster(sender);
                if (local_dest == null) {
                    throw new IllegalStateException("site master was null");
                }
                send_to_coord = true;
            } else {
                SiteUUID tmp = (SiteUUID)dest;
                local_dest = new UUID(tmp.getMostSignificantBits(), tmp.getLeastSignificantBits());
            }
        } else {
            local_dest = dest;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": delivering message to " + dest + " in local cluster");
        }
        long start = this.stats ? System.nanoTime() : 0L;
        this.forwardTo(local_dest, dest, sender, msg, send_to_coord);
        if (this.stats) {
            this.forward_to_local_mbr_time.add(System.nanoTime() - start);
            this.forward_to_local_mbr.increment();
        }
    }

    protected void deliver(Address dest, Address sender, Message msg) {
        try {
            TopoHeader hdr = (TopoHeader)msg.getHeader((short)560);
            if (hdr != null) {
                this.handleTopo(hdr, sender, msg, dest instanceof SiteMaster);
                return;
            }
            Message copy = this.copy(msg).setDest(dest).setSrc(sender);
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": delivering message from " + sender);
            }
            long start = this.stats ? System.nanoTime() : 0L;
            this.up_prot.up(copy);
            if (this.stats) {
                this.local_delivery_time.add(System.nanoTime() - start);
                this.local_deliveries.increment();
            }
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailedDeliveringMessage"), e);
        }
    }

    protected void sitesChange(boolean down2, String ... sites) {
        if (!this.broadcast_route_notifications || sites == null || sites.length == 0) {
            return;
        }
        Relay2Header hdr = new Relay2Header(down2 ? (byte)5 : 4, null, null).setSites(sites);
        this.down_prot.down(new EmptyMessage(null).putHeader(this.id, hdr));
    }

    protected Message copy(Message msg) {
        return Util.copy(msg, true, (short)200, this.prots_above);
    }

    protected void startRelayer(Relayer rel, String bridge_name) {
        try {
            this.log.trace(this.local_addr + ": became site master; starting bridges");
            rel.start(this.site_config, bridge_name, this.site);
        }
        catch (Throwable t) {
            this.log.error(this.local_addr + ": failed starting relayer", t);
        }
    }

    protected void notifySiteMasterListener(boolean flag) {
        if (this.site_master_listener != null) {
            this.site_master_listener.accept(flag);
        }
    }

    protected static List<Address> determineSiteMasters(View view, int max_num_site_masters) {
        Address coord;
        ArrayList<Address> retval = new ArrayList<Address>(view.size());
        int selected = 0;
        for (Address member : view) {
            if (member instanceof ExtendedUUID && !((ExtendedUUID)member).isFlagSet((short)2) || selected++ >= max_num_site_masters) continue;
            retval.add(member);
        }
        if (retval.isEmpty() && (coord = view.getCoord()) != null) {
            retval.add(coord);
        }
        return retval;
    }

    protected Address pickSiteMaster(Address sender) {
        List<Address> masters = this.site_masters;
        if (masters.size() == 1) {
            return masters.get(0);
        }
        return this.site_master_picker.pickSiteMaster(masters, sender);
    }

    private void triggerSiteUnreachableEvent(SiteAddress remoteSite) {
        this.up_prot.up(new Event(104, remoteSite));
    }
}

