/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.Iterator;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.MsgStats;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TP;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TpHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.MessageProcessingPolicy;
import org.apache.activemq.artemis.shaded.org.jgroups.util.AsciiString;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class SubmitToThreadPool
implements MessageProcessingPolicy {
    protected TP tp;
    protected short tp_id;
    protected Log log;

    protected TP getTransport() {
        return this.tp;
    }

    @Override
    public void init(TP transport) {
        this.tp = transport;
        this.tp_id = this.tp.getId();
        this.log = this.tp.getLog();
    }

    @Override
    public boolean loopback(Message msg, boolean oob) {
        return this.tp.getThreadPool().execute(new SingleLoopbackHandler(msg));
    }

    @Override
    public boolean process(Message msg, boolean oob) {
        return this.tp.getThreadPool().execute(new SingleMessageHandler(msg));
    }

    @Override
    public boolean process(MessageBatch batch, boolean oob) {
        boolean removed;
        if (oob && (removed = this.removeAndDispatchNonBundledMessages(batch)) && batch.isEmpty()) {
            return true;
        }
        return this.tp.getThreadPool().execute(new BatchHandler(batch));
    }

    protected boolean removeAndDispatchNonBundledMessages(MessageBatch oob_batch) {
        if (oob_batch == null) {
            return false;
        }
        AsciiString tmp = oob_batch.clusterName();
        byte[] cname = tmp != null ? tmp.chars() : null;
        boolean removed = false;
        Iterator<Message> it = oob_batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            if (!msg.isFlagSet(Message.Flag.DONT_BUNDLE) || !msg.isFlagSet(Message.Flag.OOB)) continue;
            it.remove();
            if (this.tp.statsEnabled()) {
                this.tp.getMessageStats().incrNumOOBMsgsReceived(1);
            }
            this.tp.getThreadPool().execute(new SingleMessageHandlerWithClusterName(msg, cname));
            removed = true;
        }
        return removed;
    }

    public class BatchHandler
    implements Runnable {
        protected MessageBatch batch;

        public BatchHandler(MessageBatch batch) {
            this.batch = batch;
        }

        public MessageBatch getBatch() {
            return this.batch;
        }

        @Override
        public void run() {
            if (this.batch == null || !this.batch.multicast() && SubmitToThreadPool.this.tp.unicastDestMismatch(this.batch.dest())) {
                return;
            }
            if (SubmitToThreadPool.this.tp.statsEnabled()) {
                boolean oob;
                int batch_size = this.batch.size();
                MsgStats msg_stats = SubmitToThreadPool.this.tp.getMessageStats();
                boolean bl = oob = this.batch.getMode() == MessageBatch.Mode.OOB;
                if (oob) {
                    msg_stats.incrNumOOBMsgsReceived(batch_size);
                } else {
                    msg_stats.incrNumMsgsReceived(batch_size);
                }
                msg_stats.incrNumBatchesReceived(1);
                msg_stats.incrNumBytesReceived(this.batch.length());
                SubmitToThreadPool.this.tp.avgBatchSize().add(batch_size);
            }
            this.passBatchUp();
        }

        protected void passBatchUp() {
            SubmitToThreadPool.this.tp.passBatchUp(this.batch, true, true);
        }
    }

    protected class SingleMessageHandlerWithClusterName
    extends SingleMessageHandler {
        protected final byte[] cluster;

        @Override
        protected byte[] getClusterName() {
            return this.cluster;
        }

        protected SingleMessageHandlerWithClusterName(Message msg, byte[] cluster_name) {
            super(msg);
            this.cluster = cluster_name;
        }
    }

    public class SingleMessageHandler
    implements Runnable {
        protected final Message msg;

        protected SingleMessageHandler(Message msg) {
            this.msg = msg;
        }

        public Message getMessage() {
            return this.msg;
        }

        @Override
        public void run() {
            Address dest = this.msg.getDest();
            boolean multicast = dest == null;
            try {
                if (SubmitToThreadPool.this.tp.statsEnabled()) {
                    MsgStats msg_stats = SubmitToThreadPool.this.tp.getMessageStats();
                    boolean oob = this.msg.isFlagSet(Message.Flag.OOB);
                    if (oob) {
                        msg_stats.incrNumOOBMsgsReceived(1);
                    } else {
                        msg_stats.incrNumMsgsReceived(1);
                    }
                    msg_stats.incrNumBytesReceived(this.msg.getLength());
                }
                byte[] cname = this.getClusterName();
                SubmitToThreadPool.this.tp.passMessageUp(this.msg, cname, true, multicast, true);
            }
            catch (Throwable t) {
                SubmitToThreadPool.this.log.error(Util.getMessage("PassUpFailure"), t);
            }
        }

        protected byte[] getClusterName() {
            TpHeader hdr = (TpHeader)this.msg.getHeader(SubmitToThreadPool.this.tp_id);
            return hdr.getClusterName();
        }
    }

    public class SingleLoopbackHandler
    implements Runnable {
        protected final Message msg;

        public SingleLoopbackHandler(Message msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            SubmitToThreadPool.this.tp.passMessageUp(this.msg, null, false, this.msg.getDest() == null, false);
        }
    }
}

