/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs;

import java.io.Closeable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.BaseServer;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.TcpBaseServer;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.TcpConnection;
import org.apache.activemq.artemis.shaded.org.jgroups.util.DefaultSocketFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.DefaultThreadFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.SocketFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ThreadFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class TcpServer
extends TcpBaseServer {
    protected ServerSocket srv_sock;
    protected Thread acceptor;
    protected boolean log_accept_error = true;

    public boolean getLogAcceptError() {
        return this.log_accept_error;
    }

    public TcpServer setLogAcceptError(boolean l) {
        this.log_accept_error = l;
        return this;
    }

    public TcpServer(InetAddress bind_addr, int port) throws Exception {
        this(new DefaultThreadFactory("tcp", false), new DefaultSocketFactory(), bind_addr, port, port + 50, null, 0, 0);
    }

    public TcpServer(ThreadFactory thread_factory, SocketFactory socket_factory, InetAddress bind_addr, int srv_port, int end_port, InetAddress external_addr, int external_port, int recv_buf_size) throws Exception {
        this(thread_factory, socket_factory, bind_addr, srv_port, end_port, external_addr, external_port, recv_buf_size, "jgroups.tcp.server");
    }

    public TcpServer(ThreadFactory thread_factory, SocketFactory socket_factory, InetAddress bind_addr, int srv_port, int end_port, InetAddress external_addr, int external_port, int recv_buf_size, String service_name) throws Exception {
        super(thread_factory, socket_factory, recv_buf_size);
        this.srv_sock = Util.createServerSocket(this.socket_factory, service_name, bind_addr, srv_port, end_port, recv_buf_size);
        this.acceptor = this.factory.newThread(new Acceptor(), "TcpServer.Acceptor[" + this.srv_sock.getLocalPort() + "]");
        this.local_addr = TcpServer.localAddress(bind_addr, this.srv_sock.getLocalPort(), external_addr, external_port);
        this.addConnectionListener(this);
    }

    @Override
    public void start() throws Exception {
        if (this.running.compareAndSet(false, true)) {
            this.acceptor.start();
            super.start();
        }
    }

    @Override
    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            Util.close((Closeable)this.srv_sock);
            Util.interruptAndWaitToDie(this.acceptor);
            super.stop();
        }
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        @Override
        public void run() {
            while (!TcpServer.this.srv_sock.isClosed() && !Thread.currentThread().isInterrupted()) {
                Socket client_sock = null;
                try {
                    client_sock = TcpServer.this.srv_sock.accept();
                    this.handleAccept(client_sock);
                }
                catch (Exception ex) {
                    if (ex instanceof SocketException && TcpServer.this.srv_sock.isClosed() || Thread.currentThread().isInterrupted()) break;
                    if (TcpServer.this.log_accept_error) {
                        TcpServer.this.log.warn(Util.getMessage("AcceptError"), TcpServer.this.local_addr, client_sock, ex);
                    }
                    Util.close((Closeable)client_sock);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleAccept(Socket client_sock) throws Exception {
            TcpConnection conn = null;
            try {
                conn = new TcpConnection(client_sock, TcpServer.this);
                Address peer_addr = conn.peerAddress();
                Acceptor acceptor = this;
                synchronized (acceptor) {
                    boolean replace;
                    boolean conn_exists = TcpServer.this.hasConnection(peer_addr);
                    boolean bl = replace = conn_exists && TcpServer.this.use_peer_connections && TcpServer.this.local_addr.compareTo(peer_addr) < 0;
                    if (!conn_exists || replace) {
                        if (TcpServer.this.use_acks) {
                            conn.send(BaseServer.OK, 0, BaseServer.OK.length);
                        }
                        TcpServer.this.replaceConnection(peer_addr, conn);
                        conn.start();
                        TcpServer.this.log.trace("%s: accepted connection from %s", TcpServer.this.local_addr, peer_addr);
                    } else {
                        TcpServer.this.log.trace("%s: rejected connection from %s %s", TcpServer.this.local_addr, peer_addr, BaseServer.explanation(conn_exists, replace));
                        if (TcpServer.this.use_acks) {
                            conn.send(BaseServer.FAIL, 0, BaseServer.FAIL.length);
                        }
                        conn.flush();
                        Util.close((Closeable)conn);
                    }
                }
            }
            catch (Exception ex) {
                Util.close(conn);
                throw ex;
            }
        }
    }
}

