/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import org.apache.activemq.artemis.shaded.org.jgroups.Lifecycle;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.PropertyConverter;
import org.apache.activemq.artemis.shaded.org.jgroups.util.DefaultSocketFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.SocketFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.SslContextFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.StackType;
import org.apache.activemq.artemis.shaded.org.jgroups.util.TLSClientAuth;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class TLS
implements Lifecycle {
    @Property(description="Enables TLS; when true, SSL sockets will be used instead of regular sockets")
    protected boolean enabled;
    @Property(description="One or more TLS protocol names to use, e.g. TLSv1.3. Setting this requires configuring key and trust stores")
    protected String[] protocols;
    @Property(description="The list of cipher suites")
    protected String[] cipher_suites;
    @Property(description="The security provider. Defaults to null, which will use the default JDK provider")
    protected String provider;
    @Property(description="Fully qualified path to the keystore")
    protected String keystore_path;
    @Property(description="Keystore password", exposeAsManagedAttribute=false)
    protected String keystore_password;
    @Property(description="The type of the keystore")
    protected String keystore_type = "pkcs12";
    @Property(description="Alias used for fetching the key")
    protected String keystore_alias;
    @Property(description="Fully qualified path to the truststore")
    protected String truststore_path;
    @Property(description="The password of the truststore", exposeAsManagedAttribute=false)
    protected String truststore_password;
    @Property(description="The type of the truststore")
    protected String truststore_type = "pkcs12";
    @Property(description="Defines whether client certificate authentication is required. Legal values are NONE, WANT or NEED")
    protected TLSClientAuth client_auth = TLSClientAuth.NONE;
    @Property(description="A list of regular expression that servers use to match and accept SNI host names", converter=SniMatcherConverter.class)
    protected List<SNIMatcher> sni_matchers = new ArrayList<SNIMatcher>();

    public boolean enabled() {
        return this.enabled;
    }

    public TLS enabled(boolean e) {
        this.enabled = e;
        return this;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public TLS setProtocols(String[] p) {
        this.protocols = p;
        return this;
    }

    public String[] getCipherSuites() {
        return this.cipher_suites;
    }

    public TLS setCipherSuites(String[] c) {
        this.cipher_suites = c;
        return this;
    }

    public String getProvider() {
        return this.provider;
    }

    public TLS setProvider(String p) {
        this.provider = p;
        return this;
    }

    public String getKeystorePath() {
        return this.keystore_path;
    }

    public TLS setKeystorePath(String k) {
        this.keystore_path = k;
        return this;
    }

    public String getKeystorePassword() {
        return this.keystore_password;
    }

    public TLS setKeystorePassword(String k) {
        this.keystore_password = k;
        return this;
    }

    public String getKeystoreType() {
        return this.keystore_type;
    }

    public TLS setKeystoreType(String k) {
        this.keystore_type = k;
        return this;
    }

    public String getKeystoreAlias() {
        return this.keystore_alias;
    }

    public TLS setKeystoreAlias(String k) {
        this.keystore_alias = k;
        return this;
    }

    public String getTruststorePath() {
        return this.truststore_path;
    }

    public TLS setTruststorePath(String t) {
        this.truststore_path = t;
        return this;
    }

    public String getTruststorePassword() {
        return this.truststore_password;
    }

    public TLS setTruststorePassword(String t) {
        this.truststore_password = t;
        return this;
    }

    public String getTruststoreType() {
        return this.truststore_type;
    }

    public TLS setTruststoreType(String t) {
        this.truststore_type = t;
        return this;
    }

    public TLSClientAuth getClientAuth() {
        return this.client_auth;
    }

    public TLS setClientAuth(TLSClientAuth c) {
        this.client_auth = c;
        return this;
    }

    public List<SNIMatcher> getSniMatchers() {
        return this.sni_matchers;
    }

    public TLS setSniMatchers(List<SNIMatcher> s) {
        this.sni_matchers = s;
        return this;
    }

    @Override
    public void init() throws Exception {
        File tmp;
        if (this.truststore_path == null) {
            this.truststore_path = this.keystore_path;
            this.truststore_type = this.keystore_type;
            this.truststore_password = this.keystore_password;
        }
        if (this.keystore_path != null && !(tmp = new File(this.keystore_path)).exists()) {
            throw new FileNotFoundException(this.keystore_path);
        }
    }

    public SSLContext createContext() {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.classLoader(this.getClass().getClassLoader()).sslProtocol("TLS").provider(this.provider).keyStoreFileName(this.keystore_path).keyStorePassword(this.keystore_password).keyStoreType(this.keystore_type).keyAlias(this.keystore_alias).trustStoreFileName(this.truststore_path).trustStorePassword(this.truststore_password).trustStoreType(this.truststore_type);
        return sslContextFactory.getContext();
    }

    public SocketFactory createSocketFactory() {
        SSLContext context = this.createContext();
        return this.createSocketFactory(context);
    }

    public SocketFactory createSocketFactory(SSLContext context) {
        DefaultSocketFactory socketFactory = new DefaultSocketFactory(context);
        SSLParameters serverParameters = new SSLParameters();
        if (this.protocols != null) {
            serverParameters.setProtocols(this.protocols);
        }
        if (this.cipher_suites != null) {
            serverParameters.setCipherSuites(this.cipher_suites);
        }
        serverParameters.setSNIMatchers(this.sni_matchers);
        switch (this.client_auth) {
            case NEED: {
                serverParameters.setNeedClientAuth(true);
                break;
            }
            case WANT: {
                serverParameters.setWantClientAuth(true);
                break;
            }
        }
        socketFactory.setServerSocketConfigurator(s -> ((SSLServerSocket)s).setSSLParameters(serverParameters));
        return socketFactory;
    }

    public static class SniMatcherConverter
    implements PropertyConverter {
        @Override
        public Object convert(Object obj, Class<?> field_type, String name, String val, boolean check_scope, StackType ip_version) throws Exception {
            if (val == null) {
                return null;
            }
            List<String> list = Util.parseStringList(val, ",");
            ArrayList<SNIMatcher> retval = new ArrayList<SNIMatcher>(list.size());
            for (String s : list) {
                Class<?> cl = Util.loadClass(s, this.getClass());
                SNIMatcher m = (SNIMatcher)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                retval.add(m);
            }
            return retval;
        }

        @Override
        public String toString(Object value) {
            return value != null ? value.getClass().getSimpleName() : null;
        }
    }
}

