/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.demos;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.ObjectMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.Receiver;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.DefaultRouteStatusListener;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.RELAY;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.RELAY3;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.SiteUUID;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.Topology;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ExtendedUUID;
import org.apache.activemq.artemis.shaded.org.jgroups.util.UUID;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class RelayDemo
implements Receiver {
    protected static final String SITE_MASTERS = "site-masters";
    protected static final String SENDTO = "sendto";
    protected JChannel ch;
    protected RELAY relay;

    public static void main(String[] args) throws Exception {
        String props = "udp.xml";
        String name = null;
        boolean print_route_status = true;
        boolean nohup = false;
        boolean use_view_handler = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            if (args[i].equals("-print_route_status")) {
                print_route_status = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if (args[i].equals("-nohup")) {
                nohup = true;
                continue;
            }
            if ("-use_view_handler".equals(args[i])) {
                use_view_handler = Boolean.parseBoolean(args[++i]);
                continue;
            }
            System.out.println("RelayDemo [-props props] [-name name] [-print_route_status false|true] [-nohup] [-use_view_handler [true|false]]");
            return;
        }
        RelayDemo demo = new RelayDemo();
        demo.start(props, name, print_route_status, nohup, use_view_handler);
    }

    @Override
    public void receive(Message msg) {
        Address sender = msg.getSrc();
        System.out.println("<< " + msg.getObject() + " from " + sender);
        Address dst = msg.getDest();
        if (dst == null) {
            ObjectMessage rsp = new ObjectMessage(msg.getSrc(), "response");
            try {
                this.ch.send(rsp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.printf("Local view: %s\n", new_view);
    }

    protected void start(String props, String name, boolean print_route_status, boolean nohup, boolean use_view_handler) throws Exception {
        ExtendedUUID.setPrintFunction(UUID::printName);
        this.ch = new JChannel(props).setReceiver(this);
        if (name != null) {
            this.ch.setName(name);
        }
        this.relay = (RELAY)this.ch.getProtocolStack().findProtocol((Class<? extends Protocol>)RELAY.class);
        if (this.relay == null) {
            throw new IllegalStateException(String.format("Protocol %s not found", RELAY.class.getSimpleName()));
        }
        String site_name = this.relay.site();
        if (print_route_status) {
            this.relay.setRouteStatusListener(new DefaultRouteStatusListener(() -> this.relay.addr()).verbose(true));
        }
        if (use_view_handler) {
            this.relay.topo().setViewHandler((s, v) -> {
                if (!s.equals(this.relay.getSite())) {
                    System.out.printf("Global view: %s\n", v);
                }
            });
        }
        this.ch.connect(site_name);
        if (!nohup) {
            this.eventLoop(this.ch);
            Util.close((Closeable)this.ch);
        }
    }

    protected void eventLoop(JChannel ch) {
        while (true) {
            try {
                String line;
                while ((line = Util.readStringFromStdin(": ")) != null) {
                    if (this.process(line)) continue;
                    ObjectMessage msg = new ObjectMessage(null, line);
                    ch.send(msg);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected boolean process(String line) {
        if (line == null || line.isEmpty()) {
            return true;
        }
        if (line.equalsIgnoreCase(SITE_MASTERS) || line.equalsIgnoreCase("sm")) {
            System.out.printf("site masters in %s: %s\n", this.relay.site(), this.relay.siteMasters());
            return true;
        }
        if (line.equalsIgnoreCase("help")) {
            RelayDemo.help();
            return true;
        }
        if (line.equalsIgnoreCase("mbrs")) {
            System.out.printf("%s: local members: %s\n", this.relay.getAddress(), this.relay.members());
            return true;
        }
        if (line.equalsIgnoreCase("sites")) {
            System.out.printf("configured sites: %s\n", this.relay.getSites());
            return true;
        }
        if (line.startsWith("topo") && this.relay instanceof RELAY3) {
            System.out.printf("\n%s\n", this.printTopo(line, "topo", true));
            return true;
        }
        if (line.startsWith("pt") && this.relay instanceof RELAY3) {
            System.out.printf("\n%s\n", this.printTopo(line, "pt", false));
            return true;
        }
        if (line.startsWith("routes")) {
            System.out.printf("%s\n", this.relay.printRoutes());
            return true;
        }
        if (line.startsWith(SENDTO)) {
            this.sendTo(line);
            return true;
        }
        return false;
    }

    protected void sendTo(String line) {
        String[] list = line.split("\\s");
        long sleep = Long.parseLong(list[list.length - 1]);
        int times = Integer.parseInt(list[list.length - 2]);
        String dest = list[1];
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(list).subList(2, list.length - 2));
        String msg = String.join((CharSequence)" ", tmp);
        String[] s = dest.split(":");
        String member_name = s[0];
        String site_name = s[1];
        Map<String, View> cache = this.relay.topo().cache();
        View v = cache.get(site_name);
        if (v == null) {
            throw new IllegalArgumentException(String.format("site %s not found in cache", site_name));
        }
        SiteUUID target = null;
        for (Address addr : v) {
            SiteUUID sa = (SiteUUID)addr;
            if (!member_name.equals(sa.getName())) continue;
            target = sa;
            break;
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("member %s not found in cache", member_name));
        }
        try {
            for (int i = 1; i <= times; ++i) {
                this.ch.send((Address)target, String.format("%s [#%d]", msg, i));
                Util.sleep(sleep);
            }
        }
        catch (Exception ex) {
            System.err.printf("failed sending msg to %s: %s\n", target, ex);
        }
    }

    protected String printTopo(String line, String command, boolean refresh) {
        String sub = line.substring(command.length()).trim();
        String site = null;
        if (sub != null && !sub.isEmpty()) {
            String[] tmp = sub.split(" ");
            site = tmp.length > 0 && !tmp[0].isEmpty() ? tmp[0].trim() : null;
        }
        Topology topo = this.relay.topo();
        if (refresh) {
            topo.removeAll(site != null ? List.of(site) : null).refresh(site);
            Util.sleep(100L);
        }
        return topo.print(site);
    }

    protected static void help() {
        System.out.println("\ncommands:\nhelp\nmbrs: prints the local members\nsite-masters (sm): prints the site masters of this site\nsites: prints the configured sites\ntopo: prints the topology (site masters and local members of all sites)\npt: prints the cache (no refresh)\nroutes: prints all routes (if site master)\nsendto <dest> msg <number of times> <sleep (ms)>\n");
    }
}

