/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core;

import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public interface CoreRemotingConnection
extends RemotingConnection {
    public int getChannelVersion();

    default public boolean isVersionBeforeAddressChange() {
        int version = this.getChannelVersion();
        return version > 0 && version < 129;
    }

    default public boolean isVersionBeforeAsyncResponseChange() {
        int version = this.getChannelVersion();
        return version > 0 && version < 130;
    }

    default public boolean isVersionSupportConsumerPriority() {
        int version = this.getChannelVersion();
        return version >= 130;
    }

    default public boolean isVersionNewFQQN() {
        int version = this.getChannelVersion();
        return version >= 130;
    }

    default public boolean isVersionSupportClientID() {
        int version = this.getChannelVersion();
        return version >= 131;
    }

    default public boolean isVersionSupportRouting() {
        int version = this.getChannelVersion();
        return version >= 131;
    }

    default public boolean isVersionSupportCommitV2() {
        int version = this.getChannelVersion();
        return version >= 132;
    }

    default public boolean isVersionUsingLongOnPageReplication() {
        int version = this.getChannelVersion();
        return version >= 133;
    }

    default public boolean isBeforeTwoEighteen() {
        int version = this.getChannelVersion();
        return version < 131;
    }

    default public boolean isBeforeProducerMetricsChanged() {
        int version = this.getChannelVersion();
        return version < 134;
    }

    public void setChannelVersion(int var1);

    public Channel getChannel(long var1, int var3);

    public void putChannel(long var1, Channel var3);

    public boolean removeChannel(long var1);

    public long generateChannelID();

    public void syncIDGeneratorSequence(long var1);

    public long getIDGeneratorSequence();

    public long getBlockingCallTimeout();

    public long getBlockingCallFailoverTimeout();

    public Object getTransferLock();

    public ActiveMQPrincipal getDefaultActiveMQPrincipal();

    public boolean blockUntilWritable(long var1);
}

