/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.util.AsciiString;

public class TpHeader
extends Header {
    protected byte[] cluster_name;
    public static final byte REQ = 1;
    public static final byte RSP = 2;
    protected byte flag;
    protected int index;

    public TpHeader() {
    }

    public TpHeader(String n) {
        int len = n.length();
        this.cluster_name = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.cluster_name[i] = (byte)n.charAt(i);
        }
    }

    public TpHeader(String n, byte flag, int index) {
        int len = n.length();
        this.cluster_name = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.cluster_name[i] = (byte)n.charAt(i);
        }
        this.flag = flag;
        this.index = index;
    }

    public TpHeader(AsciiString n) {
        this.cluster_name = n != null ? n.chars() : null;
    }

    public TpHeader(AsciiString n, byte flag, int index) {
        this.cluster_name = n != null ? n.chars() : null;
        this.flag = flag;
        this.index = index;
    }

    public byte[] getClusterName() {
        return this.cluster_name;
    }

    public byte[] clusterName() {
        return this.cluster_name;
    }

    public byte flag() {
        return this.flag;
    }

    public int index() {
        return this.index;
    }

    public TpHeader(byte[] n) {
        this.cluster_name = n;
    }

    @Override
    public Supplier<? extends Header> create() {
        return TpHeader::new;
    }

    @Override
    public short getMagicId() {
        return 60;
    }

    @Override
    public String toString() {
        return String.format("[cluster=%s]", this.cluster_name != null ? new String(this.cluster_name) : "null");
    }

    @Override
    public int serializedSize() {
        int retval = this.cluster_name != null ? 2 + this.cluster_name.length : 2;
        return retval + 1 + (this.flag > 0 ? 4 : 0);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        int length = this.cluster_name != null ? this.cluster_name.length : -1;
        out.writeShort(length);
        if (this.cluster_name != null) {
            out.write(this.cluster_name, 0, this.cluster_name.length);
        }
        out.writeByte(this.flag);
        if (this.flag > 0) {
            out.writeInt(this.index);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        short len = in.readShort();
        if (len >= 0) {
            this.cluster_name = new byte[len];
            in.readFully(this.cluster_name, 0, this.cluster_name.length);
        }
        this.flag = in.readByte();
        if (this.flag > 0) {
            this.index = in.readInt();
        }
    }
}

