/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;

@MBean(description="Detects unicast loopback messages")
public class DETECT_LOOPBACKS
extends Protocol {
    @Property(description="Prints to stdout")
    protected boolean print_to_stdout = true;
    protected final AtomicInteger count = new AtomicInteger();

    @Override
    public Object down(Message msg) {
        if (Objects.equals(this.local_addr, msg.getDest())) {
            String s = String.format("[%d] %s, headers: %s", this.count.getAndIncrement(), msg, msg.getHeaders());
            if (this.print_to_stdout) {
                System.out.printf("%s\n", s);
            } else if (this.log.isTraceEnabled()) {
                this.log.trace(s);
            }
        }
        return this.down_prot.down(msg);
    }
}

