/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Validator;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.XmlProvider;
import org.apache.activemq.artemis.utils.sm.SecurityManagerShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static String CONSIDER_OS_ENV_PROP = "org.apache.activemq.artemis.utils.considerOsEnv";
    private static final boolean considerOsEnv = Boolean.parseBoolean(System.getProperty(CONSIDER_OS_ENV_PROP, "true"));

    private XMLUtil() {
    }

    public static Element streamToElement(InputStream inputStream) throws Exception {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            Element element = XMLUtil.readerToElement(reader);
            return element;
        }
    }

    public static Element stringToElement(String s) throws Exception {
        return XMLUtil.readerToElement(new StringReader(s));
    }

    public static Element urlToElement(URL url) throws Exception {
        return XMLUtil.streamToElement(url.openStream());
    }

    public static String readerToString(Reader r) throws Exception {
        int c;
        StringBuilder builder = new StringBuilder();
        while ((c = r.read()) != -1) {
            builder.append((char)c);
        }
        return builder.toString();
    }

    public static Element readerToElement(Reader r) throws Exception {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        properties.put("XINCLUDE_AWARE", true);
        properties.put("NAMESPACE_AWARE", true);
        DocumentBuilder parser = XmlProvider.newDocumentBuilder(null, properties);
        Document doc = XMLUtil.replaceSystemPropsInXml(parser.parse(new InputSource(new StringReader(XMLUtil.replaceSystemPropsInString(XMLUtil.readerToString(r))))));
        return doc.getDocumentElement();
    }

    public static String elementToString(Node n) {
        NodeList children;
        String name = n.getNodeName();
        short type = n.getNodeType();
        if (4 == type) {
            return "<![CDATA[" + n.getNodeValue() + "]]>";
        }
        if (name.startsWith("#")) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(name);
        NamedNodeMap attrs = n.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                sb.append(' ').append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
            }
        }
        if ((children = n.getChildNodes()).getLength() == 0) {
            String textContent = XMLUtil.getTextContent(n);
            if (textContent != null && !"".equals(textContent)) {
                sb.append(textContent).append("</").append(name).append('>');
            } else {
                sb.append("/>").append('\n');
            }
        } else {
            String textContent;
            sb.append('>').append('\n');
            boolean hasValidChildren = false;
            for (int i = 0; i < children.getLength(); ++i) {
                String childToString = XMLUtil.elementToString(children.item(i));
                if ("".equals(childToString)) continue;
                sb.append(childToString);
                hasValidChildren = true;
            }
            if (!hasValidChildren && (textContent = XMLUtil.getTextContent(n)) != null) {
                sb.append(textContent);
            }
            sb.append("</").append(name).append('>');
        }
        return sb.toString();
    }

    public static String getTextContent(Node n) {
        if (n.hasChildNodes()) {
            StringBuilder sb = new StringBuilder();
            NodeList nl = n.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                sb.append(XMLUtil.elementToString(nl.item(i)));
                if (i >= nl.getLength() - 1) continue;
                sb.append('\n');
            }
            String s = sb.toString();
            if (!s.isEmpty()) {
                return s;
            }
        }
        return n.getTextContent();
    }

    public static void assertEquivalent(Node node, Node node2) {
        if (node == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.firstNodeNull();
        }
        if (node2 == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.secondNodeNull();
        }
        if (!node.getNodeName().equals(node2.getNodeName())) {
            throw ActiveMQClientMessageBundle.BUNDLE.nodeHaveDifferentNames();
        }
        int attrCount = 0;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            attrCount = attrs.getLength();
        }
        int attrCount2 = 0;
        NamedNodeMap attrs2 = node2.getAttributes();
        if (attrs2 != null) {
            attrCount2 = attrs2.getLength();
        }
        if (attrCount != attrCount2) {
            throw ActiveMQClientMessageBundle.BUNDLE.nodeHaveDifferentAttNumber();
        }
        block0: for (int i = 0; i < attrCount; ++i) {
            Node n = attrs.item(i);
            String name = n.getNodeName();
            String value = n.getNodeValue();
            for (int j = 0; j < attrCount; ++j) {
                Node n2 = attrs2.item(j);
                String name2 = n2.getNodeName();
                String value2 = n2.getNodeValue();
                if (name.equals(name2) && value.equals(value2)) continue block0;
            }
            throw ActiveMQClientMessageBundle.BUNDLE.attsDontMatch(name, value);
        }
        boolean hasChildren = node.hasChildNodes();
        if (hasChildren != node2.hasChildNodes()) {
            throw ActiveMQClientMessageBundle.BUNDLE.oneNodeHasChildren();
        }
        if (hasChildren) {
            NodeList nl = node.getChildNodes();
            NodeList nl2 = node2.getChildNodes();
            short[] toFilter = new short[]{3, 2, 8};
            List<Node> nodes = XMLUtil.filter(nl, toFilter);
            List<Node> nodes2 = XMLUtil.filter(nl2, toFilter);
            int length = nodes.size();
            if (length != nodes2.size()) {
                throw ActiveMQClientMessageBundle.BUNDLE.nodeHasDifferentChildNumber();
            }
            for (int i = 0; i < length; ++i) {
                Node n = nodes.get(i);
                Node n2 = nodes2.get(i);
                XMLUtil.assertEquivalent(n, n2);
            }
        }
    }

    public static String stripCDATA(String s) {
        if ((s = s.trim()).startsWith("<![CDATA[")) {
            int i = (s = s.substring(9)).indexOf("]]>");
            if (i == -1) {
                throw new IllegalStateException("argument starts with <![CDATA[ but cannot find pairing ]]>");
            }
            s = s.substring(0, i);
        }
        return s;
    }

    public static String replaceSystemPropsInString(String xml) {
        while (xml.contains("${")) {
            String sysProp;
            int start = xml.indexOf("${");
            int end = xml.indexOf("}", start) + 1;
            if (start < 0 || end <= 0) break;
            String subString = xml.substring(start, end);
            String prop = subString.substring(2, subString.length() - 1).trim();
            String val = "";
            if (prop.contains(":")) {
                String[] parts = prop.split(":", 2);
                prop = parts[0].trim();
                val = parts[1].trim();
            }
            if ((sysProp = System.getProperty(prop)) == null && considerOsEnv) {
                sysProp = System.getenv(prop);
            }
            if (sysProp == null) {
                sysProp = val;
            }
            logger.debug("replacing {} with {}", (Object)subString, (Object)sysProp);
            xml = xml.replace(subString, sysProp);
        }
        return xml;
    }

    public static Document replaceSystemPropsInXml(Document doc) {
        NodeList nodeList = doc.getElementsByTagName("*");
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            int j;
            Node node = nodeList.item(i);
            if (node == null || node.getNodeType() != 1) continue;
            if (node.hasAttributes()) {
                NamedNodeMap attributes = node.getAttributes();
                for (j = 0; j < attributes.getLength(); ++j) {
                    Node attribute = attributes.item(j);
                    attribute.setTextContent(XMLUtil.replaceSystemPropsInString(attribute.getTextContent()));
                }
            }
            if (!node.hasChildNodes()) continue;
            NodeList children = node.getChildNodes();
            for (j = 0; j < children.getLength(); ++j) {
                String value = children.item(j).getNodeValue();
                if (value == null) continue;
                children.item(j).setNodeValue(XMLUtil.replaceSystemPropsInString(value));
            }
        }
        return doc;
    }

    public static long parseLong(Node elem) {
        String value = elem.getTextContent().trim();
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw ActiveMQClientMessageBundle.BUNDLE.mustBeLong(elem, value);
        }
    }

    public static int parseInt(Node elem) {
        String value = elem.getTextContent().trim();
        return XMLUtil.parseInt(elem, value);
    }

    public static int parseInt(Node elem, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw ActiveMQClientMessageBundle.BUNDLE.mustBeInteger(elem, value);
        }
    }

    public static boolean parseBoolean(Node elem) {
        String value = elem.getTextContent().trim();
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            throw ActiveMQClientMessageBundle.BUNDLE.mustBeBoolean(elem, value);
        }
    }

    public static double parseDouble(Node elem) {
        String value = elem.getTextContent().trim();
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw ActiveMQClientMessageBundle.BUNDLE.mustBeDouble(elem, value);
        }
    }

    public static void validate(Node node, String schemaFile) throws Exception {
        Validator validator = XmlProvider.newValidator(new URL(XMLUtil.findResource(schemaFile).toURI().toASCIIString()));
        try {
            validator.validate(new DOMSource(node));
        }
        catch (SAXException e) {
            ActiveMQClientLogger.LOGGER.errorOnXMLTransformInvalidConf(e);
            throw new IllegalStateException("Invalid configuration", e);
        }
    }

    private static List<Node> filter(NodeList nl, short[] typesToFilter) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        block0: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            short type = n.getNodeType();
            for (short typeToFilter : typesToFilter) {
                if (typeToFilter == type) continue block0;
            }
            nodes.add(n);
        }
        return nodes;
    }

    public static URL findResource(String resourceName) {
        return SecurityManagerShim.doPrivileged(() -> ClassloadingUtil.findResource(resourceName));
    }
}

