/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.shaded.io.netty.util.internal.MathUtil;

public abstract class AbstractPool<I, O> {
    public static final int DEFAULT_POOL_CAPACITY = 32;
    private final O[] entries;
    private final int mask;
    private final int shift;

    public AbstractPool() {
        this(32);
    }

    public AbstractPool(int capacity) {
        this.entries = new Object[MathUtil.findNextPositivePowerOfTwo(capacity)];
        this.mask = this.entries.length - 1;
        this.shift = 31 - Integer.numberOfLeadingZeros(this.entries.length);
    }

    protected abstract O create(I var1);

    protected abstract boolean isEqual(O var1, I var2);

    protected int hashCode(I value) {
        return value.hashCode();
    }

    public final O getOrCreate(I value) {
        if (value == null) {
            return null;
        }
        int hashCode = this.hashCode(value);
        int firstIndex = hashCode & this.mask;
        O firstEntry = this.entries[firstIndex];
        if (this.isEqual(firstEntry, value)) {
            return firstEntry;
        }
        int secondIndex = hashCode >> this.shift & this.mask;
        O secondEntry = this.entries[secondIndex];
        if (this.isEqual(secondEntry, value)) {
            return secondEntry;
        }
        O internedEntry = this.create(value);
        int entryIndex = firstEntry == null ? firstIndex : secondIndex;
        this.entries[entryIndex] = internedEntry;
        return internedEntry;
    }
}

