package org.apache.activemq.artemis.shaded.org.jgroups.tests;

import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.atomic.Counter;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.atomic.CounterService;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.locking.LockService;
import org.apache.activemq.artemis.shaded.org.jgroups.fork.ForkChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.CENTRAL_LOCK;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.COUNTER;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.FRAG2;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.ProtocolStack;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

import java.util.concurrent.locks.Lock;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla {
    protected JChannel    ch;

    protected void start(String name) throws Exception {
        ch=new JChannel("/home/bela/fast.xml").name(name);
        ch.connect("cluster");
        ForkChannel fc=new ForkChannel(ch, "counter-stack", "counter-channel", true,
                                       ProtocolStack.ABOVE, FRAG2.class,
                                       new COUNTER(), new CENTRAL_LOCK().setValue("use_thread_id_for_lock_owner", false));

        CounterService counter_service=new CounterService(fc);
        LockService lock_service=new LockService(fc);
        fc.connect("ignore");

        Counter counter=counter_service.getOrCreateCounter("cntr", 0);
        Lock lock=lock_service.getLock("lock");

        boolean looping=true;
        String format="[i] incr [d] decr [l] lock [u] unlock [x] exit\n counter: %d, lock: %s\n";
        while(looping) {

            int c=Util.keyPress(String.format(format, counter.get(), lock));
            switch(c) {
                case 'i':
                    counter.incrementAndGet();
                    break;
                case 'd':
                    counter.decrementAndGet();
                    break;
                case 'l':
                    lock.lock();
                    break;
                case 'u':
                    lock.unlock();
                    break;
                case 'x':
                    looping=false;
                    break;
            }
        }
        Util.close(fc,ch);
    }

    public static void main(String[] args) throws Exception {
        new bla().start(args[0]);
    }

}



