/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.ssl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.activemq.artemis.shaded.io.netty.handler.ssl.SslContext;
import org.apache.activemq.artemis.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.apache.activemq.artemis.shaded.io.netty.handler.ssl.SslProvider;
import org.apache.activemq.artemis.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.apache.activemq.artemis.utils.ClassloadingUtil;

public class SSLSupport {
    public static SSLContext createContext(String keystoreProvider, String keystorePath, String keystorePassword, String trustStoreProvider, String trustStorePath, String trustStorePassword) throws Exception {
        return SSLSupport.createContext(keystoreProvider, keystorePath, keystorePassword, trustStoreProvider, trustStorePath, trustStorePassword, false, null);
    }

    public static SSLContext createContext(String keystoreProvider, String keystorePath, String keystorePassword, String trustStoreProvider, String trustStorePath, String trustStorePassword, String crlPath) throws Exception {
        return SSLSupport.createContext(keystoreProvider, keystorePath, keystorePassword, trustStoreProvider, trustStorePath, trustStorePassword, false, crlPath);
    }

    public static SSLContext createContext(String keystoreProvider, String keystorePath, String keystorePassword, String trustStoreProvider, String trustStorePath, String trustStorePassword, boolean trustAll) throws Exception {
        return SSLSupport.createContext(keystoreProvider, keystorePath, keystorePassword, trustStoreProvider, trustStorePath, trustStorePassword, trustAll, null);
    }

    public static SSLContext createContext(String keystoreProvider, String keystorePath, String keystorePassword, String trustStoreProvider, String trustStorePath, String trustStorePassword, boolean trustAll, String crlPath) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = SSLSupport.loadKeyManagers(keystoreProvider, keystorePath, keystorePassword);
        TrustManager[] trustManagers = SSLSupport.loadTrustManager(trustStoreProvider, trustStorePath, trustStorePassword, trustAll, crlPath);
        context.init(keyManagers, trustManagers, new SecureRandom());
        return context;
    }

    public static SslContext createNettyContext(String keystoreProvider, String keystorePath, String keystorePassword, String trustStoreProvider, String trustStorePath, String trustStorePassword, String sslProvider) throws Exception {
        KeyStore keyStore = SSLSupport.loadKeystore(keystoreProvider, keystorePath, keystorePassword);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keystorePassword.toCharArray());
        return SslContextBuilder.forServer(keyManagerFactory).sslProvider(SslProvider.valueOf(sslProvider)).trustManager(SSLSupport.loadTrustManagerFactory(trustStoreProvider, trustStorePath, trustStorePassword, false, null)).build();
    }

    public static SslContext createNettyClientContext(String keystoreProvider, String keystorePath, String keystorePassword, String trustStoreProvider, String trustStorePath, String trustStorePassword, String sslProvider, boolean trustAll) throws Exception {
        KeyStore keyStore = SSLSupport.loadKeystore(keystoreProvider, keystorePath, keystorePassword);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keystorePassword.toCharArray());
        return SslContextBuilder.forClient().sslProvider(SslProvider.valueOf(sslProvider)).keyManager(keyManagerFactory).trustManager(SSLSupport.loadTrustManagerFactory(trustStoreProvider, trustStorePath, trustStorePassword, trustAll, null)).build();
    }

    public static String[] parseCommaSeparatedListIntoArray(String suites) {
        String[] cipherSuites = suites.split(",");
        for (int i = 0; i < cipherSuites.length; ++i) {
            cipherSuites[i] = cipherSuites[i].trim();
        }
        return cipherSuites;
    }

    public static String parseArrayIntoCommandSeparatedList(String[] suites) {
        StringBuilder supportedSuites = new StringBuilder();
        for (String suite : suites) {
            supportedSuites.append(suite);
            supportedSuites.append(", ");
        }
        return supportedSuites.delete(supportedSuites.length() - 2, supportedSuites.length()).toString();
    }

    private static TrustManagerFactory loadTrustManagerFactory(String trustStoreProvider, String trustStorePath, String trustStorePassword, boolean trustAll, String crlPath) throws Exception {
        if (trustAll) {
            return InsecureTrustManagerFactory.INSTANCE;
        }
        if (!(trustStorePath != null || trustStoreProvider != null && "PKCS11".equals(trustStoreProvider.toUpperCase()))) {
            return null;
        }
        TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStore = SSLSupport.loadKeystore(trustStoreProvider, trustStorePath, trustStorePassword);
        boolean ocsp = Boolean.valueOf(Security.getProperty("ocsp.enable"));
        boolean initialized = false;
        if ((ocsp || crlPath != null) && TrustManagerFactory.getDefaultAlgorithm().equalsIgnoreCase("PKIX")) {
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            if (crlPath != null) {
                pkixParams.setRevocationEnabled(true);
                Collection<? extends CRL> crlList = SSLSupport.loadCRL(crlPath);
                if (crlList != null) {
                    pkixParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crlList)));
                }
            }
            trustMgrFactory.init(new CertPathTrustManagerParameters(pkixParams));
            initialized = true;
        }
        if (!initialized) {
            trustMgrFactory.init(trustStore);
        }
        return trustMgrFactory;
    }

    private static TrustManager[] loadTrustManager(String trustStoreProvider, String trustStorePath, String trustStorePassword, boolean trustAll, String crlPath) throws Exception {
        TrustManagerFactory trustManagerFactory = SSLSupport.loadTrustManagerFactory(trustStoreProvider, trustStorePath, trustStorePassword, trustAll, crlPath);
        if (trustManagerFactory == null) {
            return null;
        }
        return trustManagerFactory.getTrustManagers();
    }

    private static Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        if (crlPath == null) {
            return null;
        }
        URL resource = SSLSupport.validateStoreURL(crlPath);
        try (InputStream is = resource.openStream();){
            Collection<? extends CRL> collection = CertificateFactory.getInstance("X.509").generateCRLs(is);
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeystore(String keystoreProvider, String keystorePath, String keystorePassword) throws Exception {
        KeyStore ks = KeyStore.getInstance(keystoreProvider);
        InputStream in = null;
        try {
            if (keystorePath != null) {
                URL keystoreURL = SSLSupport.validateStoreURL(keystorePath);
                in = keystoreURL.openStream();
            }
            ks.load(in, keystorePassword == null ? null : keystorePassword.toCharArray());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    private static KeyManager[] loadKeyManagers(String keyStoreProvider, String keystorePath, String keystorePassword) throws Exception {
        KeyManagerFactory factory = SSLSupport.loadKeyManagerFactory(keyStoreProvider, keystorePath, keystorePassword);
        if (factory == null) {
            return null;
        }
        return factory.getKeyManagers();
    }

    private static KeyManagerFactory loadKeyManagerFactory(String keyStoreProvider, String keystorePath, String keystorePassword) throws Exception {
        if (!(keystorePath != null || keyStoreProvider != null && "PKCS11".equals(keyStoreProvider.toUpperCase()))) {
            return null;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = SSLSupport.loadKeystore(keyStoreProvider, keystorePath, keystorePassword);
        kmf.init(ks, keystorePassword == null ? null : keystorePassword.toCharArray());
        return kmf;
    }

    private static URL validateStoreURL(String storePath) throws Exception {
        assert (storePath != null);
        try {
            return new URL(storePath);
        }
        catch (MalformedURLException e) {
            File file = new File(storePath);
            if (file.exists() && file.isFile()) {
                return file.toURI().toURL();
            }
            URL url = SSLSupport.findResource(storePath);
            if (url != null) {
                return url;
            }
            throw new Exception("Failed to find a store at " + storePath);
        }
    }

    private static URL findResource(final String resourceName) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return ClassloadingUtil.findResource(resourceName);
            }
        });
    }
}

