/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.tom;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.tom.MessageID;

public class SenderManager {
    public static final long NOT_READY = -1L;
    private final ConcurrentMap<MessageID, MessageInfo> sentMessages = new ConcurrentHashMap<MessageID, MessageInfo>();

    public void addNewMessageToSend(MessageID messageID, Collection<Address> destinations, long initialSequenceNumber, boolean deliverToMyself) {
        MessageInfo messageInfo = new MessageInfo(destinations, initialSequenceNumber, deliverToMyself);
        if (deliverToMyself) {
            messageInfo.setProposeReceived(messageID.getAddress());
        }
        this.sentMessages.put(messageID, messageInfo);
    }

    public long addPropose(MessageID messageID, Address from, long sequenceNumber) {
        MessageInfo messageInfo = (MessageInfo)this.sentMessages.get(messageID);
        if (messageInfo != null && messageInfo.addPropose(from, sequenceNumber)) {
            return messageInfo.getAndMarkFinalSent();
        }
        return -1L;
    }

    public boolean markSent(MessageID messageID) {
        MessageInfo messageInfo = (MessageInfo)this.sentMessages.remove(messageID);
        return messageInfo != null && messageInfo.toSelfDeliver;
    }

    public Set<Address> getDestination(MessageID messageID) {
        MessageInfo messageInfo = (MessageInfo)this.sentMessages.get(messageID);
        Set<Address> destination = messageInfo != null ? new HashSet<Address>(messageInfo.destinations) : Collections.emptySet();
        return destination;
    }

    public void clear() {
        this.sentMessages.clear();
    }

    public Collection<MessageID> getPendingMessageIDs() {
        return this.sentMessages.keySet();
    }

    public long removeLeavers(MessageID messageID, Collection<Address> leavers) {
        MessageInfo messageInfo = (MessageInfo)this.sentMessages.get(messageID);
        if (messageInfo != null && messageInfo.removeLeavers(leavers)) {
            return messageInfo.getAndMarkFinalSent();
        }
        return -1L;
    }

    private static class MessageInfo {
        private ArrayList<Address> destinations;
        private long highestSequenceNumberReceived;
        private BitSet receivedPropose;
        private boolean finalMessageSent = false;
        private boolean toSelfDeliver = false;

        private MessageInfo(Collection<Address> addresses, long sequenceNumber, boolean selfDeliver) {
            this.destinations = new ArrayList<Address>(addresses);
            this.highestSequenceNumberReceived = sequenceNumber;
            this.createNewBitSet(addresses.size());
            this.toSelfDeliver = selfDeliver;
        }

        private synchronized boolean addPropose(Address from, long sequenceNumber) {
            this.setProposeReceived(from);
            this.highestSequenceNumberReceived = Math.max(this.highestSequenceNumberReceived, sequenceNumber);
            return this.checkAllProposesReceived();
        }

        private synchronized long getAndMarkFinalSent() {
            if (this.checkAllProposesReceived() && !this.finalMessageSent) {
                this.finalMessageSent = true;
                return this.highestSequenceNumberReceived;
            }
            return -1L;
        }

        private void createNewBitSet(int maxElements) {
            this.receivedPropose = new BitSet(maxElements);
            for (int i = 0; i < maxElements; ++i) {
                this.receivedPropose.set(i);
            }
        }

        private void setProposeReceived(Address address) {
            int idx = this.destinations.indexOf(address);
            if (idx == -1) {
                throw new IllegalStateException("Address doesn't exists in destination list. Address is " + address);
            }
            this.receivedPropose.set(idx, false);
        }

        private boolean checkAllProposesReceived() {
            return this.receivedPropose.isEmpty();
        }

        public synchronized boolean removeLeavers(Collection<Address> leavers) {
            for (Address address : leavers) {
                int idx = this.destinations.indexOf(address);
                if (idx == -1) continue;
                this.receivedPropose.set(idx, false);
            }
            return this.checkAllProposesReceived();
        }
    }
}

