/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.ChannelListener;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.Receiver;
import org.apache.activemq.artemis.shaded.org.jgroups.UpHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.ProtocolStack;
import org.apache.activemq.artemis.shaded.org.jgroups.util.DefaultSocketFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.SocketFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@MBean(description="Channel")
public abstract class Channel
implements Closeable {
    protected volatile State state = State.OPEN;
    protected UpHandler up_handler = null;
    protected Set<ChannelListener> channel_listeners = null;
    protected Receiver receiver = null;
    protected SocketFactory socket_factory = new DefaultSocketFactory();
    protected final Log log = LogFactory.getLog(this.getClass());
    @ManagedAttribute(description="Whether or not to discard messages sent by this channel", writable=true)
    protected boolean discard_own_messages = false;

    @ManagedAttribute(description="The current state")
    public String getState() {
        return this.state.toString();
    }

    public abstract ProtocolStack getProtocolStack();

    public SocketFactory getSocketFactory() {
        return this.socket_factory;
    }

    public void setSocketFactory(SocketFactory factory) {
        Protocol prot;
        this.socket_factory = factory;
        ProtocolStack stack = this.getProtocolStack();
        Protocol protocol = prot = stack != null ? stack.getTopProtocol() : null;
        if (prot != null) {
            prot.setSocketFactory(factory);
        }
    }

    public abstract void connect(String var1) throws Exception;

    public abstract void connect(String var1, Address var2, long var3) throws Exception;

    public abstract void disconnect();

    @Override
    public abstract void close();

    @ManagedAttribute
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @ManagedAttribute
    public boolean isConnected() {
        return this.state == State.CONNECTED;
    }

    @ManagedAttribute
    public boolean isConnecting() {
        return this.state == State.CONNECTING;
    }

    @ManagedAttribute
    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public abstract Map<String, Object> dumpStats();

    public abstract void send(Message var1) throws Exception;

    public abstract void send(Address var1, Object var2) throws Exception;

    public abstract void send(Address var1, byte[] var2) throws Exception;

    public abstract void send(Address var1, byte[] var2, int var3, int var4) throws Exception;

    public Object down(Event evt) {
        return null;
    }

    public abstract View getView();

    public abstract Address getAddress();

    public abstract String getName();

    public abstract String getName(Address var1);

    public abstract void setName(String var1);

    public abstract Channel name(String var1);

    public abstract String getClusterName();

    public String getProperties() {
        return "n/a";
    }

    public void setUpHandler(UpHandler up_handler) {
        this.up_handler = up_handler;
    }

    public UpHandler getUpHandler() {
        return this.up_handler;
    }

    public synchronized void addChannelListener(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        if (this.channel_listeners == null) {
            this.channel_listeners = new CopyOnWriteArraySet<ChannelListener>();
        }
        this.channel_listeners.add(listener);
    }

    public synchronized void removeChannelListener(ChannelListener listener) {
        if (this.channel_listeners != null && listener != null) {
            this.channel_listeners.remove(listener);
        }
    }

    public synchronized void clearChannelListeners() {
        if (this.channel_listeners != null) {
            this.channel_listeners.clear();
        }
    }

    public void setReceiver(Receiver r) {
        if (this.receiver != null && r != null) {
            this.log.warn("%s: receiver already set", this.getAddress());
        }
        this.receiver = r;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public void setDiscardOwnMessages(boolean flag) {
        this.discard_own_messages = flag;
    }

    public boolean getDiscardOwnMessages() {
        return this.discard_own_messages;
    }

    public abstract boolean flushSupported();

    public abstract void startFlush(List<Address> var1, boolean var2) throws Exception;

    public abstract void startFlush(boolean var1) throws Exception;

    public abstract void stopFlush();

    public abstract void stopFlush(List<Address> var1);

    public abstract void getState(Address var1, long var2) throws Exception;

    protected void notifyChannelConnected(Channel c) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelConnected(c);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("CallbackException"), "channelConnected()", t);
            }
        }
    }

    protected void notifyChannelDisconnected(Channel c) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelDisconnected(c);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("CallbackException"), "channelDisconnected()", t);
            }
        }
    }

    protected void notifyChannelClosed(Channel c) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelClosed(c);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("CallbackException"), "channelClosed()", t);
            }
        }
    }

    public static enum State {
        OPEN,
        CONNECTING,
        CONNECTED,
        CLOSED;

    }
}

