/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.demos;

import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.jmx.JmxConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@MBean
public class JmxDemo
extends NotificationBroadcasterSupport {
    @ManagedAttribute
    private int age;
    @ManagedAttribute
    private static final String last_name = "Ban";
    @ManagedAttribute
    private static final String first_name = "Bela";
    @ManagedAttribute(description="social security number")
    private static final long id = 322649L;
    @ManagedAttribute
    private int number = 10;
    @ManagedAttribute(writable=true)
    private static int my_other_number_is_here = 999;
    @ManagedAttribute
    private int other_number = 20;
    @ManagedAttribute(description="my number attribute")
    private long my_number = 322649L;
    private int accountNumber = 10;
    int max_age = 100;

    public void foo() {
        System.out.println("foo(" + this.number + "): age=" + this.age + ", name=" + first_name + " " + last_name);
    }

    @ManagedAttribute
    public void setNumber(int num) {
        this.number = num;
    }

    @ManagedAttribute
    public String getNumberAsString() {
        return String.valueOf(this.number);
    }

    @ManagedAttribute
    public static int getMyFoo() {
        return 22;
    }

    @ManagedAttribute
    public void setOtherNumber(int num) {
        this.other_number = num;
    }

    @ManagedAttribute
    public void foobar() {
    }

    @ManagedAttribute
    public static boolean isFlag() {
        return true;
    }

    @ManagedAttribute
    public void setMyNumber(long new_number) {
        this.my_number = new_number;
    }

    @ManagedAttribute
    public void setAccountNumber(int num) {
        this.accountNumber = num;
    }

    @ManagedAttribute
    public int getAccountNumber() {
        return this.accountNumber;
    }

    @ManagedAttribute
    public void setMaxAge(int age) {
        this.max_age = age;
    }

    @ManagedAttribute
    public int getMaxAge() {
        return this.max_age;
    }

    @ManagedOperation
    public String sayName() {
        return "I'm Bela Ban";
    }

    public int add(int a, int b) {
        return a + b;
    }

    public static void main(String[] args) {
        JmxDemo demo = new JmxDemo();
        demo.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                System.out.println(">> " + notification + ", handback=" + handback);
            }
        }, null, "myHandback");
        demo.startNotifications();
        MBeanServer server = Util.getMBeanServer();
        if (server != null) {
            try {
                JmxConfigurator.register(demo, server, "demo:name=DemoObject");
                while (true) {
                    Util.sleep(10000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void startNotifications() {
        new Thread(){

            @Override
            public void run() {
                int cnt = 1;
                while (true) {
                    Util.sleep(1000L);
                    MyNotification notif = new MyNotification("home.grown", (Object)this, (long)cnt, "hello-" + cnt);
                    notif.setName("Bela Ban");
                    ++cnt;
                    JmxDemo.this.sendNotification(notif);
                }
            }
        }.start();
    }

    protected static class MyNotification
    extends Notification {
        protected String name;

        public MyNotification(String type, Object source, long sequenceNumber) {
            super(type, source, sequenceNumber);
        }

        public MyNotification(String type, Object source, long sequenceNumber, String message) {
            super(type, source, sequenceNumber, message);
        }

        public MyNotification(String type, Object source, long sequenceNumber, long timeStamp) {
            super(type, source, sequenceNumber, timeStamp);
        }

        public MyNotification(String type, Object source, long sequenceNumber, long timeStamp, String message) {
            super(type, source, sequenceNumber, timeStamp, message);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return super.toString() + ", name=" + this.name;
        }
    }
}

