/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Experimental;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Unsupported;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class PropertiesToAsciidoc {
    public static void main(String[] args) {
        if (args.length != 2) {
            PropertiesToAsciidoc.help();
            System.err.println("args[0]=" + args[0] + ", args[1]=" + args[1]);
            return;
        }
        String prot_file = args[0];
        String inst_file = args[1];
        String temp_file = prot_file + ".tmp";
        String temp_file2 = inst_file + ".tmp";
        try {
            File f = new File(temp_file);
            PropertiesToAsciidoc.copy(new FileReader(new File(prot_file)), new FileWriter(f));
            String s = PropertiesToAsciidoc.fileToString(f);
            Set<Class<Protocol>> classes = Util.findClassesAssignableFrom("org.apache.activemq.artemis.shaded.org.jgroups.protocols", Protocol.class);
            classes.addAll(Util.findClassesAssignableFrom("org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast", Protocol.class));
            classes.addAll(Util.findClassesAssignableFrom("org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay", Protocol.class));
            classes.addAll(Util.findClassesAssignableFrom("org.apache.activemq.artemis.shaded.org.jgroups.protocols.rules", Protocol.class));
            classes.addAll(Util.findClassesAssignableFrom("org.apache.activemq.artemis.shaded.org.jgroups.protocols.tom", Protocol.class));
            Properties props = new Properties();
            for (Class<Protocol> clazz : classes) {
                PropertiesToAsciidoc.convertProtocolToAsciidocTable(props, clazz);
            }
            String result = Util.replaceProperties(s, props);
            FileWriter fw = new FileWriter(f, false);
            fw.write(result);
            fw.flush();
            fw.close();
            f = new File(temp_file2);
            PropertiesToAsciidoc.copy(new FileReader(new File(inst_file)), new FileWriter(f));
            s = PropertiesToAsciidoc.fileToString(f);
            props = new Properties();
            List<Class<?>> unsupportedClasses = Util.findClassesAnnotatedWith("org.apache.activemq.artemis.shaded.org.jgroups", Unsupported.class);
            PropertiesToAsciidoc.convertUnsupportedToAsciidocTable(props, unsupportedClasses, "Unsupported");
            List<Class<?>> experimentalClasses = Util.findClassesAnnotatedWith("org.apache.activemq.artemis.shaded.org.jgroups", Experimental.class);
            PropertiesToAsciidoc.convertUnsupportedToAsciidocTable(props, experimentalClasses, "Experimental");
            result = Util.replaceProperties(s, props);
            fw = new FileWriter(f, false);
            fw.write(result);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void help() {
        System.out.println("PropertiesToXML <path to protocols.adoc file> <path to installation.adoc file>");
    }

    protected static void convertUnsupportedToAsciidocTable(Properties props, List<Class<?>> clazzes, String title) throws ParserConfigurationException, TransformerException {
        ArrayList<String[]> rows = new ArrayList<String[]>(clazzes.size() + 1);
        rows.add(new String[]{"Package", "Class"});
        for (Class<?> clazz : clazzes) {
            rows.add(new String[]{clazz.getPackage().getName(), clazz.getSimpleName()});
        }
        String tmp = PropertiesToAsciidoc.createAsciidocTable(rows, title, "[align=\"left\",width=\"50%\",options=\"header\"]");
        if (clazzes.size() > 1) {
            props.put(title, tmp);
        }
    }

    protected static String createAsciidocTable(List<String[]> rows, String title, String header) throws ParserConfigurationException, TransformerException {
        StringBuilder sb = new StringBuilder(".").append(title).append("\n").append(header).append("\n").append("|=================\n");
        for (String[] row : rows) {
            for (String el : row) {
                sb.append("|").append(el);
            }
            sb.append("\n");
        }
        sb.append("|=================\n");
        return sb.toString();
    }

    private static void convertProtocolToAsciidocTable(Properties props, Class<Protocol> clazz) throws Exception {
        Method[] methods;
        String desc;
        Property annotation;
        Field[] fields;
        boolean isUnsupported = clazz.isAnnotationPresent(Unsupported.class);
        if (isUnsupported) {
            return;
        }
        TreeMap<String, String> nameToDescription = new TreeMap<String, String>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            String property = field.getName();
            annotation = field.getAnnotation(Property.class);
            desc = annotation.description();
            nameToDescription.put(property, desc);
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            String name;
            if (!method.isAnnotationPresent(Property.class)) continue;
            annotation = method.getAnnotation(Property.class);
            desc = annotation.description();
            if (desc == null || desc.isEmpty()) {
                desc = "n/a";
            }
            if ((name = annotation.name()).length() < 1) {
                name = Util.methodNameToAttributeName(method.getName());
            }
            nameToDescription.put(name, desc);
        }
        if (nameToDescription.isEmpty()) {
            return;
        }
        ArrayList<String[]> rows = new ArrayList<String[]>(nameToDescription.size() + 1);
        rows.add(new String[]{"Name", "Description"});
        for (Map.Entry entry : nameToDescription.entrySet()) {
            rows.add(new String[]{(String)entry.getKey(), (String)entry.getValue()});
        }
        String tmp = PropertiesToAsciidoc.createAsciidocTable(rows, clazz.getSimpleName(), "[align=\"left\",width=\"90%\",cols=\"2,10\",options=\"header\"]");
        props.put(clazz.getSimpleName(), tmp);
    }

    private static String fileToString(File f) throws Exception {
        StringWriter output = new StringWriter();
        FileReader input = new FileReader(f);
        char[] buffer = new char[8192];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[8192];
        int count = 0;
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += n;
            }
        }
        finally {
            output.flush();
            output.close();
        }
        return count;
    }
}

