/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Experimental;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@Experimental
@MBean(description="Protocol just above the transport which disseminates multicasts via daisy chaining")
public class DAISYCHAIN
extends Protocol {
    @Property(description="Loop back multicast messages")
    boolean loopback = true;
    @Property(description="The number of messages in the forward queue. This queue is used to host messages that need to be forwarded by us on behalf of our neighbor", deprecatedMessage="not used anymore")
    int forward_queue_size = 10000;
    @Property(description="The number of messages in the send queue. This queue is used to host messages that need to be sent", deprecatedMessage="not used anymore")
    int send_queue_size = 10000;
    protected volatile Address local_addr;
    protected volatile Address next;
    protected int view_size = 0;
    protected Executor default_pool = null;
    protected Executor oob_pool = null;
    protected volatile boolean running = true;
    @ManagedAttribute
    public int msgs_forwarded = 0;
    @ManagedAttribute
    public int msgs_sent = 0;

    @Override
    public void resetStats() {
        super.resetStats();
        this.msgs_sent = 0;
        this.msgs_forwarded = 0;
    }

    @Override
    public void init() throws Exception {
        this.default_pool = this.getTransport().getDefaultThreadPool();
        this.oob_pool = this.getTransport().getOOBThreadPool();
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.running = true;
    }

    @Override
    public void stop() {
        super.stop();
        this.running = false;
    }

    @Override
    public Object down(final Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null || this.next == null) break;
                Message copy = msg.copy(true);
                short hdr_ttl = (short)(this.loopback ? this.view_size - 1 : this.view_size);
                DaisyHeader hdr = new DaisyHeader(hdr_ttl);
                copy.setDest(this.next);
                copy.putHeader(this.getId(), hdr);
                ++this.msgs_sent;
                if (this.loopback) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(new StringBuilder("looping back message ").append(msg));
                    }
                    if (msg.getSrc() == null) {
                        msg.setSrc(this.local_addr);
                    }
                    Executor pool = msg.isFlagSet(Message.Flag.OOB) ? this.oob_pool : this.default_pool;
                    pool.execute(new Runnable(){

                        @Override
                        public void run() {
                            DAISYCHAIN.this.up_prot.up(evt);
                        }
                    });
                }
                return this.down_prot.down(new Event(1, copy));
            }
            case 6: {
                this.handleView((View)evt.getArg());
                break;
            }
            case 15: {
                this.view_size = ((View)evt.getArg()).size();
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                DaisyHeader hdr = (DaisyHeader)msg.getHeader(this.getId());
                if (hdr == null) break;
                short ttl = hdr.getTTL();
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.local_addr + ": received message from " + msg.getSrc() + " with ttl=" + ttl);
                }
                if ((ttl = (short)(ttl - 1)) > 0) {
                    Message copy = msg.copy(true);
                    copy.setDest(this.next);
                    copy.putHeader(this.getId(), new DaisyHeader(ttl));
                    ++this.msgs_forwarded;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(this.local_addr + ": forwarding message to " + this.next + " with ttl=" + ttl);
                    }
                    this.down_prot.down(new Event(1, copy));
                }
                msg.setDest(null);
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            DaisyHeader hdr = (DaisyHeader)msg.getHeader(this.getId());
            if (hdr == null) continue;
            short ttl = hdr.getTTL();
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": received message from " + msg.getSrc() + " with ttl=" + ttl);
            }
            if ((ttl = (short)(ttl - 1)) > 0) {
                Message copy = msg.copy(true);
                copy.setDest(this.next);
                copy.putHeader(this.getId(), new DaisyHeader(ttl));
                ++this.msgs_forwarded;
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.local_addr + ": forwarding message to " + this.next + " with ttl=" + ttl);
                }
                this.down_prot.down(new Event(1, copy));
            }
            msg.setDest(null);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void handleView(View view) {
        this.view_size = view.size();
        Address tmp = Util.pickNext(view.getMembers(), this.local_addr);
        if (tmp != null && !tmp.equals(this.local_addr)) {
            this.next = tmp;
            if (this.log.isDebugEnabled()) {
                this.log.debug("next=" + this.next);
            }
        }
    }

    public static class DaisyHeader
    extends Header {
        private short ttl;

        public DaisyHeader() {
        }

        public DaisyHeader(short ttl) {
            this.ttl = ttl;
        }

        public short getTTL() {
            return this.ttl;
        }

        public void setTTL(short ttl) {
            this.ttl = ttl;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeShort(this.ttl);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.ttl = in.readShort();
        }

        @Override
        public String toString() {
            return "ttl=" + this.ttl;
        }
    }
}

