package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.View;

/**
 * Pluggable way to collect messages and send them as batches
 * @author Bela Ban
 * @since  4.0
 */
public interface Bundler {
    /**
     * Called after creation of the bundler
     * @param transport the transport, for further reference
     */
    void init(TP transport);

    /** Called after {@link #init(TP)} */
    void start();
    void stop();
    void send(Message msg) throws Exception;
    void viewChange(View view);

    /** The number of unsent messages in the bundler */
    int size();
}
