/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.tests.perf;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Channel;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.MembershipListener;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.ReceiverAdapter;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.MethodCall;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.MethodLookup;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestOptions;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.ResponseMode;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RpcDispatcher;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.ClassConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.jmx.JmxConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.UNICAST;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.UNICAST2;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Buffer;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Rsp;
import org.apache.activemq.artemis.shaded.org.jgroups.util.RspList;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Streamable;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class UUPerf
extends ReceiverAdapter {
    private JChannel channel;
    private Address local_addr;
    private RpcDispatcher disp;
    static final String groupname = "uuperf";
    private final List<Address> members = new ArrayList<Address>();
    private boolean sync = true;
    private boolean oob = true;
    private int num_threads = 2;
    private int num_msgs = 1;
    private int msg_size = 4500000;
    private static final Method[] METHODS = new Method[15];
    private static final short START = 0;
    private static final short SET_OOB = 1;
    private static final short SET_SYNC = 2;
    private static final short SET_NUM_MSGS = 3;
    private static final short SET_NUM_THREADS = 4;
    private static final short SET_MSG_SIZE = 5;
    private static final short APPLY_STATE = 6;
    private static final short GET_CONFIG = 10;
    private final AtomicInteger COUNTER = new AtomicInteger(1);
    private byte[] GET_RSP = new byte[this.msg_size];
    static NumberFormat f;

    public void init(String props, String name) throws Throwable {
        this.channel = new JChannel(props);
        if (name != null) {
            this.channel.setName(name);
        }
        this.disp = new RpcDispatcher((Channel)this.channel, null, (MembershipListener)this, this);
        this.disp.setMethodLookup(new MethodLookup(){

            @Override
            public Method findMethod(short id) {
                return METHODS[id];
            }
        });
        this.disp.setRequestMarshaller(new CustomMarshaller());
        this.channel.connect(groupname);
        this.local_addr = this.channel.getAddress();
        try {
            MBeanServer server = Util.getMBeanServer();
            JmxConfigurator.registerChannel(this.channel, server, "jgroups", this.channel.getClusterName(), true);
        }
        catch (Throwable ex) {
            System.err.println("registering the channel in JMX failed: " + ex);
        }
        if (this.members.size() < 2) {
            return;
        }
        Address coord = this.members.get(0);
        ConfigOptions config = (ConfigOptions)this.disp.callRemoteMethod(coord, new MethodCall(10, new Object[0]), new RequestOptions(ResponseMode.GET_ALL, 5000L));
        if (config != null) {
            this.oob = config.oob;
            this.sync = config.sync;
            this.num_threads = config.num_threads;
            this.num_msgs = config.num_msgs;
            this.msg_size = config.msg_size;
            System.out.println("Fetched config from " + coord + ": " + config);
        } else {
            System.err.println("failed to fetch config from " + coord);
        }
    }

    void stop() {
        if (this.disp != null) {
            this.disp.stop();
        }
        Util.close((Closeable)this.channel);
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("** view: " + new_view);
        this.members.clear();
        this.members.addAll(new_view.getMembers());
    }

    public Results startTest() throws Throwable {
        if (this.members.indexOf(this.local_addr) == this.members.size() - 1) {
            System.out.println("This is the joiner, not sending any state");
            return new Results(0, 0L);
        }
        System.out.println("invoking " + this.num_msgs + " RPCs of " + Util.printBytes(this.msg_size) + ", sync=" + this.sync + ", oob=" + this.oob);
        AtomicInteger num_msgs_sent = new AtomicInteger(0);
        Invoker[] invokers = new Invoker[this.num_threads];
        for (int i = 0; i < invokers.length; ++i) {
            invokers[i] = new Invoker(this.members, this.num_msgs, num_msgs_sent);
        }
        long start = System.currentTimeMillis();
        for (Invoker invoker : invokers) {
            invoker.start();
        }
        for (Invoker invoker : invokers) {
            invoker.join();
        }
        long total_time = System.currentTimeMillis() - start;
        System.out.println("done (in " + total_time + " ms)");
        return new Results(num_msgs_sent.get(), total_time);
    }

    public void setOOB(boolean oob) {
        this.oob = oob;
        System.out.println("oob=" + oob);
    }

    public void setSync(boolean val) {
        this.sync = val;
        System.out.println("sync=" + this.sync);
    }

    public void setNumMessages(int num) {
        this.num_msgs = num;
        System.out.println("num_msgs = " + this.num_msgs);
    }

    public void setNumThreads(int num) {
        this.num_threads = num;
        System.out.println("num_threads = " + this.num_threads);
    }

    public void setMessageSize(int num) {
        this.msg_size = num;
        System.out.println("msg_size = " + this.msg_size);
    }

    public static void applyState(byte[] val) {
        System.out.println("-- applyState(): " + Util.printBytes(val.length));
    }

    public ConfigOptions getConfig() {
        return new ConfigOptions(this.oob, this.sync, this.num_threads, this.num_msgs, this.msg_size);
    }

    public void eventLoop() throws Throwable {
        block17: while (true) {
            int c = Util.keyPress("[1] Send msgs [2] Print view [3] Print conns [4] Trash conn [5] Trash all conns\n[6] Set sender threads (" + this.num_threads + ") [7] Set num msgs (" + this.num_msgs + ") " + "[8] Set msg size (" + Util.printBytes(this.msg_size) + ")" + "\n[o] Toggle OOB (" + this.oob + ") [s] Toggle sync (" + this.sync + ")" + "\n[q] Quit\n");
            switch (c) {
                case -1: {
                    break;
                }
                case 49: {
                    try {
                        this.startBenchmark();
                    }
                    catch (Throwable t) {
                        System.err.println(t);
                    }
                    continue block17;
                }
                case 50: {
                    this.printView();
                    break;
                }
                case 51: {
                    this.printConnections();
                    break;
                }
                case 52: {
                    this.removeConnection();
                    break;
                }
                case 53: {
                    this.removeAllConnections();
                    break;
                }
                case 54: {
                    this.setSenderThreads();
                    break;
                }
                case 55: {
                    this.setNumMessages();
                    break;
                }
                case 56: {
                    this.setMessageSize();
                    break;
                }
                case 111: {
                    boolean new_value = !this.oob;
                    this.disp.callRemoteMethods(null, new MethodCall(1, new_value), RequestOptions.SYNC());
                    break;
                }
                case 115: {
                    boolean new_val = !this.sync;
                    this.disp.callRemoteMethods(null, new MethodCall(2, new_val), RequestOptions.SYNC());
                    break;
                }
                case 113: {
                    this.channel.close();
                    return;
                }
                case 10: 
                case 13: {
                    break;
                }
            }
        }
    }

    private void printConnections() {
        Protocol prot = this.channel.getProtocolStack().findProtocol(Util.getUnicastProtocols());
        if (prot instanceof UNICAST) {
            System.out.println("connections:\n" + ((UNICAST)prot).printConnections());
        } else if (prot instanceof UNICAST2) {
            System.out.println("connections:\n" + ((UNICAST2)prot).printConnections());
        }
    }

    private void removeConnection() {
        Address member = this.getReceiver();
        if (member != null) {
            Protocol prot = this.channel.getProtocolStack().findProtocol(Util.getUnicastProtocols());
            if (prot instanceof UNICAST) {
                ((UNICAST)prot).removeConnection(member);
            } else if (prot instanceof UNICAST2) {
                ((UNICAST2)prot).removeConnection(member);
            }
        }
    }

    private void removeAllConnections() {
        Protocol prot = this.channel.getProtocolStack().findProtocol(Util.getUnicastProtocols());
        if (prot instanceof UNICAST) {
            ((UNICAST)prot).removeAllConnections();
        } else if (prot instanceof UNICAST2) {
            ((UNICAST2)prot).removeAllConnections();
        }
    }

    void startBenchmark() throws Throwable {
        RequestOptions options = new RequestOptions(ResponseMode.GET_ALL, 0L);
        options.setFlags(Message.Flag.OOB, Message.Flag.DONT_BUNDLE);
        RspList responses = this.disp.callRemoteMethods(null, new MethodCall(0, new Object[0]), options);
        long total_reqs = 0L;
        long total_time = 0L;
        System.out.println("\n======================= Results: ===========================");
        for (Map.Entry entry : responses.entrySet()) {
            Address mbr = entry.getKey();
            Rsp rsp = entry.getValue();
            Results result = (Results)rsp.getValue();
            total_reqs += result.num_msgs;
            total_time += result.time;
            System.out.println(mbr + ": " + result);
        }
        double total_reqs_sec = (double)total_reqs / ((double)total_time / 1000.0);
        double throughput = total_reqs_sec * (double)this.msg_size;
        double ms_per_req = (double)total_time / (double)total_reqs;
        Protocol prot = this.channel.getProtocolStack().findProtocol(Util.getUnicastProtocols());
        System.out.println("\n");
        System.out.println(Util.bold("Average of " + f.format(total_reqs_sec) + " requests / sec (" + Util.printBytes(throughput) + " / sec), " + f.format(ms_per_req) + " ms /request (prot=" + prot.getName() + ")"));
        System.out.println("\n\n");
    }

    void setSenderThreads() throws Exception {
        int threads = Util.readIntFromStdin("Number of sender threads: ");
        this.disp.callRemoteMethods(null, new MethodCall(4, threads), RequestOptions.SYNC());
    }

    void setNumMessages() throws Exception {
        int tmp = Util.readIntFromStdin("Number of RPCs: ");
        this.disp.callRemoteMethods(null, new MethodCall(3, tmp), RequestOptions.SYNC());
    }

    void setMessageSize() throws Exception {
        int tmp = Util.readIntFromStdin("Message size: ");
        this.disp.callRemoteMethods(null, new MethodCall(5, tmp), RequestOptions.SYNC());
    }

    void printView() {
        System.out.println("\n-- view: " + this.channel.getView() + '\n');
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Address getReceiver() {
        try {
            List<Address> mbrs = this.channel.getView().getMembers();
            int index = mbrs.indexOf(this.local_addr);
            int new_index = index + 1 % mbrs.size();
            return mbrs.get(new_index);
        }
        catch (Exception e) {
            System.err.println("UPerf.getReceiver(): " + e);
            return null;
        }
    }

    public static void main(String[] args) {
        block5: {
            String props = null;
            String name = null;
            for (int i = 0; i < args.length; ++i) {
                if ("-props".equals(args[i])) {
                    props = args[++i];
                    continue;
                }
                if ("-name".equals(args[i])) {
                    name = args[++i];
                    continue;
                }
                UUPerf.help();
                return;
            }
            UUPerf test = null;
            try {
                test = new UUPerf();
                test.init(props, name);
                test.eventLoop();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (test == null) break block5;
                test.stop();
            }
        }
    }

    static void help() {
        System.out.println("UPerf [-props <props>] [-name name]");
    }

    static {
        try {
            UUPerf.METHODS[0] = UUPerf.class.getMethod("startTest", new Class[0]);
            UUPerf.METHODS[1] = UUPerf.class.getMethod("setOOB", Boolean.TYPE);
            UUPerf.METHODS[2] = UUPerf.class.getMethod("setSync", Boolean.TYPE);
            UUPerf.METHODS[3] = UUPerf.class.getMethod("setNumMessages", Integer.TYPE);
            UUPerf.METHODS[4] = UUPerf.class.getMethod("setNumThreads", Integer.TYPE);
            UUPerf.METHODS[5] = UUPerf.class.getMethod("setMessageSize", Integer.TYPE);
            UUPerf.METHODS[6] = UUPerf.class.getMethod("applyState", byte[].class);
            UUPerf.METHODS[10] = UUPerf.class.getMethod("getConfig", new Class[0]);
            ClassConfigurator.add((short)12000, Results.class);
            f = NumberFormat.getNumberInstance();
            f.setGroupingUsed(false);
            f.setMinimumFractionDigits(2);
            f.setMaximumFractionDigits(2);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static class CustomMarshaller
    implements RpcDispatcher.Marshaller {
        CustomMarshaller() {
        }

        @Override
        public Buffer objectToBuffer(Object obj) throws Exception {
            MethodCall call = (MethodCall)obj;
            switch (call.getId()) {
                case 0: 
                case 10: {
                    ByteBuffer buf = ByteBuffer.allocate(1);
                    buf.put((byte)call.getId());
                    return new Buffer(buf.array());
                }
                case 1: 
                case 2: {
                    return new Buffer(CustomMarshaller.booleanBuffer(call.getId(), (Boolean)call.getArgs()[0]));
                }
                case 3: 
                case 4: 
                case 5: {
                    return new Buffer(CustomMarshaller.intBuffer(call.getId(), (Integer)call.getArgs()[0]));
                }
                case 6: {
                    byte[] arg = (byte[])call.getArgs()[0];
                    ByteBuffer buf = ByteBuffer.allocate(5 + arg.length);
                    buf.put((byte)call.getId()).putInt(arg.length).put(arg, 0, arg.length);
                    return new Buffer(buf.array());
                }
            }
            throw new IllegalStateException("method " + call.getMethod() + " not known");
        }

        @Override
        public Object objectFromBuffer(byte[] buffer, int offset, int length) throws Exception {
            ByteBuffer buf = ByteBuffer.wrap(buffer, offset, length);
            byte type = buf.get();
            switch (type) {
                case 0: 
                case 10: {
                    return new MethodCall(type, new Object[0]);
                }
                case 1: 
                case 2: {
                    return new MethodCall(type, buf.get() == 1);
                }
                case 3: 
                case 4: 
                case 5: {
                    return new MethodCall(type, buf.getInt());
                }
                case 6: {
                    int len = buf.getInt();
                    byte[] arg = new byte[len];
                    buf.get(arg, 0, arg.length);
                    return new MethodCall(type, new Object[]{arg});
                }
            }
            throw new IllegalStateException("type " + type + " not known");
        }

        private static byte[] intBuffer(short type, Integer num) {
            ByteBuffer buf = ByteBuffer.allocate(5);
            buf.put((byte)type).putInt(num);
            return buf.array();
        }

        private static byte[] longBuffer(short type, Long num) {
            ByteBuffer buf = ByteBuffer.allocate(9);
            buf.put((byte)type).putLong(num);
            return buf.array();
        }

        private static byte[] booleanBuffer(short type, Boolean arg) {
            ByteBuffer buf = ByteBuffer.allocate(2);
            buf.put((byte)type).put((byte)(arg != false ? 1 : 0));
            return buf.array();
        }
    }

    public static class ConfigOptions
    implements Streamable {
        private boolean sync;
        private boolean oob;
        private int num_threads;
        private int num_msgs;
        private int msg_size;

        public ConfigOptions() {
        }

        public ConfigOptions(boolean oob, boolean sync, int num_threads, int num_msgs, int msg_size) {
            this.oob = oob;
            this.sync = sync;
            this.num_threads = num_threads;
            this.num_msgs = num_msgs;
            this.msg_size = msg_size;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeBoolean(this.oob);
            out.writeBoolean(this.sync);
            out.writeInt(this.num_threads);
            out.writeInt(this.num_msgs);
            out.writeInt(this.msg_size);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.oob = in.readBoolean();
            this.sync = in.readBoolean();
            this.num_threads = in.readInt();
            this.num_msgs = in.readInt();
            this.msg_size = in.readInt();
        }

        public String toString() {
            return "oob=" + this.oob + ", sync=" + this.sync + ", num_threads=" + this.num_threads + ", num_msgs=" + this.num_msgs + ", msg_size=" + this.msg_size;
        }
    }

    public static class Results
    implements Streamable {
        long num_msgs = 0L;
        long time = 0L;

        public Results() {
        }

        public Results(int num_msgs, long time) {
            this.num_msgs = num_msgs;
            this.time = time;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeLong(this.num_msgs);
            out.writeLong(this.time);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.num_msgs = in.readLong();
            this.time = in.readLong();
        }

        public String toString() {
            long total_reqs = this.num_msgs;
            double total_reqs_per_sec = (double)total_reqs / ((double)this.time / 1000.0);
            return f.format(total_reqs_per_sec) + " reqs/sec (" + this.num_msgs + " APPLY_STATEs total)";
        }
    }

    private class Invoker
    extends Thread {
        private final List<Address> dests = new ArrayList<Address>();
        private final int num_msgs_to_send;
        private final AtomicInteger num_msgs_sent;

        public Invoker(Collection<Address> dests, int num_msgs_to_send, AtomicInteger num_msgs_sent) {
            this.num_msgs_sent = num_msgs_sent;
            this.dests.addAll(dests);
            this.num_msgs_to_send = num_msgs_to_send;
            this.setName("Invoker-" + UUPerf.this.COUNTER.getAndIncrement());
        }

        @Override
        public void run() {
            long i;
            byte[] buf = new byte[UUPerf.this.msg_size];
            Object[] apply_state_args = new Object[]{buf};
            MethodCall apply_state_call = new MethodCall(6, apply_state_args);
            RequestOptions apply_state_options = new RequestOptions(UUPerf.this.sync ? ResponseMode.GET_ALL : ResponseMode.GET_NONE, 400000L, true, null);
            if (UUPerf.this.oob) {
                apply_state_options.setFlags(Message.Flag.OOB);
            }
            if (UUPerf.this.sync) {
                apply_state_options.setFlags(Message.Flag.DONT_BUNDLE);
            }
            apply_state_options.setFlags(Message.Flag.RSVP);
            while ((i = (long)this.num_msgs_sent.getAndIncrement()) < (long)this.num_msgs_to_send) {
                try {
                    Address target = this.pickApplyStateTarget();
                    apply_state_args[0] = buf;
                    UUPerf.this.disp.callRemoteMethod(target, apply_state_call, apply_state_options);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        private Address pickApplyStateTarget() {
            return this.dests.get(this.dests.size() - 1);
        }
    }
}

