/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client.compatible1X;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQBytesCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQMapCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQObjectCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQStreamCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQTextCompabileMessage;
import org.apache.activemq.artemis.reader.MessageUtil;

public class ActiveMQCompatibleMessage
extends ActiveMQMessage {
    public ActiveMQCompatibleMessage(byte type, ClientSession session) {
        super(type, session);
    }

    public ActiveMQCompatibleMessage(ClientSession session) {
        super(session);
    }

    public ActiveMQCompatibleMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public ActiveMQCompatibleMessage(Message foreign, ClientSession session) throws JMSException {
        super(foreign, session);
    }

    public ActiveMQCompatibleMessage() {
    }

    public ActiveMQCompatibleMessage(Message foreign, byte type, ClientSession session) throws JMSException {
        super(foreign, type, session);
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        if (this.replyTo == null) {
            this.replyTo = ActiveMQCompatibleMessage.findCompatibleReplyTo(this.message);
        }
        return this.replyTo;
    }

    public static Destination findCompatibleReplyTo(ClientMessage message) {
        SimpleString address = MessageUtil.getJMSReplyTo(message);
        if (address != null) {
            String name = address.toString();
            if (address.startsWith(OLD_QUEUE_QUALIFIED_PREFIX)) {
                name = address.subSeq(OLD_QUEUE_QUALIFIED_PREFIX.length(), address.length()).toString();
            } else if (address.startsWith(OLD_TEMP_QUEUE_QUALIFED_PREFIX)) {
                name = address.subSeq(OLD_TEMP_QUEUE_QUALIFED_PREFIX.length(), address.length()).toString();
            } else if (address.startsWith(OLD_TOPIC_QUALIFIED_PREFIX)) {
                name = address.subSeq(OLD_TOPIC_QUALIFIED_PREFIX.length(), address.length()).toString();
            } else if (address.startsWith(OLD_TEMP_TOPIC_QUALIFED_PREFIX)) {
                name = address.subSeq(OLD_TEMP_TOPIC_QUALIFED_PREFIX.length(), address.length()).toString();
            }
            return ActiveMQDestination.fromPrefixedName(address.toString(), name);
        }
        return null;
    }

    @Override
    public SimpleString checkPrefix(SimpleString address) {
        return ActiveMQCompatibleMessage.checkPrefix1X(address);
    }

    protected static SimpleString checkPrefix1X(SimpleString address) {
        if (address != null) {
            if (address.startsWith(PacketImpl.OLD_QUEUE_PREFIX)) {
                return address.subSeq(PacketImpl.OLD_QUEUE_PREFIX.length(), address.length());
            }
            if (address.startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX)) {
                return address.subSeq(PacketImpl.OLD_TEMP_QUEUE_PREFIX.length(), address.length());
            }
            if (address.startsWith(PacketImpl.OLD_TOPIC_PREFIX)) {
                return address.subSeq(PacketImpl.OLD_TOPIC_PREFIX.length(), address.length());
            }
            if (address.startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX)) {
                return address.subSeq(PacketImpl.OLD_TEMP_TOPIC_PREFIX.length(), address.length());
            }
        }
        return null;
    }

    public static ActiveMQMessage createMessage(ClientMessage message, ClientSession session, ConnectionFactoryOptions options) {
        ActiveMQMessage msg;
        byte type = message.getType();
        switch (type) {
            case 0: {
                msg = new ActiveMQCompatibleMessage(message, session);
                break;
            }
            case 4: {
                msg = new ActiveMQBytesCompatibleMessage(message, session);
                break;
            }
            case 5: {
                msg = new ActiveMQMapCompatibleMessage(message, session);
                break;
            }
            case 2: {
                msg = new ActiveMQObjectCompatibleMessage(message, session, options);
                break;
            }
            case 6: {
                msg = new ActiveMQStreamCompatibleMessage(message, session);
                break;
            }
            case 3: {
                msg = new ActiveMQTextCompabileMessage(message, session);
                break;
            }
            default: {
                throw new JMSRuntimeException("Invalid message type " + type);
            }
        }
        return msg;
    }
}

