/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.QueueAttributes;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQBytesMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;
import org.apache.activemq.artemis.jms.client.ActiveMQMapMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQMessageConsumer;
import org.apache.activemq.artemis.jms.client.ActiveMQMessageProducer;
import org.apache.activemq.artemis.jms.client.ActiveMQObjectMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQQueueBrowser;
import org.apache.activemq.artemis.jms.client.ActiveMQStreamMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryTopic;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.JMSExceptionHelper;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.impl.SelectorParser;
import org.apache.activemq.artemis.utils.SelectorTranslator;

public class ActiveMQSession
implements QueueSession,
TopicSession {
    public static final int TYPE_GENERIC_SESSION = 0;
    public static final int TYPE_QUEUE_SESSION = 1;
    public static final int TYPE_TOPIC_SESSION = 2;
    private static SimpleString REJECTING_FILTER = new SimpleString("_AMQX=-1");
    private final ConnectionFactoryOptions options;
    private final ActiveMQConnection connection;
    private final ClientSession session;
    private final int sessionType;
    private final int ackMode;
    private final boolean transacted;
    private final boolean xa;
    private boolean recoverCalled;
    private final Set<ActiveMQMessageConsumer> consumers = new HashSet<ActiveMQMessageConsumer>();
    private final boolean cacheDestination;
    private final boolean enable1xPrefixes;
    private final Map<String, Topic> topicCache = new ConcurrentHashMap<String, Topic>();
    private final Map<String, Queue> queueCache = new ConcurrentHashMap<String, Queue>();

    protected ActiveMQSession(ConnectionFactoryOptions options, ActiveMQConnection connection, boolean transacted, boolean xa, int ackMode, boolean cacheDestination, boolean enable1xPrefixes, ClientSession session, int sessionType) {
        this.options = options;
        this.connection = connection;
        this.ackMode = ackMode;
        this.session = session;
        this.sessionType = sessionType;
        this.transacted = transacted;
        this.xa = xa;
        this.cacheDestination = cacheDestination;
        this.enable1xPrefixes = enable1xPrefixes;
    }

    @Override
    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        ActiveMQBytesMessage message = new ActiveMQBytesMessage(this.session);
        message.setEnable1xPrefixes(this.enable1xPrefixes);
        return message;
    }

    @Override
    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        ActiveMQMapMessage message = new ActiveMQMapMessage(this.session);
        message.setEnable1xPrefixes(this.enable1xPrefixes);
        return message;
    }

    @Override
    public Message createMessage() throws JMSException {
        this.checkClosed();
        ActiveMQMessage message = new ActiveMQMessage(this.session);
        message.setEnable1xPrefixes(this.enable1xPrefixes);
        return message;
    }

    @Override
    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        ActiveMQObjectMessage message = new ActiveMQObjectMessage(this.session, this.options);
        message.setEnable1xPrefixes(this.enable1xPrefixes);
        return message;
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        ActiveMQObjectMessage msg = new ActiveMQObjectMessage(this.session, this.options);
        msg.setObject(object);
        msg.setEnable1xPrefixes(this.enable1xPrefixes);
        return msg;
    }

    @Override
    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        ActiveMQStreamMessage message = new ActiveMQStreamMessage(this.session);
        message.setEnable1xPrefixes(this.enable1xPrefixes);
        return message;
    }

    @Override
    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        ActiveMQTextMessage msg = new ActiveMQTextMessage(this.session);
        msg.setText(null);
        msg.setEnable1xPrefixes(this.enable1xPrefixes);
        return msg;
    }

    @Override
    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        ActiveMQTextMessage msg = new ActiveMQTextMessage(this.session);
        msg.setText(text);
        msg.setEnable1xPrefixes(this.enable1xPrefixes);
        return msg;
    }

    @Override
    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    @Override
    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.ackMode;
    }

    public boolean isXA() {
        return this.xa;
    }

    @Override
    public void commit() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Cannot commit a non-transacted session");
        }
        if (this.xa) {
            throw new TransactionInProgressException("Cannot call commit on an XA session");
        }
        try {
            this.session.commit();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    @Override
    public void rollback() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Cannot rollback a non-transacted session");
        }
        if (this.xa) {
            throw new TransactionInProgressException("Cannot call rollback on an XA session");
        }
        try {
            this.session.rollback();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        this.connection.getThreadAwareContext().assertNotCompletionListenerThread();
        this.connection.getThreadAwareContext().assertNotMessageListenerThread();
        ActiveMQConnection activeMQConnection = this.connection;
        synchronized (activeMQConnection) {
            try {
                for (ActiveMQMessageConsumer cons : new HashSet<ActiveMQMessageConsumer>(this.consumers)) {
                    cons.close();
                }
                this.session.close();
                this.connection.removeSession(this);
            }
            catch (ActiveMQException e) {
                throw JMSExceptionHelper.convertFromActiveMQException(e);
            }
        }
        this.topicCache.clear();
        this.queueCache.clear();
    }

    @Override
    public void recover() throws JMSException {
        if (this.transacted) {
            throw new IllegalStateException("Cannot recover a transacted session");
        }
        try {
            this.session.rollback(true);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
        this.recoverCalled = true;
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
    }

    @Override
    public void run() {
    }

    @Override
    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination != null && !(destination instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Not an ActiveMQ Artemis Destination:" + destination);
        }
        try {
            ActiveMQDestination jbd;
            block8: {
                ClientSession.AddressQuery response;
                jbd = (ActiveMQDestination)destination;
                if (jbd != null && !(response = this.session.addressQuery(jbd.getSimpleAddress())).isExists()) {
                    try {
                        if (jbd.isQueue() && response.isAutoCreateQueues()) {
                            this.session.createAddress(jbd.getSimpleAddress(), RoutingType.ANYCAST, true);
                            this.createQueue(jbd, RoutingType.ANYCAST, jbd.getSimpleAddress(), null, true, true, response.getDefaultMaxConsumers(), response.isDefaultPurgeOnNoConsumers(), response.isDefaultExclusive(), response.isDefaultLastValueQueue());
                            break block8;
                        }
                        if (!jbd.isQueue() && response.isAutoCreateAddresses()) {
                            this.session.createAddress(jbd.getSimpleAddress(), RoutingType.MULTICAST, true);
                            break block8;
                        }
                        throw new InvalidDestinationException("Destination " + jbd.getName() + " does not exist");
                    }
                    catch (ActiveMQQueueExistsException activeMQQueueExistsException) {
                        // empty catch block
                    }
                }
            }
            ClientProducer producer = this.session.createProducer(jbd == null ? null : jbd.getSimpleAddress());
            return new ActiveMQMessageProducer(this.connection, producer, jbd, this.session, this.options);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    @Override
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Cannot create a consumer with a null destination");
        }
        if (!(destination instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Not an ActiveMQDestination:" + destination);
        }
        ActiveMQDestination jbdest = (ActiveMQDestination)destination;
        if (jbdest.isTemporary() && !this.connection.containsTemporaryQueue(jbdest.getSimpleAddress())) {
            throw new JMSException("Can not create consumer for temporary destination " + destination + " from another JMS connection");
        }
        return this.createConsumer(jbdest, null, messageSelector, noLocal, ConsumerDurability.NON_DURABLE);
    }

    @Override
    public Queue createQueue(String queueName) throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a queue using a TopicSession");
        }
        try {
            Queue queue = null;
            if (this.cacheDestination) {
                queue = this.queueCache.get(queueName);
            }
            if (queue == null) {
                queue = this.internalCreateQueue(queueName);
            }
            if (this.cacheDestination) {
                this.queueCache.put(queueName, queue);
            }
            return queue;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    protected Queue internalCreateQueue(String queueName) throws ActiveMQException, JMSException {
        ActiveMQQueue queue = this.lookupQueue(queueName, false);
        if (queue == null) {
            queue = this.lookupQueue(queueName, true);
        }
        if (queue == null) {
            queue = this.internalCreateQueueCompatibility("jms.queue." + queueName);
        }
        if (queue == null) {
            throw new JMSException("There is no queue with name " + queueName);
        }
        return queue;
    }

    protected ActiveMQQueue internalCreateQueueCompatibility(String queueName) throws ActiveMQException, JMSException {
        ActiveMQQueue queue = this.lookupQueue(queueName, false);
        if (queue == null) {
            queue = this.lookupQueue(queueName, true);
        }
        return queue;
    }

    @Override
    public Topic createTopic(String topicName) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a topic on a QueueSession");
        }
        try {
            Topic topic = null;
            if (this.cacheDestination) {
                topic = this.topicCache.get(topicName);
            }
            if (topic == null) {
                topic = this.internalCreateTopic(topicName, false);
            }
            if (this.cacheDestination) {
                this.topicCache.put(topicName, topic);
            }
            return topic;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    protected Topic internalCreateTopic(String topicName, boolean retry) throws ActiveMQException, JMSException {
        ActiveMQTopic topic = this.lookupTopic(topicName, false);
        if (topic == null) {
            topic = this.lookupTopic(topicName, true);
        }
        if (topic == null) {
            if (!retry) {
                return this.internalCreateTopic("jms.topic." + topicName, true);
            }
            throw new JMSException("There is no topic with name " + topicName);
        }
        return topic;
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        ActiveMQDestination jbdest;
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a durable subscriber on a QueueSession");
        }
        this.checkTopic(topic);
        if (!(topic instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Not an ActiveMQTopic:" + topic);
        }
        if ("".equals(messageSelector)) {
            messageSelector = null;
        }
        if ((jbdest = (ActiveMQDestination)((Object)topic)).isQueue()) {
            throw new InvalidDestinationException("Cannot create a subscriber on a queue");
        }
        return this.createConsumer(jbdest, name, messageSelector, noLocal, ConsumerDurability.DURABLE);
    }

    private void checkTopic(Topic topic) throws InvalidDestinationException {
        if (topic == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nullTopic();
        }
    }

    @Override
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return this.createSharedConsumer(topic, sharedSubscriptionName, null);
    }

    @Override
    public MessageConsumer createSharedConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a shared consumer on a QueueSession");
        }
        this.checkTopic(topic);
        ActiveMQTopic localTopic = topic instanceof ActiveMQTopic ? (ActiveMQTopic)topic : new ActiveMQTopic(topic.getTopicName());
        return this.internalCreateSharedConsumer(localTopic, name, messageSelector, ConsumerDurability.NON_DURABLE);
    }

    @Override
    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createDurableConsumer(topic, name, null, false);
    }

    @Override
    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a durable consumer on a QueueSession");
        }
        this.checkTopic(topic);
        ActiveMQTopic localTopic = topic instanceof ActiveMQTopic ? (ActiveMQTopic)topic : new ActiveMQTopic(topic.getTopicName());
        return this.createConsumer(localTopic, name, messageSelector, noLocal, ConsumerDurability.DURABLE);
    }

    @Override
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createSharedDurableConsumer(topic, name, null);
    }

    @Override
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a shared durable consumer on a QueueSession");
        }
        this.checkTopic(topic);
        ActiveMQTopic localTopic = topic instanceof ActiveMQTopic ? (ActiveMQTopic)topic : new ActiveMQTopic(topic.getTopicName());
        return this.internalCreateSharedConsumer(localTopic, name, messageSelector, ConsumerDurability.DURABLE);
    }

    public String getDeserializationBlackList() {
        return this.connection.getDeserializationBlackList();
    }

    public String getDeserializationWhiteList() {
        return this.connection.getDeserializationWhiteList();
    }

    private ActiveMQMessageConsumer internalCreateSharedConsumer(ActiveMQDestination dest, String subscriptionName, String selectorString, ConsumerDurability durability) throws JMSException {
        try {
            if (dest.isQueue()) {
                throw new RuntimeException("Internal error: createSharedConsumer is only meant for Topics");
            }
            if (subscriptionName == null) {
                throw ActiveMQJMSClientBundle.BUNDLE.invalidSubscriptionName();
            }
            selectorString = "".equals(selectorString) ? null : selectorString;
            SimpleString coreFilterString = null;
            if (selectorString != null) {
                coreFilterString = new SimpleString(SelectorTranslator.convertToActiveMQFilterString(selectorString));
            }
            SimpleString autoDeleteQueueName = null;
            ClientSession.AddressQuery response = this.session.addressQuery(dest.getSimpleAddress());
            if (!response.isExists() && !response.isAutoCreateAddresses()) {
                throw ActiveMQJMSClientBundle.BUNDLE.destinationDoesNotExist(dest.getSimpleAddress());
            }
            if (dest.isTemporary() && durability == ConsumerDurability.DURABLE) {
                throw new InvalidDestinationException("Cannot create a durable subscription on a temporary topic");
            }
            SimpleString queueName = ActiveMQDestination.createQueueNameForSubscription(durability == ConsumerDurability.DURABLE, this.connection.getClientID(), subscriptionName);
            ClientSession.QueueQuery subResponse = this.session.queueQuery(queueName);
            if (!(subResponse.isExists() && Objects.equals(subResponse.getAddress(), dest.getSimpleAddress()) && Objects.equals(subResponse.getFilterString(), coreFilterString))) {
                try {
                    if (durability == ConsumerDurability.DURABLE) {
                        this.createSharedQueue(dest, RoutingType.MULTICAST, queueName, coreFilterString, true, response.getDefaultMaxConsumers(), response.isDefaultPurgeOnNoConsumers(), response.isDefaultExclusive(), response.isDefaultLastValueQueue());
                    } else {
                        this.createSharedQueue(dest, RoutingType.MULTICAST, queueName, coreFilterString, false, response.getDefaultMaxConsumers(), response.isDefaultPurgeOnNoConsumers(), response.isDefaultExclusive(), response.isDefaultLastValueQueue());
                    }
                }
                catch (ActiveMQQueueExistsException activeMQQueueExistsException) {
                    // empty catch block
                }
            }
            ClientConsumer consumer = this.session.createConsumer(queueName, null, false);
            ActiveMQMessageConsumer jbc = new ActiveMQMessageConsumer(this.options, this.connection, this, consumer, false, dest, selectorString, autoDeleteQueueName);
            this.consumers.add(jbc);
            return jbc;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    private ActiveMQMessageConsumer createConsumer(ActiveMQDestination dest, String subscriptionName, String selectorString, boolean noLocal, ConsumerDurability durability) throws JMSException {
        try {
            ClientConsumer consumer;
            ClientSession.AddressQuery response;
            String string = selectorString = "".equals(selectorString) ? null : selectorString;
            if (noLocal) {
                this.connection.setHasNoLocal();
                String filter = this.connection.getClientID() != null ? ActiveMQConnection.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + this.connection.getClientID() + "'" : ActiveMQConnection.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + this.connection.getUID() + "'";
                selectorString = selectorString != null ? selectorString + " AND " + filter : filter;
            }
            SimpleString coreFilterString = null;
            if (selectorString != null) {
                coreFilterString = new SimpleString(SelectorTranslator.convertToActiveMQFilterString(selectorString));
            }
            SimpleString autoDeleteQueueName = null;
            if (dest.isQueue()) {
                response = this.session.addressQuery(dest.getSimpleAddress());
                if (!response.isExists() || !response.getQueueNames().contains(dest.getSimpleAddress())) {
                    if (response.isAutoCreateQueues()) {
                        try {
                            this.createQueue(dest, RoutingType.ANYCAST, dest.getSimpleAddress(), null, true, true, response.getDefaultMaxConsumers(), response.isDefaultPurgeOnNoConsumers(), response.isDefaultExclusive(), response.isDefaultLastValueQueue());
                        }
                        catch (ActiveMQQueueExistsException activeMQQueueExistsException) {}
                    } else {
                        throw new InvalidDestinationException("Destination " + dest.getName() + " does not exist");
                    }
                }
                this.connection.addKnownDestination(dest.getSimpleAddress());
                consumer = this.session.createConsumer(dest.getSimpleAddress(), coreFilterString, false);
            } else {
                response = this.session.addressQuery(dest.getSimpleAddress());
                if (!response.isExists()) {
                    if (response.isAutoCreateAddresses()) {
                        this.session.createAddress(dest.getSimpleAddress(), RoutingType.MULTICAST, true);
                    } else {
                        throw new InvalidDestinationException("Topic " + dest.getName() + " does not exist");
                    }
                }
                this.connection.addKnownDestination(dest.getSimpleAddress());
                if (subscriptionName == null) {
                    if (durability != ConsumerDurability.NON_DURABLE) {
                        throw new RuntimeException("Subscription name cannot be null for durable topic consumer");
                    }
                    SimpleString queueName = new SimpleString(UUID.randomUUID().toString());
                    this.createTemporaryQueue(dest, RoutingType.MULTICAST, queueName, coreFilterString, response.getDefaultMaxConsumers(), response.isDefaultPurgeOnNoConsumers(), response.isDefaultExclusive(), response.isDefaultLastValueQueue());
                    consumer = this.session.createConsumer(queueName, null, false);
                    autoDeleteQueueName = queueName;
                } else {
                    if (durability != ConsumerDurability.DURABLE) {
                        throw new RuntimeException("Subscription name must be null for non-durable topic consumer");
                    }
                    if (this.connection.getClientID() == null) {
                        throw new IllegalStateException("Cannot create durable subscription - client ID has not been set");
                    }
                    if (dest.isTemporary()) {
                        throw new InvalidDestinationException("Cannot create a durable subscription on a temporary topic");
                    }
                    SimpleString queueName = ActiveMQDestination.createQueueNameForSubscription(true, this.connection.getClientID(), subscriptionName);
                    ClientSession.QueueQuery subResponse = this.session.queueQuery(queueName);
                    if (!subResponse.isExists()) {
                        this.createQueue(dest, RoutingType.MULTICAST, queueName, coreFilterString, true, false, response.getDefaultMaxConsumers(), response.isDefaultPurgeOnNoConsumers(), response.isDefaultExclusive(), response.isDefaultLastValueQueue());
                    } else {
                        boolean topicChanged;
                        if (subResponse.getConsumerCount() > 0) {
                            throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                        }
                        SimpleString oldFilterString = subResponse.getFilterString();
                        boolean selectorChanged = coreFilterString == null && oldFilterString != null || oldFilterString == null && coreFilterString != null || oldFilterString != null && coreFilterString != null && !oldFilterString.equals(coreFilterString);
                        SimpleString oldTopicName = subResponse.getAddress();
                        boolean bl = topicChanged = !oldTopicName.equals(dest.getSimpleAddress());
                        if (selectorChanged || topicChanged) {
                            this.session.deleteQueue(queueName);
                            this.createQueue(dest, RoutingType.MULTICAST, queueName, coreFilterString, true, false, response.getDefaultMaxConsumers(), response.isDefaultPurgeOnNoConsumers(), response.isDefaultExclusive(), response.isDefaultLastValueQueue());
                        }
                    }
                    consumer = this.session.createConsumer(queueName, null, false);
                }
            }
            ActiveMQMessageConsumer jbc = new ActiveMQMessageConsumer(this.options, this.connection, this, consumer, noLocal, dest, selectorString, autoDeleteQueueName);
            this.consumers.add(jbc);
            return jbc;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void ackAllConsumers() throws JMSException {
        this.checkClosed();
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String filterString) throws JMSException {
        ActiveMQDestination activeMQDestination;
        block11: {
            if (this.sessionType == 2) {
                throw new IllegalStateException("Cannot create a browser on a TopicSession");
            }
            if (queue == null) {
                throw new InvalidDestinationException("Cannot create a browser with a null queue");
            }
            if (!(queue instanceof ActiveMQDestination)) {
                throw new InvalidDestinationException("Not an ActiveMQQueue:" + queue);
            }
            if ("".equals(filterString)) {
                filterString = null;
            }
            try {
                if (filterString != null) {
                    SelectorParser.parse(filterString.trim());
                }
            }
            catch (FilterException e) {
                throw JMSExceptionHelper.convertFromActiveMQException(ActiveMQJMSClientBundle.BUNDLE.invalidFilter(e, new SimpleString(filterString)));
            }
            activeMQDestination = (ActiveMQDestination)((Object)queue);
            if (!activeMQDestination.isQueue()) {
                throw new InvalidDestinationException("Cannot create a browser on a topic");
            }
            try {
                ClientSession.AddressQuery response = this.session.addressQuery(new SimpleString(activeMQDestination.getAddress()));
                if (response.isExists()) break block11;
                if (response.isAutoCreateQueues()) {
                    this.createQueue(activeMQDestination, RoutingType.ANYCAST, activeMQDestination.getSimpleAddress(), null, true, true, response.getDefaultMaxConsumers(), response.isDefaultPurgeOnNoConsumers(), response.isDefaultExclusive(), response.isDefaultLastValueQueue());
                    break block11;
                }
                throw new InvalidDestinationException("Destination " + activeMQDestination.getName() + " does not exist");
            }
            catch (ActiveMQException e) {
                throw JMSExceptionHelper.convertFromActiveMQException(e);
            }
        }
        return new ActiveMQQueueBrowser(this.options, (ActiveMQQueue)activeMQDestination, filterString, this.session, this.enable1xPrefixes);
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a temporary queue using a TopicSession");
        }
        try {
            ActiveMQTemporaryQueue queue = this.enable1xPrefixes ? ActiveMQDestination.createTemporaryQueue(this, PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString()) : ActiveMQDestination.createTemporaryQueue(this);
            SimpleString simpleAddress = queue.getSimpleAddress();
            this.session.createTemporaryQueue(simpleAddress, RoutingType.ANYCAST, simpleAddress);
            this.connection.addTemporaryQueue(simpleAddress);
            return queue;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    @Override
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a temporary topic on a QueueSession");
        }
        try {
            ActiveMQTemporaryTopic topic = this.enable1xPrefixes ? ActiveMQDestination.createTemporaryTopic(this, PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString()) : ActiveMQDestination.createTemporaryTopic(this);
            SimpleString simpleAddress = topic.getSimpleAddress();
            this.session.createTemporaryQueue(simpleAddress, simpleAddress, REJECTING_FILTER);
            this.connection.addTemporaryQueue(simpleAddress);
            return topic;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    @Override
    public void unsubscribe(String name) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot unsubscribe using a QueueSession");
        }
        SimpleString queueName = ActiveMQDestination.createQueueNameForSubscription(true, this.connection.getClientID(), name);
        try {
            ClientSession.QueueQuery response = this.session.queueQuery(queueName);
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot unsubscribe, subscription with name " + name + " does not exist");
            }
            if (response.getConsumerCount() != 0) {
                throw new IllegalStateException("Cannot unsubscribe durable subscription " + name + " since it has active subscribers");
            }
            this.session.deleteQueue(queueName);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public Session getSession() throws JMSException {
        if (!this.xa) {
            throw new IllegalStateException("Isn't an XASession");
        }
        return this;
    }

    public XAResource getXAResource() {
        return this.session.getXAResource();
    }

    @Override
    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return (QueueReceiver)this.createConsumer(queue, messageSelector);
    }

    @Override
    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return (QueueReceiver)this.createConsumer(queue);
    }

    @Override
    public QueueSender createSender(Queue queue) throws JMSException {
        return (QueueSender)this.createProducer(queue);
    }

    public QueueSession getQueueSession() throws JMSException {
        return (QueueSession)this.getSession();
    }

    @Override
    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return (TopicPublisher)this.createProducer(topic);
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return (TopicSubscriber)this.createConsumer(topic, messageSelector, noLocal);
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return (TopicSubscriber)this.createConsumer(topic);
    }

    public TopicSession getTopicSession() throws JMSException {
        return (TopicSession)this.getSession();
    }

    public String toString() {
        return "ActiveMQSession->" + this.session;
    }

    public ClientSession getCoreSession() {
        return this.session;
    }

    public boolean isRecoverCalled() {
        return this.recoverCalled;
    }

    public void setRecoverCalled(boolean recoverCalled) {
        this.recoverCalled = recoverCalled;
    }

    public void deleteTemporaryTopic(ActiveMQDestination tempTopic) throws JMSException {
        if (!tempTopic.isTemporary()) {
            throw new InvalidDestinationException("Not a temporary topic " + tempTopic);
        }
        try {
            ClientSession.AddressQuery response = this.session.addressQuery(tempTopic.getSimpleAddress());
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot delete temporary topic " + tempTopic.getName() + " does not exist");
            }
            if (response.getQueueNames().size() > 1) {
                throw new IllegalStateException("Cannot delete temporary topic " + tempTopic.getName() + " since it has subscribers");
            }
            SimpleString address = tempTopic.getSimpleAddress();
            this.session.deleteQueue(address);
            this.connection.removeTemporaryQueue(address);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void deleteTemporaryQueue(ActiveMQDestination tempQueue) throws JMSException {
        if (!tempQueue.isTemporary()) {
            throw new InvalidDestinationException("Not a temporary queue " + tempQueue);
        }
        try {
            ClientSession.QueueQuery response = this.session.queueQuery(tempQueue.getSimpleAddress());
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot delete temporary queue " + tempQueue.getName() + " does not exist");
            }
            if (response.getConsumerCount() > 0) {
                throw new IllegalStateException("Cannot delete temporary queue " + tempQueue.getName() + " since it has subscribers");
            }
            SimpleString address = tempQueue.getSimpleAddress();
            this.session.deleteQueue(address);
            this.connection.removeTemporaryQueue(address);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void start() throws JMSException {
        try {
            this.session.start();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void stop() throws JMSException {
        try {
            this.session.stop();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void removeConsumer(ActiveMQMessageConsumer consumer) {
        this.consumers.remove(consumer);
    }

    public boolean isEnable1xPrefixes() {
        return this.enable1xPrefixes;
    }

    void deleteQueue(SimpleString queueName) throws JMSException {
        if (!this.session.isClosed()) {
            try {
                this.session.deleteQueue(queueName);
            }
            catch (ActiveMQException activeMQException) {
                // empty catch block
            }
        }
    }

    public ActiveMQConnection getConnection() {
        return this.connection;
    }

    private void checkClosed() throws JMSException {
        if (this.session.isClosed()) {
            throw new IllegalStateException("Session is closed");
        }
    }

    private ActiveMQQueue lookupQueue(String queueName, boolean isTemporary) throws ActiveMQException {
        ActiveMQQueue queue;
        ClientSession.QueueQuery response;
        String queueNameToUse = queueName;
        if (this.enable1xPrefixes) {
            queueNameToUse = (isTemporary ? PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString() : PacketImpl.OLD_QUEUE_PREFIX.toString()) + queueName;
        }
        if (!(response = this.session.queueQuery((queue = isTemporary ? ActiveMQDestination.createTemporaryQueue(queueNameToUse) : ActiveMQDestination.createQueue(queueNameToUse)).getSimpleAddress())).isExists() && !response.isAutoCreateQueues()) {
            return null;
        }
        return queue;
    }

    private ActiveMQTopic lookupTopic(String topicName, boolean isTemporary) throws ActiveMQException {
        ActiveMQTopic topic;
        ClientSession.AddressQuery query;
        String topicNameToUse = topicName;
        if (this.enable1xPrefixes) {
            topicNameToUse = (isTemporary ? PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString() : PacketImpl.OLD_TOPIC_PREFIX.toString()) + topicName;
        }
        if (!(query = this.session.addressQuery((topic = isTemporary ? ActiveMQDestination.createTemporaryTopic(topicNameToUse) : ActiveMQDestination.createTopic(topicNameToUse)).getSimpleAddress())).isExists() && !query.isAutoCreateAddresses()) {
            return null;
        }
        return topic;
    }

    private void createTemporaryQueue(ActiveMQDestination destination, RoutingType routingType, SimpleString queueName, SimpleString filter, int maxConsumers, boolean purgeOnNoConsumers, Boolean exclusive, Boolean lastValue) throws ActiveMQException {
        QueueAttributes queueAttributes = destination.getQueueAttributes();
        if (queueAttributes == null) {
            this.session.createTemporaryQueue(destination.getSimpleAddress(), routingType, queueName, filter, maxConsumers, purgeOnNoConsumers, exclusive, lastValue);
        } else {
            this.session.createTemporaryQueue(destination.getSimpleAddress(), routingType, queueName, filter, queueAttributes.getMaxConsumers() == null ? maxConsumers : queueAttributes.getMaxConsumers(), queueAttributes.getPurgeOnNoConsumers() == null ? purgeOnNoConsumers : queueAttributes.getPurgeOnNoConsumers(), queueAttributes.getExclusive() == null ? exclusive : queueAttributes.getExclusive(), queueAttributes.getLastValue() == null ? lastValue : queueAttributes.getLastValue());
        }
    }

    private void createSharedQueue(ActiveMQDestination destination, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean lastValue) throws ActiveMQException {
        QueueAttributes queueAttributes = destination.getQueueAttributes();
        if (queueAttributes == null) {
            this.session.createSharedQueue(destination.getSimpleAddress(), routingType, queueName, filter, durable, maxConsumers, purgeOnNoConsumers, exclusive, lastValue);
        } else {
            this.session.createSharedQueue(destination.getSimpleAddress(), routingType, queueName, filter, durable, queueAttributes.getMaxConsumers() == null ? maxConsumers : queueAttributes.getMaxConsumers(), queueAttributes.getPurgeOnNoConsumers() == null ? purgeOnNoConsumers : queueAttributes.getPurgeOnNoConsumers(), queueAttributes.getExclusive() == null ? exclusive : queueAttributes.getExclusive(), queueAttributes.getLastValue() == null ? lastValue : queueAttributes.getLastValue());
        }
    }

    private void createQueue(ActiveMQDestination destination, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, Boolean exclusive, Boolean lastValue) throws ActiveMQException {
        QueueAttributes queueAttributes = destination.getQueueAttributes();
        if (queueAttributes == null) {
            this.session.createQueue(destination.getSimpleAddress(), routingType, queueName, filter, durable, autoCreated, maxConsumers, purgeOnNoConsumers, exclusive, lastValue);
        } else {
            this.session.createQueue(destination.getSimpleAddress(), routingType, queueName, filter, durable, autoCreated, queueAttributes.getMaxConsumers() == null ? maxConsumers : queueAttributes.getMaxConsumers(), queueAttributes.getPurgeOnNoConsumers() == null ? purgeOnNoConsumers : queueAttributes.getPurgeOnNoConsumers(), queueAttributes.getExclusive() == null ? exclusive : queueAttributes.getExclusive(), queueAttributes.getLastValue() == null ? lastValue : queueAttributes.getLastValue());
        }
    }

    static enum ConsumerDurability {
        DURABLE,
        NON_DURABLE;

    }
}

