/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class InflaterReader
extends InputStream {
    private Inflater inflater = new Inflater();
    private InputStream input;
    private byte[] readBuffer;
    private int pointer;
    private int length;

    public InflaterReader(InputStream input) {
        this(input, 1024);
    }

    public InflaterReader(InputStream input, int bufferSize) {
        this.input = input;
        this.readBuffer = new byte[bufferSize];
        this.pointer = -1;
    }

    @Override
    public int read() throws IOException {
        if (this.pointer == -1) {
            try {
                this.length = this.doRead(this.readBuffer, 0, this.readBuffer.length);
                if (this.length == 0) {
                    return -1;
                }
                this.pointer = 0;
            }
            catch (DataFormatException e) {
                IOException e2 = new IOException(e.getMessage());
                e2.initCause(e);
                throw e2;
            }
        }
        int value = this.readBuffer[this.pointer] & 0xFF;
        ++this.pointer;
        if (this.pointer == this.length) {
            this.pointer = -1;
        }
        return value;
    }

    private int doRead(byte[] buf, int offset, int len) throws DataFormatException, IOException {
        int read = 0;
        byte[] inputBuffer = new byte[len];
        while (len > 0) {
            int n = this.inflater.inflate(buf, offset, len);
            if (n == 0) {
                if (this.inflater.finished()) break;
                if (this.inflater.needsInput()) {
                    int m = this.input.read(inputBuffer);
                    if (m == -1) {
                        throw new DataFormatException("Input is over while inflater still expecting data");
                    }
                    this.inflater.setInput(inputBuffer, 0, m);
                    n = this.inflater.inflate(buf, offset, len);
                    if (n <= 0) continue;
                    read += n;
                    offset += n;
                    len -= n;
                    continue;
                }
                throw new DataFormatException("Inflater is neither finished nor needing input.");
            }
            read += n;
            offset += n;
            len -= n;
        }
        return read;
    }
}

