/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.message.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.buffers.impl.ResetLimitWrappedActiveMQBuffer;
import org.apache.activemq.artemis.core.message.LargeBodyEncoder;
import org.apache.activemq.artemis.core.message.impl.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.message.impl.CoreMessagePersister;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.collections.TypedProperties;

public class CoreMessage
extends RefCountMessage
implements ICoreMessage {
    private static final Predicate<SimpleString> INTERNAL_PROPERTY_NAMES_PREDICATE = name -> name.startsWith(Message.HDR_ROUTE_TO_IDS) && !name.equals(Message.HDR_ROUTE_TO_IDS) || name.startsWith(Message.HDR_ROUTE_TO_ACK_IDS) && !name.equals(Message.HDR_ROUTE_TO_ACK_IDS);
    public static final int BUFFER_HEADER_SPACE = 13;
    private volatile int memoryEstimate = -1;
    private static final Logger logger = Logger.getLogger(CoreMessage.class);
    public static final int BODY_OFFSET = 4;
    protected ByteBuf buffer;
    private volatile boolean validBuffer = false;
    protected volatile ResetLimitWrappedActiveMQBuffer writableBuffer;
    Object body;
    protected int endOfBodyPosition = -1;
    protected int messageIDPosition = -1;
    protected long messageID;
    protected SimpleString address;
    protected byte type;
    protected boolean durable;
    private long expiration;
    protected long timestamp;
    protected byte priority;
    private UUID userID;
    private int propertiesLocation = -1;
    protected volatile TypedProperties properties;
    private final CoreMessageObjectPools coreMessageObjectPools;

    public CoreMessage(CoreMessageObjectPools coreMessageObjectPools) {
        this.coreMessageObjectPools = coreMessageObjectPools;
    }

    public CoreMessage() {
        this.coreMessageObjectPools = null;
    }

    @Override
    public Object getAnnotation(SimpleString key) {
        return this.getObjectProperty(key);
    }

    @Override
    public Object removeAnnotation(SimpleString key) {
        return this.removeProperty(key);
    }

    @Override
    public void clearInternalProperties() {
        TypedProperties properties = this.properties;
        if (properties != null && properties.clearInternalProperties()) {
            this.messageChanged();
        }
    }

    @Override
    public Persister<Message> getPersister() {
        return CoreMessagePersister.getInstance();
    }

    public CoreMessage initBuffer(int initialMessageBufferSize) {
        this.buffer = ActiveMQBuffers.dynamicBuffer(initialMessageBufferSize).byteBuf();
        this.buffer.writeByte(0);
        this.buffer.setIndex(4, 4);
        return this;
    }

    @Override
    public SimpleString getReplyTo() {
        return this.getSimpleStringProperty(MessageUtil.REPLYTO_HEADER_NAME);
    }

    @Override
    public RoutingType getRoutingType() {
        if (this.containsProperty(Message.HDR_ROUTING_TYPE)) {
            return RoutingType.getType(this.getByteProperty(Message.HDR_ROUTING_TYPE));
        }
        return null;
    }

    @Override
    public Message setRoutingType(RoutingType routingType) {
        if (routingType == null) {
            this.removeProperty(Message.HDR_ROUTING_TYPE);
        } else {
            this.putByteProperty(Message.HDR_ROUTING_TYPE, routingType.getType());
        }
        return this;
    }

    @Override
    public CoreMessage setReplyTo(SimpleString address) {
        if (address == null) {
            this.getProperties().removeProperty(MessageUtil.REPLYTO_HEADER_NAME);
        } else {
            this.putStringProperty(MessageUtil.REPLYTO_HEADER_NAME, address);
        }
        return this;
    }

    @Override
    public void receiveBuffer(ByteBuf buffer) {
        this.buffer = buffer;
        this.buffer.retain();
        this.decode(false);
    }

    @Override
    public void receiveBuffer_1X(ByteBuf buffer) {
        this.buffer = buffer;
        this.buffer.retain();
        this.decode(true);
        this.validBuffer = false;
    }

    @Override
    public ActiveMQBuffer getReadOnlyBodyBuffer() {
        this.checkEncode();
        return new ChannelBufferWrapper(this.buffer.slice(4, this.endOfBodyPosition - 13).setIndex(0, this.endOfBodyPosition - 13).asReadOnly());
    }

    @Override
    public int getBodyBufferSize() {
        this.checkEncode();
        return this.endOfBodyPosition - 13;
    }

    @Override
    public ActiveMQBuffer getDataBuffer() {
        ActiveMQBuffer buffer;
        try {
            buffer = this.isLargeMessage() ? this.getLargeMessageBuffer() : this.getReadOnlyBodyBuffer();
            if (Boolean.TRUE.equals(this.getBooleanProperty(Message.HDR_LARGE_COMPRESSED))) {
                buffer = this.inflate(buffer);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), e);
            return this.getReadOnlyBodyBuffer();
        }
        return buffer;
    }

    private ActiveMQBuffer getLargeMessageBuffer() throws ActiveMQException {
        LargeBodyEncoder encoder = this.getBodyEncoder();
        encoder.open();
        int bodySize = (int)encoder.getLargeBodySize();
        ChannelBufferWrapper buffer = new ChannelBufferWrapper(UnpooledByteBufAllocator.DEFAULT.heapBuffer(bodySize));
        buffer.byteBuf().ensureWritable(bodySize);
        ByteBuffer nioBuffer = buffer.byteBuf().internalNioBuffer(0, bodySize);
        encoder.encode(nioBuffer);
        buffer.writerIndex(bodySize);
        encoder.close();
        return buffer;
    }

    private ActiveMQBuffer inflate(ActiveMQBuffer buffer) throws DataFormatException {
        int bytesToRead = buffer.readableBytes();
        Inflater inflater = new Inflater();
        inflater.setInput(ByteUtil.getActiveArray(buffer.readBytes(bytesToRead).toByteBuffer()));
        long sizeBody = this.getLongProperty(Message.HDR_LARGE_BODY_SIZE);
        byte[] data = new byte[(int)sizeBody];
        inflater.inflate(data);
        inflater.end();
        ActiveMQBuffer qbuff = ActiveMQBuffers.wrappedBuffer(data);
        qbuff.resetReaderIndex();
        qbuff.resetWriterIndex();
        qbuff.writeBytes(data);
        buffer = qbuff;
        return buffer;
    }

    @Override
    public SimpleString getGroupID() {
        return this.getSimpleStringProperty(Message.HDR_GROUP_ID);
    }

    @Override
    public CoreMessage setGroupID(SimpleString groupId) {
        return this.putStringProperty(Message.HDR_GROUP_ID, groupId);
    }

    @Override
    public CoreMessage setGroupID(String groupId) {
        return this.setGroupID(SimpleString.toSimpleString(groupId, this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getGroupIdStringSimpleStringPool()));
    }

    @Override
    public int getGroupSequence() {
        return this.containsProperty(Message.HDR_GROUP_SEQUENCE) ? this.getIntProperty(Message.HDR_GROUP_SEQUENCE) : 0;
    }

    @Override
    public CoreMessage setGroupSequence(int sequence) {
        return this.putIntProperty(Message.HDR_GROUP_SEQUENCE, sequence);
    }

    @Override
    public Object getCorrelationID() {
        return this.getObjectProperty(MessageUtil.CORRELATIONID_HEADER_NAME);
    }

    @Override
    public Message setCorrelationID(Object correlationID) {
        this.putObjectProperty(MessageUtil.CORRELATIONID_HEADER_NAME, correlationID);
        return this;
    }

    @Override
    public synchronized void sendBuffer(ByteBuf sendBuffer, int deliveryCount) {
        this.checkEncode();
        sendBuffer.writeBytes(this.buffer, 0, this.buffer.writerIndex());
    }

    @Override
    public synchronized void sendBuffer_1X(ByteBuf sendBuffer) {
        this.checkEncode();
        ByteBuf tmpBuffer = this.buffer.duplicate();
        sendBuffer.writeInt(this.endOfBodyPosition + 4);
        tmpBuffer.readerIndex(4);
        tmpBuffer.readBytes(sendBuffer, this.endOfBodyPosition - 13);
        sendBuffer.writeInt(tmpBuffer.writerIndex() + 4 + 13);
        tmpBuffer.readBytes(sendBuffer, tmpBuffer.readableBytes());
        sendBuffer.readerIndex(0);
    }

    protected synchronized void checkEncode() {
        if (!this.validBuffer) {
            this.encode();
        }
        this.internalWritableBuffer();
    }

    @Override
    public Long getScheduledDeliveryTime() {
        Object property = this.getProperties().getProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
        if (property != null && property instanceof Number) {
            return ((Number)property).longValue();
        }
        return 0L;
    }

    @Override
    public CoreMessage setScheduledDeliveryTime(Long time) {
        if (time == null || time == 0L) {
            this.getProperties().removeProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
        } else {
            this.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, (long)time);
        }
        return this;
    }

    @Override
    public InputStream getBodyInputStream() {
        return null;
    }

    @Override
    public ActiveMQBuffer getBodyBuffer() {
        this.getProperties();
        this.internalWritableBuffer();
        return this.writableBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalWritableBuffer() {
        if (this.writableBuffer == null) {
            CoreMessage coreMessage = this;
            synchronized (coreMessage) {
                if (this.writableBuffer == null) {
                    ResetLimitWrappedActiveMQBuffer writableBuffer = new ResetLimitWrappedActiveMQBuffer(4, this.buffer.duplicate(), (Message)this);
                    if (this.endOfBodyPosition > 0) {
                        writableBuffer.byteBuf().setIndex(4, this.endOfBodyPosition - 13 + 4);
                        writableBuffer.resetReaderIndex();
                    }
                    this.writableBuffer = writableBuffer;
                }
            }
        }
    }

    @Override
    public int getEndOfBodyPosition() {
        if (this.endOfBodyPosition < 0) {
            this.endOfBodyPosition = this.getBodyBuffer().writerIndex();
        }
        return this.endOfBodyPosition;
    }

    @Override
    public void messageChanged() {
        if (this.validBuffer) {
            this.validBuffer = false;
        }
    }

    protected CoreMessage(CoreMessage other) {
        this(other, other.properties);
    }

    public CoreMessage(long id, int bufferSize) {
        this(id, bufferSize, null);
    }

    public CoreMessage(long id, int bufferSize, CoreMessageObjectPools coreMessageObjectPools) {
        this.initBuffer(bufferSize);
        this.setMessageID(id);
        this.coreMessageObjectPools = coreMessageObjectPools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreMessage(CoreMessage other, TypedProperties copyProperties) {
        CoreMessage coreMessage = other;
        synchronized (coreMessage) {
            this.body = other.body;
            this.endOfBodyPosition = other.endOfBodyPosition;
            this.messageID = other.messageID;
            this.address = other.address;
            this.type = other.type;
            this.durable = other.durable;
            this.expiration = other.expiration;
            this.timestamp = other.timestamp;
            this.priority = other.priority;
            this.userID = other.userID;
            this.coreMessageObjectPools = other.coreMessageObjectPools;
            if (copyProperties != null) {
                this.properties = new TypedProperties(copyProperties);
            }
            if (other.buffer != null) {
                this.buffer = other.buffer.copy();
            }
        }
    }

    @Override
    public void copyHeadersAndProperties(Message msg) {
        this.messageID = msg.getMessageID();
        this.address = msg.getAddressSimpleString();
        this.userID = (UUID)msg.getUserID();
        this.type = msg.toCore().getType();
        this.durable = msg.isDurable();
        this.expiration = msg.getExpiration();
        this.timestamp = msg.getTimestamp();
        this.priority = msg.getPriority();
        if (msg instanceof CoreMessage) {
            this.properties = ((CoreMessage)msg).getProperties();
        }
    }

    @Override
    public Message copy() {
        this.getProperties();
        this.checkEncode();
        return new CoreMessage(this);
    }

    @Override
    public Message copy(long newID) {
        return this.copy().setMessageID(newID);
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public CoreMessage setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public long getMessageID() {
        return this.messageID;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public UUID getUserID() {
        return this.userID;
    }

    @Override
    public CoreMessage setUserID(Object uuid) {
        this.userID = (UUID)uuid;
        return this;
    }

    @Override
    public String getValidatedUserID() {
        return this.getStringProperty(Message.HDR_VALIDATED_USER);
    }

    @Override
    public CoreMessage setValidatedUserID(String validatedUserID) {
        this.putStringProperty(Message.HDR_VALIDATED_USER, this.value(validatedUserID));
        return this;
    }

    @Override
    public CoreMessage setMessageID(long messageID) {
        this.messageID = messageID;
        if (this.messageIDPosition >= 0 && this.validBuffer) {
            this.buffer.setLong(this.messageIDPosition, messageID);
        }
        return this;
    }

    @Override
    public CoreMessage setAddress(SimpleString address) {
        if (address == null && this.address == null) {
            return this;
        }
        if (this.validBuffer && (address == null || !address.equals(this.address))) {
            this.messageChanged();
        }
        this.address = address;
        return this;
    }

    @Override
    public SimpleString getAddressSimpleString() {
        return this.address;
    }

    @Override
    public CoreMessage setExpiration(long expiration) {
        this.expiration = expiration;
        this.messageChanged();
        return this;
    }

    @Override
    public CoreMessage setPriority(byte priority) {
        this.priority = priority;
        this.messageChanged();
        return this;
    }

    public CoreMessage setUserID(UUID userID) {
        this.userID = userID;
        this.messageChanged();
        return this;
    }

    public final TypedProperties getProperties() {
        TypedProperties properties = this.properties;
        if (properties == null) {
            properties = this.getOrInitializeTypedProperties();
        }
        return properties;
    }

    private synchronized TypedProperties getOrInitializeTypedProperties() {
        try {
            TypedProperties properties = this.properties;
            if (properties == null) {
                properties = new TypedProperties(INTERNAL_PROPERTY_NAMES_PREDICATE);
                if (this.buffer != null && this.propertiesLocation >= 0) {
                    ByteBuf byteBuf = this.buffer.duplicate().readerIndex(this.propertiesLocation);
                    properties.decode(byteBuf, this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesDecoderPools());
                }
                this.properties = properties;
            }
            return properties;
        }
        catch (Throwable e) {
            throw this.onCheckPropertiesError(e);
        }
    }

    private RuntimeException onCheckPropertiesError(Throwable e) {
        logger.warn((Object)("Could not decode properties for CoreMessage[messageID=" + this.messageID + ",durable=" + this.durable + ",userID=" + this.userID + ",priority=" + this.priority + ", timestamp=" + this.timestamp + ",expiration=" + this.expiration + ",address=" + this.address + ", propertiesLocation=" + this.propertiesLocation), e);
        ByteBuf buffer = this.buffer;
        if (buffer != null) {
            ByteBuf duplicatebuffer = buffer.duplicate();
            duplicatebuffer.readerIndex(0);
            logger.warn("Failed message has messageID=" + this.messageID + " and the following buffer:\n" + ByteBufUtil.prettyHexDump(duplicatebuffer));
        } else {
            logger.warn("Failed message has messageID=" + this.messageID + " and the buffer was null");
        }
        return new RuntimeException(e.getMessage(), e);
    }

    @Override
    public int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = 352 + (this.buffer != null ? this.buffer.capacity() : 0) + (this.properties != null ? this.properties.getMemoryOffset() : 0);
        }
        return this.memoryEstimate;
    }

    @Override
    public boolean isServerMessage() {
        return false;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public CoreMessage setType(byte type) {
        this.type = type;
        return this;
    }

    private void decode(boolean beforeAddress) {
        this.endOfBodyPosition = this.buffer.readInt();
        this.buffer.skipBytes(this.endOfBodyPosition - 13);
        this.decodeHeadersAndProperties(this.buffer, true);
        this.buffer.readerIndex(0);
        this.validBuffer = true;
        if (beforeAddress) {
            this.endOfBodyPosition -= 4;
        }
        this.internalWritableBuffer();
    }

    public void decodeHeadersAndProperties(ByteBuf buffer) {
        this.decodeHeadersAndProperties(buffer, false);
    }

    private void decodeHeadersAndProperties(ByteBuf buffer, boolean lazyProperties) {
        this.messageIDPosition = buffer.readerIndex();
        this.messageID = buffer.readLong();
        this.address = SimpleString.readNullableSimpleString(buffer, this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getAddressDecoderPool());
        if (buffer.readByte() == 1) {
            byte[] bytes = new byte[16];
            buffer.readBytes(bytes);
            this.userID = new UUID(1, bytes);
        } else {
            this.userID = null;
        }
        this.type = buffer.readByte();
        this.durable = buffer.readBoolean();
        this.expiration = buffer.readLong();
        this.timestamp = buffer.readLong();
        this.priority = buffer.readByte();
        if (lazyProperties) {
            this.properties = null;
            this.propertiesLocation = buffer.readerIndex();
        } else {
            this.properties = new TypedProperties(INTERNAL_PROPERTY_NAMES_PREDICATE);
            this.properties.decode(buffer, this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesDecoderPools());
        }
    }

    public synchronized CoreMessage encode() {
        this.getProperties();
        if (this.writableBuffer != null) {
            this.endOfBodyPosition = this.writableBuffer.writerIndex() + 13 - 4;
        } else if (this.endOfBodyPosition <= 0) {
            this.endOfBodyPosition = 17;
        }
        this.buffer.setIndex(0, 0);
        this.buffer.writeInt(this.endOfBodyPosition);
        this.buffer.writerIndex(this.endOfBodyPosition - 13 + 4);
        this.encodeHeadersAndProperties(this.buffer);
        this.validBuffer = true;
        return this;
    }

    public void encodeHeadersAndProperties(ByteBuf buffer) {
        TypedProperties properties = this.getProperties();
        this.messageIDPosition = buffer.writerIndex();
        buffer.writeLong(this.messageID);
        SimpleString.writeNullableSimpleString(buffer, this.address);
        if (this.userID == null) {
            buffer.writeByte(0);
        } else {
            buffer.writeByte(1);
            buffer.writeBytes(this.userID.asBytes());
        }
        buffer.writeByte(this.type);
        buffer.writeBoolean(this.durable);
        buffer.writeLong(this.expiration);
        buffer.writeLong(this.timestamp);
        buffer.writeByte(this.priority);
        properties.encode(buffer);
    }

    @Override
    public int getHeadersAndPropertiesEncodeSize() {
        return 9 + (this.userID == null ? 0 : 16) + SimpleString.sizeofNullableString(this.address) + 1 + 1 + 8 + 8 + 1 + this.getProperties().getEncodeSize();
    }

    @Override
    public Object getDuplicateProperty() {
        return this.getObjectProperty(Message.HDR_DUPLICATE_DETECTION_ID);
    }

    @Override
    public SimpleString getLastValueProperty() {
        return this.getSimpleStringProperty(Message.HDR_LAST_VALUE_NAME);
    }

    @Override
    public Message setLastValueProperty(SimpleString lastValueName) {
        return this.putStringProperty(Message.HDR_LAST_VALUE_NAME, lastValueName);
    }

    @Override
    public int getEncodeSize() {
        if (this.buffer == null) {
            return -1;
        }
        this.checkEncode();
        return this.buffer.writerIndex();
    }

    @Override
    public boolean isLargeMessage() {
        return false;
    }

    @Override
    public String getAddress() {
        if (this.address == null) {
            return null;
        }
        return this.address.toString();
    }

    @Override
    public CoreMessage setAddress(String address) {
        this.messageChanged();
        this.address = SimpleString.toSimpleString(address, this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getAddressStringSimpleStringPool());
        return this;
    }

    @Override
    public CoreMessage setBuffer(ByteBuf buffer) {
        this.buffer = buffer;
        return this;
    }

    @Override
    public ByteBuf getBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public CoreMessage setDurable(boolean durable) {
        this.messageChanged();
        this.durable = durable;
        return this;
    }

    @Override
    public CoreMessage putBooleanProperty(String key, boolean value) {
        return this.putBooleanProperty(this.key(key), value);
    }

    @Override
    public CoreMessage putBooleanProperty(SimpleString key, boolean value) {
        this.messageChanged();
        this.getProperties().putBooleanProperty(key, value);
        return this;
    }

    @Override
    public Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getBooleanProperty(key);
    }

    @Override
    public Boolean getBooleanProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getBooleanProperty(this.key(key));
    }

    @Override
    public CoreMessage putByteProperty(SimpleString key, byte value) {
        this.messageChanged();
        this.getProperties().putByteProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putByteProperty(String key, byte value) {
        return this.putByteProperty(this.key(key), value);
    }

    @Override
    public Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getByteProperty(key);
    }

    @Override
    public Byte getByteProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getByteProperty(this.key(key));
    }

    @Override
    public CoreMessage putBytesProperty(SimpleString key, byte[] value) {
        this.messageChanged();
        this.getProperties().putBytesProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putBytesProperty(String key, byte[] value) {
        return this.putBytesProperty(this.key(key), value);
    }

    @Override
    public byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getBytesProperty(key);
    }

    @Override
    public byte[] getBytesProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getBytesProperty(this.key(key));
    }

    @Override
    public CoreMessage putCharProperty(SimpleString key, char value) {
        this.messageChanged();
        this.getProperties().putCharProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putCharProperty(String key, char value) {
        return this.putCharProperty(this.key(key), value);
    }

    @Override
    public CoreMessage putShortProperty(SimpleString key, short value) {
        this.messageChanged();
        this.getProperties().putShortProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putShortProperty(String key, short value) {
        return this.putShortProperty(this.key(key), value);
    }

    @Override
    public CoreMessage putIntProperty(SimpleString key, int value) {
        this.messageChanged();
        this.getProperties().putIntProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putIntProperty(String key, int value) {
        return this.putIntProperty(this.key(key), value);
    }

    @Override
    public Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getIntProperty(key);
    }

    @Override
    public Integer getIntProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getIntProperty(this.key(key));
    }

    @Override
    public CoreMessage putLongProperty(SimpleString key, long value) {
        this.messageChanged();
        this.getProperties().putLongProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putLongProperty(String key, long value) {
        return this.putLongProperty(this.key(key), value);
    }

    @Override
    public Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getLongProperty(key);
    }

    @Override
    public Long getLongProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getLongProperty(this.key(key));
    }

    @Override
    public CoreMessage putFloatProperty(SimpleString key, float value) {
        this.messageChanged();
        this.getProperties().putFloatProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putFloatProperty(String key, float value) {
        return this.putFloatProperty(this.key(key), value);
    }

    @Override
    public CoreMessage putDoubleProperty(SimpleString key, double value) {
        this.messageChanged();
        this.getProperties().putDoubleProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putDoubleProperty(String key, double value) {
        return this.putDoubleProperty(this.key(key), value);
    }

    @Override
    public Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getDoubleProperty(key);
    }

    @Override
    public Double getDoubleProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getDoubleProperty(this.key(key));
    }

    @Override
    public CoreMessage putStringProperty(SimpleString key, SimpleString value) {
        this.messageChanged();
        this.getProperties().putSimpleStringProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putStringProperty(SimpleString key, String value) {
        return this.putStringProperty(key, this.value(value));
    }

    @Override
    public CoreMessage putStringProperty(String key, String value) {
        return this.putStringProperty(this.key(key), this.value(value));
    }

    @Override
    public CoreMessage putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
        this.messageChanged();
        TypedProperties.setObjectProperty(key, value, this.getProperties());
        return this;
    }

    @Override
    public Object getObjectProperty(String key) {
        return this.getObjectProperty(this.key(key));
    }

    @Override
    public Object getObjectProperty(SimpleString key) {
        return this.getProperties().getProperty(key);
    }

    @Override
    public CoreMessage putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
        return this.putObjectProperty(this.key(key), value);
    }

    @Override
    public Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getShortProperty(key);
    }

    @Override
    public Short getShortProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getShortProperty(this.key(key));
    }

    @Override
    public Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getFloatProperty(key);
    }

    @Override
    public Float getFloatProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getFloatProperty(this.key(key));
    }

    @Override
    public String getStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        SimpleString str = this.getSimpleStringProperty(key);
        if (str == null) {
            return null;
        }
        return str.toString();
    }

    @Override
    public String getStringProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getStringProperty(this.key(key));
    }

    @Override
    public SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getSimpleStringProperty(key);
    }

    @Override
    public SimpleString getSimpleStringProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getSimpleStringProperty(this.key(key));
    }

    @Override
    public Object removeProperty(SimpleString key) {
        Object oldValue = this.getProperties().removeProperty(key);
        if (oldValue != null) {
            this.messageChanged();
        }
        return oldValue;
    }

    @Override
    public Object removeProperty(String key) {
        return this.removeProperty(this.key(key));
    }

    @Override
    public boolean containsProperty(SimpleString key) {
        return this.getProperties().containsProperty(key);
    }

    @Override
    public boolean containsProperty(String key) {
        return this.containsProperty(this.key(key));
    }

    @Override
    public Set<SimpleString> getPropertyNames() {
        return this.getProperties().getPropertyNames();
    }

    @Override
    public LargeBodyEncoder getBodyEncoder() throws ActiveMQException {
        return new DecodingContext();
    }

    @Override
    public int getPersistSize() {
        this.checkEncode();
        return this.buffer.writerIndex() + 4;
    }

    @Override
    public void persist(ActiveMQBuffer targetRecord) {
        this.checkEncode();
        targetRecord.writeInt(this.buffer.writerIndex());
        targetRecord.writeBytes(this.buffer, 0, this.buffer.writerIndex());
    }

    @Override
    public void reloadPersistence(ActiveMQBuffer record) {
        int size = record.readInt();
        this.initBuffer(size);
        this.buffer.setIndex(0, 0).writeBytes(record.byteBuf(), size);
        this.decode(false);
    }

    @Override
    public CoreMessage toCore() {
        return this;
    }

    @Override
    public CoreMessage toCore(CoreMessageObjectPools coreMessageObjectPools) {
        return this;
    }

    public String toString() {
        try {
            TypedProperties properties = this.getProperties();
            return "CoreMessage[messageID=" + this.messageID + ",durable=" + this.isDurable() + ",userID=" + this.getUserID() + ",priority=" + this.getPriority() + ", timestamp=" + CoreMessage.toDate(this.getTimestamp()) + ",expiration=" + CoreMessage.toDate(this.getExpiration()) + ", durable=" + this.durable + ", address=" + this.getAddress() + ",size=" + this.getPersistentSize() + ",properties=" + properties + "]@" + System.identityHashCode(this);
        }
        catch (Throwable e) {
            logger.warn((Object)"Error creating String for message: ", e);
            return "ServerMessage[messageID=" + this.messageID + "]";
        }
    }

    private static String toDate(long timestamp) {
        if (timestamp == 0L) {
            return "0";
        }
        return new Date(timestamp).toString();
    }

    private SimpleString key(String key) {
        return SimpleString.toSimpleString(key, this.getPropertyKeysPool());
    }

    private SimpleString value(String value) {
        return SimpleString.toSimpleString(value, this.getPropertyValuesPool());
    }

    private SimpleString.StringSimpleStringPool getPropertyKeysPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyKeysPool();
    }

    private SimpleString.StringSimpleStringPool getPropertyValuesPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyValuesPool();
    }

    @Override
    public long getPersistentSize() throws ActiveMQException {
        return this.getEncodeSize();
    }

    private final class DecodingContext
    implements LargeBodyEncoder {
        private int lastPos = 0;

        private DecodingContext() {
        }

        @Override
        public void open() {
        }

        @Override
        public void close() {
        }

        @Override
        public long getLargeBodySize() {
            return CoreMessage.this.buffer.writerIndex();
        }

        @Override
        public int encode(ByteBuffer bufferRead) {
            int remaining = bufferRead.remaining();
            CoreMessage.this.buffer.getBytes(this.lastPos, bufferRead);
            this.lastPos += remaining;
            return remaining;
        }
    }
}

