/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.api.core.SimpleString;

public class CompositeAddress {
    public static String SEPARATOR = "::";

    public static String toFullyQualified(String address, String qName) {
        return address + SEPARATOR + qName;
    }

    public static SimpleString toFullyQualified(SimpleString address, SimpleString qName) {
        return address.concat(SEPARATOR).concat(qName);
    }

    public static boolean isFullyQualified(String address) {
        return address == null ? false : address.contains(SEPARATOR);
    }

    public static SimpleString extractQueueName(SimpleString name) {
        return name == null ? null : new SimpleString(CompositeAddress.extractQueueName(name.toString()));
    }

    public static String extractQueueName(String queue) {
        if (queue == null) {
            return null;
        }
        int index = queue.indexOf(SEPARATOR);
        if (index != -1) {
            return queue.substring(index + SEPARATOR.length());
        }
        return queue;
    }

    public static SimpleString extractAddressName(SimpleString address) {
        return address == null ? null : new SimpleString(CompositeAddress.extractAddressName(address.toString()));
    }

    public static String extractAddressName(String address) {
        if (address == null) {
            return null;
        }
        int index = address.indexOf(SEPARATOR);
        if (index != -1) {
            return address.substring(0, index);
        }
        return address;
    }
}

