/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms.management;

import java.util.Map;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.artemis.api.core.management.Attribute;
import org.apache.activemq.artemis.api.core.management.Operation;
import org.apache.activemq.artemis.api.core.management.Parameter;
import org.apache.activemq.artemis.api.jms.management.DestinationControl;

public interface JMSQueueControl
extends DestinationControl {
    @Attribute(desc="expiry address associated with this queue")
    public String getExpiryAddress();

    @Attribute(desc="dead-letter address associated with this queue")
    public String getDeadLetterAddress();

    @Attribute(desc="number of scheduled messages in this queue")
    public long getScheduledCount();

    @Attribute(desc="number of consumers consuming messages from this queue")
    public int getConsumerCount();

    @Attribute(desc="the number of messages expired from this queue since it was created")
    public long getMessagesExpired();

    @Attribute(desc="number of messages removed from this queue since it was created due to exceeding the max delivery attempts")
    public long getMessagesKilled();

    @Attribute(desc="selector for the queue")
    public String getSelector();

    @Attribute(desc="first message on the queue as JSON")
    public String getFirstMessageAsJSON() throws Exception;

    @Attribute(desc="timestamp of the first message in milliseconds")
    public Long getFirstMessageTimestamp() throws Exception;

    @Attribute(desc="age of the first message in milliseconds")
    public Long getFirstMessageAge() throws Exception;

    @Attribute(desc="Returns the list of Registry bindings associated with this queue")
    public String[] getRegistryBindings();

    @Operation(desc="Adds the queue to another Registry binding")
    public void addBinding(@Parameter(name="binding", desc="the name of the binding for the registry") String var1) throws Exception;

    @Operation(desc="List all messages in the queue which matches the filter", impact=0)
    public Map<String, Object>[] listMessages(@Parameter(name="filter", desc="A JMS Message filter") String var1) throws Exception;

    @Operation(desc="List all messages in the queue which matches the filter and return them using JSON", impact=0)
    public String listMessagesAsJSON(@Parameter(name="filter", desc="A JMS Message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Returns the number of the messages in the queue matching the given filter", impact=0)
    public long countMessages(@Parameter(name="filter", desc="A JMS message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Remove the message corresponding to the given messageID", impact=1)
    public boolean removeMessage(@Parameter(name="messageID", desc="A message ID") String var1) throws Exception;

    @Override
    @Operation(desc="Remove the messages corresponding to the given filter (and returns the number of removed messages)", impact=1)
    public int removeMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Expire the messages corresponding to the given filter (and returns the number of expired messages)", impact=1)
    public int expireMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Expire the message corresponding to the given messageID", impact=1)
    public boolean expireMessage(@Parameter(name="messageID", desc="A message ID") String var1) throws Exception;

    @Operation(desc="Send the message corresponding to the given messageID to this queue's Dead Letter Address", impact=1)
    public boolean sendMessageToDeadLetterAddress(@Parameter(name="messageID", desc="A message ID") String var1) throws Exception;

    @Operation(desc="Send the messages corresponding to the given filter to this queue's Dead Letter Address", impact=1)
    public int sendMessagesToDeadLetterAddress(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Sends a TextMessage to a password-protected destination.", impact=1)
    public String sendTextMessage(@Parameter(name="body") String var1) throws Exception;

    @Operation(desc="Sends a TextMessage to a password-protected destination.", impact=1)
    public String sendTextMessageWithProperties(String var1) throws Exception;

    @Operation(desc="Sends a TextMessage to a password-protected destination.", impact=1)
    public String sendTextMessage(@Parameter(name="headers") Map<String, String> var1, @Parameter(name="body") String var2) throws Exception;

    @Operation(desc="Sends a TextMessage to a password-protected destination.", impact=1)
    public String sendTextMessage(@Parameter(name="body") String var1, @Parameter(name="user") String var2, @Parameter(name="password") String var3) throws Exception;

    @Operation(desc="Sends a TextMessage to a password-protected destination.", impact=1)
    public String sendTextMessage(@Parameter(name="headers") Map<String, String> var1, @Parameter(name="body") String var2, @Parameter(name="user") String var3, @Parameter(name="password") String var4) throws Exception;

    @Operation(desc="Change the priority of the message corresponding to the given messageID", impact=1)
    public boolean changeMessagePriority(@Parameter(name="messageID", desc="A message ID") String var1, @Parameter(name="newPriority", desc="the new priority (between 0 and 9)") int var2) throws Exception;

    @Operation(desc="Change the priority of the messages corresponding to the given filter", impact=1)
    public int changeMessagesPriority(@Parameter(name="filter", desc="A message filter") String var1, @Parameter(name="newPriority", desc="the new priority (between 0 and 9)") int var2) throws Exception;

    @Operation(desc="Move the message corresponding to the given messageID to another queue, ignoring duplicates (rejectDuplicates=false on this case)", impact=1)
    public boolean moveMessage(@Parameter(name="messageID", desc="A message ID") String var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the message to") String var2) throws Exception;

    @Operation(desc="Move the message corresponding to the given messageID to another queue", impact=1)
    public boolean moveMessage(@Parameter(name="messageID", desc="A message ID") String var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the message to") String var2, @Parameter(name="rejectDuplicates", desc="Reject messages identified as duplicate by the duplicate message") boolean var3) throws Exception;

    @Operation(desc="Move the messages corresponding to the given filter (and returns the number of moved messages). rejectDuplicates=false on this case", impact=1)
    public int moveMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the messages to") String var2) throws Exception;

    @Operation(desc="Move the messages corresponding to the given filter (and returns the number of moved messages)", impact=1)
    public int moveMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the messages to") String var2, @Parameter(name="rejectDuplicates", desc="Reject messages identified as duplicate by the duplicate message") boolean var3) throws Exception;

    @Operation(desc="Retry the message corresponding to the given messageID to the original queue", impact=1)
    public boolean retryMessage(@Parameter(name="messageID", desc="A message ID") String var1) throws Exception;

    @Operation(desc="Retry all messages on a DLQ to their respective original queues", impact=1)
    public int retryMessages() throws Exception;

    @Operation(desc="List the message counters", impact=0)
    public String listMessageCounter() throws Exception;

    @Operation(desc="Reset the message counters", impact=0)
    public void resetMessageCounter() throws Exception;

    @Operation(desc="List the message counters as HTML", impact=0)
    public String listMessageCounterAsHTML() throws Exception;

    @Operation(desc="List the message counters history", impact=0)
    public String listMessageCounterHistory() throws Exception;

    @Operation(desc="List the message counters history as HTML", impact=0)
    public String listMessageCounterHistoryAsHTML() throws Exception;

    @Operation(desc="Pause the queue.", impact=1)
    public void pause() throws Exception;

    @Attribute(desc="Returns true if the queue is paused.")
    public boolean isPaused() throws Exception;

    @Operation(desc="Resume the queue.", impact=1)
    public void resume() throws Exception;

    @Operation(desc="Browse the queue.", impact=1)
    public CompositeData[] browse() throws Exception;

    @Operation(desc="Browse the queue.", impact=1)
    public CompositeData[] browse(String var1) throws Exception;

    @Operation(desc="List all the existent consumers on the Queue")
    public String listConsumersAsJSON() throws Exception;

    public void flushExecutor();

    @Operation(desc="List the messages scheduled for delivery", impact=0)
    public Map<String, Object>[] listScheduledMessages() throws Exception;

    @Operation(desc="List the messages scheduled for delivery and returns them using JSON", impact=0)
    public String listScheduledMessagesAsJSON() throws Exception;

    @Operation(desc="List all messages being delivered per consumer")
    public Map<String, Map<String, Object>[]> listDeliveringMessages() throws Exception;

    @Operation(desc="list all messages being delivered per consumer using JSON form")
    public String listDeliveringMessagesAsJSON() throws Exception;
}

