/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQXAConnection;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.DefaultConnectionProperties;
import org.apache.activemq.artemis.jms.client.JmsExceptionUtils;
import org.apache.activemq.artemis.jndi.JNDIStorable;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.apache.activemq.artemis.uri.ConnectionFactoryParser;
import org.apache.activemq.artemis.uri.ServerLocatorParser;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.apache.activemq.artemis.utils.uri.URISupport;

public class ActiveMQConnectionFactory
extends JNDIStorable
implements ConnectionFactoryOptions,
Externalizable,
ConnectionFactory,
XAConnectionFactory,
AutoCloseable {
    private static final long serialVersionUID = 6730844785641767519L;
    private ServerLocator serverLocator;
    private String clientID;
    private boolean enableSharedClientID = false;
    private int dupsOKBatchSize = 0x100000;
    private int transactionBatchSize = 0x100000;
    private boolean readOnly;
    private String user;
    private String password;
    private String passwordCodec;
    private String protocolManagerFactoryStr;
    private String deserializationDenyList;
    private String deserializationAllowList;
    private boolean cacheDestinations;
    private boolean finalizeChecks;
    private boolean ignoreJTA;
    private boolean enable1xPrefixes = ActiveMQJMSClient.DEFAULT_ENABLE_1X_PREFIXES;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        URI uri = this.toURI();
        try {
            out.writeUTF(uri.toASCIIString());
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public URI toURI() throws IOException {
        URI uri;
        ConnectionFactoryParser parser = new ConnectionFactoryParser();
        String scheme = this.serverLocator.getDiscoveryGroupConfiguration() != null ? (this.serverLocator.getDiscoveryGroupConfiguration().getBroadcastEndpointFactory() instanceof UDPBroadcastEndpointFactory ? "udp" : "jgroups") : (this.serverLocator.allInVM() ? "vm" : "tcp");
        try {
            uri = parser.createSchema(scheme, this);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        return uri;
    }

    public String getProtocolManagerFactoryStr() {
        return this.protocolManagerFactoryStr;
    }

    public void setProtocolManagerFactoryStr(final String protocolManagerFactoryStr) {
        if (protocolManagerFactoryStr != null && !protocolManagerFactoryStr.trim().isEmpty() && !protocolManagerFactoryStr.equals("undefined")) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ClientProtocolManagerFactory protocolManagerFactory = (ClientProtocolManagerFactory)ClassloadingUtil.newInstanceFromClassLoader(ActiveMQConnectionFactory.class, (String)protocolManagerFactoryStr);
                    ActiveMQConnectionFactory.this.serverLocator.setProtocolManagerFactory(protocolManagerFactory);
                    return null;
                }
            });
            this.protocolManagerFactoryStr = protocolManagerFactoryStr;
        }
    }

    @Override
    @Deprecated(forRemoval=true)
    public String getDeserializationBlackList() {
        return this.deserializationDenyList;
    }

    @Override
    @Deprecated(forRemoval=true)
    public void setDeserializationBlackList(String denyList) {
        this.deserializationDenyList = denyList;
    }

    @Override
    @Deprecated(forRemoval=true)
    public String getDeserializationWhiteList() {
        return this.deserializationAllowList;
    }

    @Override
    @Deprecated(forRemoval=true)
    public void setDeserializationWhiteList(String allowList) {
        this.deserializationAllowList = allowList;
    }

    @Override
    public String getDeserializationDenyList() {
        return this.deserializationDenyList;
    }

    @Override
    public void setDeserializationDenyList(String denyList) {
        this.deserializationDenyList = denyList;
    }

    @Override
    public String getDeserializationAllowList() {
        return this.deserializationAllowList;
    }

    @Override
    public void setDeserializationAllowList(String allowList) {
        this.deserializationAllowList = allowList;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String url = in.readUTF();
        ConnectionFactoryParser parser = new ConnectionFactoryParser();
        ServerLocatorParser locatorParser = new ServerLocatorParser();
        try {
            URI uri = new URI(url);
            this.serverLocator = (ServerLocator)locatorParser.newObject(uri, null);
            parser.populateObject(uri, this);
        }
        catch (Exception e) {
            InvalidObjectException ex = new InvalidObjectException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public ActiveMQConnectionFactory() {
        this(DefaultConnectionProperties.DEFAULT_BROKER_URL);
    }

    public ActiveMQConnectionFactory(String brokerURL) {
        try {
            this.setBrokerURL(brokerURL);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public void setBrokerURL(String brokerURL) throws JMSException {
        if (this.readOnly) {
            throw new javax.jms.IllegalStateException("You cannot use setBrokerURL after the connection factory has been used");
        }
        ConnectionFactoryParser cfParser = new ConnectionFactoryParser();
        try {
            URI uri = cfParser.expandURI(brokerURL);
            this.serverLocator = ServerLocatorImpl.newLocator((URI)uri);
            cfParser.populateObject(uri, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.getUser() == null) {
            this.setUser(DefaultConnectionProperties.DEFAULT_USER);
        }
        if (this.getPassword() == null) {
            this.setPassword(DefaultConnectionProperties.DEFAULT_PASSWORD);
        }
        if (this.getPasswordCodec() == null) {
            this.setPasswordCodec(DefaultConnectionProperties.DEFAULT_PASSWORD_CODEC);
        }
    }

    public ActiveMQConnectionFactory(String url, String user, String password) {
        this(url);
        this.setUser(user).setPassword(password);
    }

    public ActiveMQConnectionFactory(ServerLocator serverLocator) {
        this.serverLocator = serverLocator;
    }

    public ActiveMQConnectionFactory(boolean ha, DiscoveryGroupConfiguration groupConfiguration) {
        this.serverLocator = ha ? ActiveMQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)groupConfiguration) : ActiveMQClient.createServerLocatorWithoutHA((DiscoveryGroupConfiguration)groupConfiguration);
    }

    public ActiveMQConnectionFactory(boolean ha, TransportConfiguration ... initialConnectors) {
        this.serverLocator = ha ? ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])initialConnectors) : ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])initialConnectors);
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(this.user, this.password);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 0);
    }

    public JMSContext createContext() {
        return this.createContext(this.user, this.password);
    }

    public JMSContext createContext(int sessionMode) {
        return this.createContext(this.user, this.password, sessionMode);
    }

    public JMSContext createContext(String userName, String password) {
        return this.createContext(userName, password, 1);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        ActiveMQConnectionFactory.validateSessionMode(sessionMode);
        try {
            ActiveMQConnection connection = this.createConnectionInternal(userName, password, false, 0);
            return connection.createContext(sessionMode);
        }
        catch (JMSSecurityException e) {
            throw new JMSSecurityRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    private static void validateSessionMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 100: 
            case 101: {
                return;
            }
        }
        throw new JMSRuntimeException("Invalid Session Mode: " + mode);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(this.user, this.password);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 1);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(this.user, this.password);
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 2);
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(this.user, this.password);
    }

    public XAConnection createXAConnection(String username, String password) throws JMSException {
        return (XAConnection)this.createConnectionInternal(username, password, true, 0);
    }

    public XAJMSContext createXAContext() {
        return this.createXAContext(this.user, this.password);
    }

    public XAJMSContext createXAContext(String userName, String password) {
        try {
            ActiveMQConnection connection = this.createConnectionInternal(userName, password, true, 0);
            return connection.createXAContext();
        }
        catch (JMSSecurityException e) {
            throw new JMSSecurityRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return this.createXAQueueConnection(this.user, this.password);
    }

    public XAQueueConnection createXAQueueConnection(String username, String password) throws JMSException {
        return (XAQueueConnection)this.createConnectionInternal(username, password, true, 1);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return this.createXATopicConnection(this.user, this.password);
    }

    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        return (XATopicConnection)this.createConnectionInternal(username, password, true, 2);
    }

    @Override
    protected void buildFromProperties(Properties props) {
        String url = props.getProperty("java.naming.provider.url");
        if (url == null || url.isEmpty()) {
            url = props.getProperty("brokerURL");
        }
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("java.naming.provider.url or brokerURL is required");
        }
        try {
            if (url != null && url.length() > 0) {
                url = this.updateBrokerURL(url, props);
                this.setBrokerURL(url);
            }
            BeanSupport.setProperties((Object)this, (Properties)props);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | JMSException e) {
            throw new RuntimeException(e);
        }
    }

    private String updateBrokerURL(String url, Properties props) {
        ConnectionFactoryParser cfParser = new ConnectionFactoryParser();
        try {
            URI uri = cfParser.expandURI(url);
            Map params = URISupport.parseParameters((URI)uri);
            for (String key : TransportConstants.ALLOWABLE_CONNECTOR_KEYS) {
                String val = props.getProperty(key);
                if (val == null) continue;
                params.put(key, val);
            }
            String newUrl = URISupport.applyParameters((URI)uri, (Map)params).toString();
            return newUrl;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    protected void populateProperties(Properties props) {
        try {
            URI uri = this.toURI();
            if (uri != null) {
                props.put("java.naming.provider.url", uri.toASCIIString());
                props.put("brokerURL", uri.toASCIIString());
            }
            BeanSupport.getProperties((Object)this, (Properties)props);
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isHA() {
        return this.serverLocator.isHA();
    }

    public synchronized String getConnectionLoadBalancingPolicyClassName() {
        return this.serverLocator.getConnectionLoadBalancingPolicyClassName();
    }

    public synchronized void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        this.checkWrite();
        this.serverLocator.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    public synchronized TransportConfiguration[] getStaticConnectors() {
        return this.serverLocator.getStaticTransportConfigurations();
    }

    public synchronized DiscoveryGroupConfiguration getDiscoveryGroupConfiguration() {
        return this.serverLocator.getDiscoveryGroupConfiguration();
    }

    public synchronized String getClientID() {
        return this.clientID;
    }

    public synchronized void setClientID(String clientID) {
        this.checkWrite();
        this.clientID = clientID;
    }

    public boolean isEnableSharedClientID() {
        return this.enableSharedClientID;
    }

    public void setEnableSharedClientID(boolean enableSharedClientID) {
        this.enableSharedClientID = enableSharedClientID;
    }

    public synchronized int getDupsOKBatchSize() {
        return this.dupsOKBatchSize;
    }

    public synchronized void setDupsOKBatchSize(int dupsOKBatchSize) {
        this.checkWrite();
        this.dupsOKBatchSize = dupsOKBatchSize;
    }

    public synchronized int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public synchronized void setTransactionBatchSize(int transactionBatchSize) {
        this.checkWrite();
        this.transactionBatchSize = transactionBatchSize;
    }

    public synchronized boolean isCacheDestinations() {
        return this.cacheDestinations;
    }

    public synchronized void setCacheDestinations(boolean cacheDestinations) {
        this.checkWrite();
        this.cacheDestinations = cacheDestinations;
    }

    public synchronized boolean isEnable1xPrefixes() {
        return this.enable1xPrefixes;
    }

    public synchronized void setEnable1xPrefixes(boolean enable1xPrefixes) {
        this.checkWrite();
        this.enable1xPrefixes = enable1xPrefixes;
    }

    public synchronized long getClientFailureCheckPeriod() {
        return this.serverLocator.getClientFailureCheckPeriod();
    }

    public synchronized void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.checkWrite();
        this.serverLocator.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    public synchronized long getConnectionTTL() {
        return this.serverLocator.getConnectionTTL();
    }

    public synchronized void setConnectionTTL(long connectionTTL) {
        this.checkWrite();
        this.serverLocator.setConnectionTTL(connectionTTL);
    }

    public synchronized long getCallTimeout() {
        return this.serverLocator.getCallTimeout();
    }

    public synchronized void setCallTimeout(long callTimeout) {
        this.checkWrite();
        this.serverLocator.setCallTimeout(callTimeout);
    }

    public synchronized long getCallFailoverTimeout() {
        return this.serverLocator.getCallFailoverTimeout();
    }

    public synchronized void setCallFailoverTimeout(long callTimeout) {
        this.checkWrite();
        this.serverLocator.setCallFailoverTimeout(callTimeout);
    }

    public synchronized void setUseTopologyForLoadBalancing(boolean useTopologyForLoadBalancing) {
        this.checkWrite();
        this.serverLocator.setUseTopologyForLoadBalancing(useTopologyForLoadBalancing);
    }

    public synchronized boolean isUseTopologyForLoadBalancing() {
        return this.serverLocator.getUseTopologyForLoadBalancing();
    }

    public synchronized int getConsumerWindowSize() {
        return this.serverLocator.getConsumerWindowSize();
    }

    public synchronized void setConsumerWindowSize(int consumerWindowSize) {
        this.checkWrite();
        this.serverLocator.setConsumerWindowSize(consumerWindowSize);
    }

    public synchronized int getConsumerMaxRate() {
        return this.serverLocator.getConsumerMaxRate();
    }

    public synchronized void setConsumerMaxRate(int consumerMaxRate) {
        this.checkWrite();
        this.serverLocator.setConsumerMaxRate(consumerMaxRate);
    }

    public synchronized int getConfirmationWindowSize() {
        return this.serverLocator.getConfirmationWindowSize();
    }

    public synchronized void setConfirmationWindowSize(int confirmationWindowSize) {
        this.checkWrite();
        this.serverLocator.setConfirmationWindowSize(confirmationWindowSize);
    }

    public synchronized int getProducerMaxRate() {
        return this.serverLocator.getProducerMaxRate();
    }

    public synchronized void setProducerMaxRate(int producerMaxRate) {
        this.checkWrite();
        this.serverLocator.setProducerMaxRate(producerMaxRate);
    }

    public synchronized int getProducerWindowSize() {
        return this.serverLocator.getProducerWindowSize();
    }

    public synchronized void setProducerWindowSize(int producerWindowSize) {
        this.checkWrite();
        this.serverLocator.setProducerWindowSize(producerWindowSize);
    }

    public synchronized void setCacheLargeMessagesClient(boolean cacheLargeMessagesClient) {
        this.checkWrite();
        this.serverLocator.setCacheLargeMessagesClient(cacheLargeMessagesClient);
    }

    public synchronized boolean isCacheLargeMessagesClient() {
        return this.serverLocator.isCacheLargeMessagesClient();
    }

    public synchronized int getMinLargeMessageSize() {
        return this.serverLocator.getMinLargeMessageSize();
    }

    public synchronized void setMinLargeMessageSize(int minLargeMessageSize) {
        this.checkWrite();
        this.serverLocator.setMinLargeMessageSize(minLargeMessageSize);
    }

    public synchronized boolean isBlockOnAcknowledge() {
        return this.serverLocator.isBlockOnAcknowledge();
    }

    public synchronized void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.checkWrite();
        this.serverLocator.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    public synchronized boolean isBlockOnNonDurableSend() {
        return this.serverLocator.isBlockOnNonDurableSend();
    }

    public synchronized void setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.checkWrite();
        this.serverLocator.setBlockOnNonDurableSend(blockOnNonDurableSend);
    }

    public synchronized boolean isBlockOnDurableSend() {
        return this.serverLocator.isBlockOnDurableSend();
    }

    public synchronized void setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.checkWrite();
        this.serverLocator.setBlockOnDurableSend(blockOnDurableSend);
    }

    public synchronized boolean isAutoGroup() {
        return this.serverLocator.isAutoGroup();
    }

    public synchronized void setAutoGroup(boolean autoGroup) {
        this.checkWrite();
        this.serverLocator.setAutoGroup(autoGroup);
    }

    public synchronized boolean isPreAcknowledge() {
        return this.serverLocator.isPreAcknowledge();
    }

    public synchronized void setPreAcknowledge(boolean preAcknowledge) {
        this.checkWrite();
        this.serverLocator.setPreAcknowledge(preAcknowledge);
    }

    public synchronized long getRetryInterval() {
        return this.serverLocator.getRetryInterval();
    }

    public synchronized void setRetryInterval(long retryInterval) {
        this.checkWrite();
        this.serverLocator.setRetryInterval(retryInterval);
    }

    public synchronized long getMaxRetryInterval() {
        return this.serverLocator.getMaxRetryInterval();
    }

    public synchronized void setMaxRetryInterval(long retryInterval) {
        this.checkWrite();
        this.serverLocator.setMaxRetryInterval(retryInterval);
    }

    public synchronized double getRetryIntervalMultiplier() {
        return this.serverLocator.getRetryIntervalMultiplier();
    }

    public synchronized void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.checkWrite();
        this.serverLocator.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    public synchronized int getReconnectAttempts() {
        return this.serverLocator.getReconnectAttempts();
    }

    public synchronized void setReconnectAttempts(int reconnectAttempts) {
        this.checkWrite();
        this.serverLocator.setReconnectAttempts(reconnectAttempts);
    }

    public synchronized void setInitialConnectAttempts(int reconnectAttempts) {
        this.checkWrite();
        this.serverLocator.setInitialConnectAttempts(reconnectAttempts);
    }

    public synchronized int getInitialConnectAttempts() {
        return this.serverLocator.getInitialConnectAttempts();
    }

    @Deprecated
    public synchronized boolean isFailoverOnInitialConnection() {
        return false;
    }

    @Deprecated
    public synchronized void setFailoverOnInitialConnection(boolean failover) {
    }

    public synchronized boolean isUseGlobalPools() {
        return this.serverLocator.isUseGlobalPools();
    }

    public synchronized void setUseGlobalPools(boolean useGlobalPools) {
        this.checkWrite();
        this.serverLocator.setUseGlobalPools(useGlobalPools);
    }

    public synchronized int getScheduledThreadPoolMaxSize() {
        return this.serverLocator.getScheduledThreadPoolMaxSize();
    }

    public synchronized void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.checkWrite();
        this.serverLocator.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
    }

    public synchronized int getThreadPoolMaxSize() {
        return this.serverLocator.getThreadPoolMaxSize();
    }

    public synchronized void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.checkWrite();
        this.serverLocator.setThreadPoolMaxSize(threadPoolMaxSize);
    }

    public synchronized int getInitialMessagePacketSize() {
        return this.serverLocator.getInitialMessagePacketSize();
    }

    public synchronized void setInitialMessagePacketSize(int size) {
        this.checkWrite();
        this.serverLocator.setInitialMessagePacketSize(size);
    }

    public boolean isIgnoreJTA() {
        return this.ignoreJTA;
    }

    public void setIgnoreJTA(boolean ignoreJTA) {
        this.checkWrite();
        this.ignoreJTA = ignoreJTA;
    }

    public void setIncomingInterceptorList(String interceptorList) {
        this.checkWrite();
        this.serverLocator.setIncomingInterceptorList(interceptorList);
    }

    public String getIncomingInterceptorList() {
        return this.serverLocator.getIncomingInterceptorList();
    }

    public void setOutgoingInterceptorList(String interceptorList) {
        this.serverLocator.setOutgoingInterceptorList(interceptorList);
    }

    public String getOutgoingInterceptorList() {
        return this.serverLocator.getOutgoingInterceptorList();
    }

    public ActiveMQConnectionFactory setUser(String user) {
        this.checkWrite();
        this.user = user;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public ActiveMQConnectionFactory setPassword(String password) {
        this.checkWrite();
        this.password = password;
        return this;
    }

    public String getPasswordCodec() {
        return this.serverLocator.getPasswordCodec();
    }

    public ActiveMQConnectionFactory setPasswordCodec(String passwordCodec) {
        this.checkWrite();
        this.serverLocator.setPasswordCodec(passwordCodec);
        return this;
    }

    public void setGroupID(String groupID) {
        this.serverLocator.setGroupID(groupID);
    }

    public String getGroupID() {
        return this.serverLocator.getGroupID();
    }

    public boolean isCompressLargeMessage() {
        return this.serverLocator.isCompressLargeMessage();
    }

    public void setCompressLargeMessage(boolean avoidLargeMessages) {
        this.serverLocator.setCompressLargeMessage(avoidLargeMessages);
    }

    public int getCompressionLevel() {
        return this.serverLocator.getCompressionLevel();
    }

    public void setCompressionLevel(int compressionLevel) {
        this.serverLocator.setCompressionLevel(compressionLevel);
    }

    @Override
    public void close() {
        ServerLocator locator0 = this.serverLocator;
        if (locator0 != null) {
            locator0.close();
        }
    }

    public ServerLocator getServerLocator() {
        return this.serverLocator;
    }

    public int getFactoryType() {
        return JMSFactoryType.CF.intValue();
    }

    protected synchronized ActiveMQConnection createConnectionInternal(String username, String password, boolean isXA, int type) throws JMSException {
        ClientSessionFactory factory;
        this.makeReadOnly();
        try {
            factory = this.serverLocator.createSessionFactory();
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Failed to create session factory");
            jmse.initCause((Throwable)e);
            jmse.setLinkedException(e);
            throw jmse;
        }
        ActiveMQConnection connection = null;
        if (isXA) {
            if (type == 0) {
                connection = new ActiveMQXAConnection(this, username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, this.cacheDestinations, this.enable1xPrefixes, factory);
            } else if (type == 1) {
                connection = new ActiveMQXAConnection(this, username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, this.cacheDestinations, this.enable1xPrefixes, factory);
            } else if (type == 2) {
                connection = new ActiveMQXAConnection(this, username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, this.cacheDestinations, this.enable1xPrefixes, factory);
            }
        } else if (type == 0) {
            connection = new ActiveMQConnection(this, username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, this.cacheDestinations, this.enable1xPrefixes, factory);
        } else if (type == 1) {
            connection = new ActiveMQConnection(this, username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, this.cacheDestinations, this.enable1xPrefixes, factory);
        } else if (type == 2) {
            connection = new ActiveMQConnection(this, username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, this.cacheDestinations, this.enable1xPrefixes, factory);
        }
        if (connection == null) {
            throw new JMSException("Failed to create connection: invalid type " + type);
        }
        connection.setReference(this);
        try {
            connection.authorize(!this.isEnableSharedClientID());
        }
        catch (JMSException e) {
            try {
                connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            throw e;
        }
        return connection;
    }

    public String toString() {
        return "ActiveMQConnectionFactory [serverLocator=" + this.serverLocator + ", clientID=" + this.clientID + ", consumerWindowSize=" + this.getConsumerWindowSize() + ", dupsOKBatchSize=" + this.dupsOKBatchSize + ", transactionBatchSize=" + this.transactionBatchSize + ", readOnly=" + this.readOnly + ", EnableSharedClientID=" + this.enableSharedClientID + "]";
    }

    private void checkWrite() {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set attribute on ActiveMQConnectionFactory after it has been used");
        }
    }

    protected void makeReadOnly() {
        this.readOnly = true;
    }
}

