/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.management.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.JMSRuntimeException;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.Parameter;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.api.jms.management.ConnectionFactoryControl;
import org.apache.activemq.artemis.api.jms.management.DestinationControl;
import org.apache.activemq.artemis.api.jms.management.JMSQueueControl;
import org.apache.activemq.artemis.api.jms.management.JMSServerControl;
import org.apache.activemq.artemis.api.jms.management.TopicControl;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.server.ActiveMQJMSServerLogger;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.apache.activemq.artemis.jms.server.management.JMSNotificationType;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.TypedProperties;

public class JMSServerControlImpl
extends AbstractControl
implements JMSServerControl,
NotificationEmitter,
org.apache.activemq.artemis.core.server.management.NotificationListener {
    private final JMSServerManager server;
    private final NotificationBroadcasterSupport broadcaster;
    private final AtomicLong notifSeq = new AtomicLong(0L);

    private static String[] convert(Object[] bindings) {
        String[] theBindings = new String[bindings.length];
        int bindingsLength = bindings.length;
        for (int i = 0; i < bindingsLength; ++i) {
            theBindings[i] = bindings[i].toString().trim();
        }
        return theBindings;
    }

    private static String[] toArray(String commaSeparatedString) {
        if (commaSeparatedString == null || commaSeparatedString.trim().length() == 0) {
            return new String[0];
        }
        String[] values = commaSeparatedString.split(",");
        String[] trimmed = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            trimmed[i] = values[i].trim();
            trimmed[i] = trimmed[i].replace("&comma;", ",");
        }
        return trimmed;
    }

    private static String[] determineJMSDestination(String coreAddress) {
        String[] result = new String[2];
        if (coreAddress.startsWith("jms.queue.")) {
            result[0] = coreAddress.substring("jms.queue.".length());
            result[1] = "queue";
        } else if (coreAddress.startsWith("jms.tempqueue.")) {
            result[0] = coreAddress.substring("jms.tempqueue.".length());
            result[1] = "tempqueue";
        } else if (coreAddress.startsWith("jms.topic.")) {
            result[0] = coreAddress.substring("jms.topic.".length());
            result[1] = "topic";
        } else if (coreAddress.startsWith("jms.temptopic.")) {
            result[0] = coreAddress.substring("jms.temptopic.".length());
            result[1] = "temptopic";
        } else {
            ActiveMQJMSServerLogger.LOGGER.debug("JMSServerControlImpl.determineJMSDestination()" + coreAddress);
            return null;
        }
        return result;
    }

    public static MBeanNotificationInfo[] getNotificationInfos() {
        JMSNotificationType[] values = JMSNotificationType.values();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].toString();
        }
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(names, JMSServerControl.class.getName(), "Notifications emitted by a JMS Server")};
    }

    public JMSServerControlImpl(JMSServerManager server) throws Exception {
        super(JMSServerControl.class, server.getActiveMQServer().getStorageManager());
        this.server = server;
        this.broadcaster = new NotificationBroadcasterSupport();
        server.getActiveMQServer().getManagementService().addNotificationListener((org.apache.activemq.artemis.core.server.management.NotificationListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConnectionFactory(String name, boolean ha, boolean useDiscovery, int cfType, String[] connectorNames, Object[] bindings) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            if (useDiscovery) {
                if (connectorNames == null || connectorNames.length == 0) {
                    throw new IllegalArgumentException("no discovery group name supplied");
                }
                this.server.createConnectionFactory(name, ha, JMSFactoryType.valueOf((int)cfType), connectorNames[0], JMSServerControlImpl.convert(bindings));
            } else {
                ArrayList<String> connectorList = new ArrayList<String>(connectorNames.length);
                for (String str : connectorNames) {
                    connectorList.add(str);
                }
                this.server.createConnectionFactory(name, ha, JMSFactoryType.valueOf((int)cfType), connectorList, JMSServerControlImpl.convert(bindings));
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public void createConnectionFactory(String name, boolean ha, boolean useDiscovery, int cfType, String connectors, String bindings, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, long callFailoverTimeout, int minLargeMessageSize, boolean compressLargeMessages, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, String groupId) throws Exception {
        this.createConnectionFactory(name, ha, useDiscovery, cfType, JMSServerControlImpl.toArray(connectors), JMSServerControlImpl.toArray(bindings), clientID, clientFailureCheckPeriod, connectionTTL, callTimeout, callFailoverTimeout, minLargeMessageSize, compressLargeMessages, consumerWindowSize, consumerMaxRate, confirmationWindowSize, producerWindowSize, producerMaxRate, blockOnAcknowledge, blockOnDurableSend, blockOnNonDurableSend, autoGroup, preAcknowledge, loadBalancingPolicyClassName, transactionBatchSize, dupsOKBatchSize, useGlobalPools, scheduledThreadPoolMaxSize, threadPoolMaxSize, retryInterval, retryIntervalMultiplier, maxRetryInterval, reconnectAttempts, failoverOnInitialConnection, groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConnectionFactory(String name, boolean ha, boolean useDiscovery, int cfType, String[] connectorNames, String[] bindings, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, long callFailoverTimeout, int minLargeMessageSize, boolean compressLargeMessages, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, String groupId) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            ConnectionFactoryConfiguration configuration = new ConnectionFactoryConfigurationImpl().setName(name).setHA(ha).setBindings(bindings).setFactoryType(JMSFactoryType.valueOf((int)cfType)).setClientID(clientID).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setCallTimeout(callTimeout).setCallFailoverTimeout(callFailoverTimeout).setMinLargeMessageSize(minLargeMessageSize).setCompressLargeMessages(compressLargeMessages).setConsumerWindowSize(consumerWindowSize).setConsumerMaxRate(consumerMaxRate).setConfirmationWindowSize(confirmationWindowSize).setProducerWindowSize(producerWindowSize).setProducerMaxRate(producerMaxRate).setBlockOnAcknowledge(blockOnAcknowledge).setBlockOnDurableSend(blockOnDurableSend).setBlockOnNonDurableSend(blockOnNonDurableSend).setAutoGroup(autoGroup).setPreAcknowledge(preAcknowledge).setTransactionBatchSize(transactionBatchSize).setDupsOKBatchSize(dupsOKBatchSize).setUseGlobalPools(useGlobalPools).setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize).setThreadPoolMaxSize(threadPoolMaxSize).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setMaxRetryInterval(maxRetryInterval).setReconnectAttempts(reconnectAttempts).setFailoverOnInitialConnection(failoverOnInitialConnection).setGroupID(groupId);
            if (useDiscovery) {
                configuration.setDiscoveryGroupName(connectorNames[0]);
            } else {
                ArrayList<String> connectorNamesList = new ArrayList<String>();
                for (String nameC : connectorNames) {
                    connectorNamesList.add(nameC);
                }
                configuration.setConnectorNames(connectorNamesList);
            }
            if (loadBalancingPolicyClassName != null && !loadBalancingPolicyClassName.trim().equals("")) {
                configuration.setLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            }
            this.server.createConnectionFactory(true, configuration, bindings);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void createConnectionFactory(String name, boolean ha, boolean useDiscovery, int cfType, String connectors, String bindings) throws Exception {
        this.createConnectionFactory(name, ha, useDiscovery, cfType, JMSServerControlImpl.toArray(connectors), JMSServerControlImpl.toArray(bindings));
    }

    public boolean createQueue(String name) throws Exception {
        return this.createQueue(name, null, null, true);
    }

    public boolean createQueue(String name, String bindings) throws Exception {
        return this.createQueue(name, bindings, null, true);
    }

    public boolean createQueue(String name, String bindings, String selector) throws Exception {
        return this.createQueue(name, bindings, selector, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createQueue(@Parameter(name="name", desc="Name of the queue to create") String name, @Parameter(name="bindings", desc="comma-separated list of Registry bindings (use '&comma;' if u need to use commas in your bindings name)") String bindings, @Parameter(name="selector", desc="the jms selector") String selector, @Parameter(name="durable", desc="is the queue persistent and resilient to restart") boolean durable) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.createQueue(true, name, selector, durable, JMSServerControlImpl.toArray(bindings));
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean destroyQueue(String name) throws Exception {
        return this.destroyQueue(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyQueue(String name, boolean removeConsumers) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.destroyQueue(name, removeConsumers);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean createTopic(String name) throws Exception {
        return this.createTopic(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createTopic(String topicName, String bindings) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.createTopic(true, topicName, JMSServerControlImpl.toArray(bindings));
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean destroyTopic(String name) throws Exception {
        return this.destroyTopic(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyTopic(String name, boolean removeConsumers) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.destroyTopic(name, removeConsumers);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void destroyConnectionFactory(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.server.destroyConnectionFactory(name);
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public String getVersion() {
        this.checkStarted();
        return this.server.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getQueueNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] queueControls = this.server.getActiveMQServer().getManagementService().getResources(JMSQueueControl.class);
            String[] names = new String[queueControls.length];
            for (int i = 0; i < queueControls.length; ++i) {
                JMSQueueControl queueControl = (JMSQueueControl)queueControls[i];
                names[i] = queueControl.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTopicNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] topicControls = this.server.getActiveMQServer().getManagementService().getResources(TopicControl.class);
            String[] names = new String[topicControls.length];
            for (int i = 0; i < topicControls.length; ++i) {
                TopicControl topicControl = (TopicControl)topicControls[i];
                names[i] = topicControl.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConnectionFactoryNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] cfControls = this.server.getActiveMQServer().getManagementService().getResources(ConnectionFactoryControl.class);
            String[] names = new String[cfControls.length];
            for (int i = 0; i < cfControls.length; ++i) {
                ConnectionFactoryControl cfControl = (ConnectionFactoryControl)cfControls[i];
                names[i] = cfControl.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getNodeID() {
        return this.server.getActiveMQServer().getNodeID().toString();
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return JMSServerControlImpl.getNotificationInfos();
    }

    public String[] listRemoteAddresses() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listRemoteAddresses();
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] listRemoteAddresses(String ipAddress) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listRemoteAddresses(ipAddress);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean closeConnectionsForAddress(String ipAddress) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.closeConnectionsForAddress(ipAddress);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean closeConsumerConnectionsForAddress(String address) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.closeConsumerConnectionsForAddress(address);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean closeConnectionsForUser(String userName) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.closeConnectionsForUser(userName);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] listConnectionIDs() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listConnectionIDs();
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listConnectionsAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            JsonArrayBuilder array = JsonLoader.createArrayBuilder();
            Set connections = this.server.getActiveMQServer().getRemotingService().getConnections();
            Set sessions = this.server.getActiveMQServer().getSessions();
            HashMap<Object, ServerSession> jmsSessions = new HashMap<Object, ServerSession>();
            for (ServerSession session : sessions) {
                if (session.getMetaData("jms-session") == null) continue;
                jmsSessions.put(session.getConnectionID(), session);
            }
            for (RemotingConnection connection : connections) {
                ServerSession session = (ServerSession)jmsSessions.get(connection.getID());
                if (session == null) continue;
                JsonObjectBuilder objectBuilder = JsonLoader.createObjectBuilder().add("connectionID", connection.getID().toString()).add("clientAddress", connection.getRemoteAddress()).add("creationTime", connection.getCreationTime());
                if (session.getMetaData("jms-client-id") != null) {
                    objectBuilder.add("clientID", session.getMetaData("jms-client-id"));
                }
                if (session.getUsername() != null) {
                    objectBuilder.add("principal", session.getUsername());
                }
                array.add((JsonValue)objectBuilder.build());
            }
            String string = array.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listConsumersAsJSON(String connectionID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            JsonArrayBuilder array = JsonLoader.createArrayBuilder();
            Set connections = this.server.getActiveMQServer().getRemotingService().getConnections();
            for (RemotingConnection connection : connections) {
                if (!connectionID.equals(connection.getID().toString())) continue;
                List sessions = this.server.getActiveMQServer().getSessions(connectionID);
                for (ServerSession session : sessions) {
                    Set consumers = session.getServerConsumers();
                    for (ServerConsumer consumer : consumers) {
                        JsonObject obj = this.toJSONObject(consumer);
                        if (obj == null) continue;
                        array.add((JsonValue)obj);
                    }
                }
            }
            String string = array.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listAllConsumersAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            JsonArray jsonArray = this.toJsonArray(this.server.getActiveMQServer().getSessions());
            String string = jsonArray.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] listSessions(String connectionID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listSessions(connectionID);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listPreparedTransactionDetailsAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.server.listPreparedTransactionDetailsAsJSON();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listPreparedTransactionDetailsAsHTML() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.server.listPreparedTransactionDetailsAsHTML();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(JMSServerControl.class);
    }

    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(JMSServerControl.class);
    }

    private void checkStarted() {
        if (!this.server.isStarted()) {
            throw new IllegalStateException("ActiveMQ Artemis JMS Server is not started. It can not be managed yet");
        }
    }

    public String[] listTargetDestinations(String sessionID) throws Exception {
        Object[] topicControls;
        Object[] queueControls;
        String[] addresses = this.server.getActiveMQServer().getActiveMQServerControl().listTargetAddresses(sessionID);
        HashMap<String, Object> allDests = new HashMap<String, Object>();
        for (Object queueControl2 : queueControls = this.server.getActiveMQServer().getManagementService().getResources(JMSQueueControl.class)) {
            JMSQueueControl queueControl = (JMSQueueControl)queueControl2;
            allDests.put(queueControl.getAddress(), queueControl);
        }
        for (Object topicControl2 : topicControls = this.server.getActiveMQServer().getManagementService().getResources(TopicControl.class)) {
            TopicControl topicControl = (TopicControl)topicControl2;
            allDests.put(topicControl.getAddress(), topicControl);
        }
        ArrayList<String> destinations = new ArrayList<String>();
        for (String addresse : addresses) {
            DestinationControl control = (DestinationControl)allDests.get(addresse);
            if (control == null) continue;
            destinations.add(control.getAddress());
        }
        return destinations.toArray(new String[destinations.size()]);
    }

    public String getLastSentMessageID(String sessionID, String address) throws Exception {
        ServerSession session = this.server.getActiveMQServer().getSessionByID(sessionID);
        if (session != null) {
            return session.getLastSentMessageID(address);
        }
        return null;
    }

    public String getSessionCreationTime(String sessionID) throws Exception {
        ServerSession session = this.server.getActiveMQServer().getSessionByID(sessionID);
        if (session != null) {
            return String.valueOf(session.getCreationTime());
        }
        return null;
    }

    public String listSessionsAsJSON(String connectionID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.server.listSessionsAsJSON(connectionID);
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listNetworkTopology() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            JsonArrayBuilder brokers = JsonLoader.createArrayBuilder();
            ClusterManager clusterManager = this.server.getActiveMQServer().getClusterManager();
            if (clusterManager != null) {
                Set clusterConnections = clusterManager.getClusterConnections();
                for (ClusterConnection clusterConnection : clusterConnections) {
                    Topology topology = clusterConnection.getTopology();
                    Collection members = topology.getMembers();
                    for (TopologyMemberImpl member : members) {
                        JsonObjectBuilder obj = JsonLoader.createObjectBuilder();
                        TransportConfiguration live = member.getLive();
                        if (live != null) {
                            obj.add("nodeID", member.getNodeId()).add("live", live.getParams().get("host") + ":" + live.getParams().get("port"));
                            TransportConfiguration backup = member.getBackup();
                            if (backup != null) {
                                obj.add("backup", backup.getParams().get("host") + ":" + backup.getParams().get("port"));
                            }
                        }
                        brokers.add(obj);
                    }
                }
            }
            String string = brokers.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String closeConnectionWithClientID(String clientID) throws Exception {
        return this.server.getActiveMQServer().destroyConnectionWithSessionMetadata("jms-client-id", clientID);
    }

    private JsonObject toJSONObject(ServerConsumer consumer) {
        String[] destinationInfo = JMSServerControlImpl.determineJMSDestination(consumer.getQueue().getAddress().toString());
        if (destinationInfo == null) {
            return null;
        }
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add("consumerID", consumer.getID()).add("connectionID", consumer.getConnectionID().toString()).add("sessionID", consumer.getSessionID()).add("queueName", consumer.getQueue().getName().toString()).add("browseOnly", consumer.isBrowseOnly()).add("creationTime", consumer.getCreationTime()).add("destinationName", destinationInfo[0]).add("destinationType", destinationInfo[1]);
        Filter queueFilter = consumer.getQueue().getFilter();
        if (queueFilter != null) {
            obj.add("filter", queueFilter.getFilterString().toString());
        }
        if (destinationInfo[1].equals("topic")) {
            try {
                ActiveMQDestination.decomposeQueueNameForDurableSubscription((String)consumer.getQueue().getName().toString());
                obj.add("durable", true);
            }
            catch (IllegalArgumentException | JMSRuntimeException e) {
                obj.add("durable", false);
            }
        } else {
            obj.add("durable", false);
        }
        return obj.build();
    }

    public void onNotification(Notification notification) {
        if (!(notification.getType() instanceof JMSNotificationType)) {
            return;
        }
        JMSNotificationType type = (JMSNotificationType)notification.getType();
        TypedProperties prop = notification.getProperties();
        this.broadcaster.sendNotification(new javax.management.Notification(type.toString(), (Object)this, this.notifSeq.incrementAndGet(), prop.getSimpleStringProperty(JMSNotificationType.MESSAGE).toString()));
    }

    private JsonArray toJsonArray(Collection<ServerSession> sessions) {
        JsonArrayBuilder array = JsonLoader.createArrayBuilder();
        for (ServerSession session : sessions) {
            Set consumers = session.getServerConsumers();
            for (ServerConsumer consumer : consumers) {
                JsonObject obj = this.toJSONObject(consumer);
                if (obj == null) continue;
                array.add((JsonValue)obj);
            }
        }
        return array.build();
    }
}

