package org.apache.activemq.artemis.jms.server;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Runnable;
import org.w3c.dom.Node;
import java.lang.Object;
import java.lang.String;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.jboss.logging.Logger;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-08-24T20:36:58+0200")
public class ActiveMQJMSServerLogger_$logger extends DelegatingBasicLogger implements ActiveMQJMSServerLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQJMSServerLogger_$logger.class.getName();
    public ActiveMQJMSServerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void serverCachingCommand(final Object runnable) {
        super.log.logv(FQCN, INFO, null, serverCachingCommand$str(), runnable);
    }
    protected String serverCachingCommand$str() {
        return "AMQ121004: JMS Server Manager Caching command for {0} since the JMS Server is not active.";
    }
    @Override
    public final void invalidHostForConnector(final String name, final String newHost) {
        super.log.logv(FQCN, WARN, null, invalidHostForConnector$str(), name, newHost);
    }
    protected String invalidHostForConnector$str() {
        return "AMQ122005: Invalid \"host\" value \"0.0.0.0\" detected for \"{0}\" connector. Switching to \"{1}\". If this new address is incorrect please manually configure the connector to use the proper one.";
    }
    @Override
    public final void noQueueOnTopic(final String queueName, final String name) {
        super.log.logv(FQCN, WARN, null, noQueueOnTopic$str(), queueName, name);
    }
    protected String noQueueOnTopic$str() {
        return "AMQ122007: Queue {0} does not exist on the topic {1}. It was deleted manually probably.";
    }
    @Override
    public final void recoveryConnectFailed(final String s) {
        super.log.logv(FQCN, WARN, null, recoveryConnectFailed$str(), s);
    }
    protected String recoveryConnectFailed$str() {
        return "AMQ122008: XA Recovery can not connect to any broker on recovery {0}";
    }
    @Override
    public final void bindingsUnbindError(final Exception e, final String key) {
        super.log.logv(FQCN, WARN, e, bindingsUnbindError$str(), key);
    }
    protected String bindingsUnbindError$str() {
        return "AMQ122011: error unbinding {0} from Registry";
    }
    @Override
    public final void jmsServerError(final Exception e) {
        super.log.logv(FQCN, WARN, e, jmsServerError$str());
    }
    protected String jmsServerError$str() {
        return "AMQ122012: JMS Server Manager error";
    }
    @Override
    public final void xaRecoverError(final Exception e) {
        super.log.logv(FQCN, WARN, e, xaRecoverError$str());
    }
    protected String xaRecoverError$str() {
        return "AMQ122013: Error in XA Recovery recover";
    }
    @Override
    public final void xaRecoverConnectionError(final Exception e, final ClientSessionFactory csf) {
        super.log.logv(FQCN, WARN, e, xaRecoverConnectionError$str(), csf);
    }
    protected String xaRecoverConnectionError$str() {
        return "AMQ122014: Notified of connection failure in xa recovery connectionFactory for provider {0} will attempt reconnect on next pass";
    }
    @Override
    public final void xaRecoveryError(final Exception e) {
        super.log.logv(FQCN, DEBUG, e, xaRecoveryError$str());
    }
    protected String xaRecoveryError$str() {
        return "AMQ122016: Error in XA Recovery";
    }
    @Override
    public final void failedToCorrectHost(final Exception e, final String name) {
        super.log.logv(FQCN, WARN, e, failedToCorrectHost$str(), name);
    }
    protected String failedToCorrectHost$str() {
        return "AMQ122017: Tried to correct invalid \"host\" value \"0.0.0.0\" for \"{0}\" connector, but received an exception.";
    }
    @Override
    public final void failedToSendNotification(final String notification) {
        super.log.logv(FQCN, WARN, null, failedToSendNotification$str(), notification);
    }
    protected String failedToSendNotification$str() {
        return "AMQ122018: Failed to send notification: {0}";
    }
    @Override
    public final void failedToDeactivateServer(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToDeactivateServer$str());
    }
    protected String failedToDeactivateServer$str() {
        return "AMQ122019: Unable to deactivate server";
    }
    @Override
    public final void serverRunningCachedCommand(final Runnable run) {
        super.log.logv(FQCN, DEBUG, null, serverRunningCachedCommand$str(), run);
    }
    protected String serverRunningCachedCommand$str() {
        return "AMQ123000: JMS Server Manager Running cached command for {0}.(In the event of failover after failback has occurred, this message may be output multiple times.)";
    }
    @Override
    public final void jmsConfigMissingKey(final Node e) {
        super.log.logv(FQCN, ERROR, null, jmsConfigMissingKey$str(), e);
    }
    protected String jmsConfigMissingKey$str() {
        return "AMQ124000: key attribute missing for JMS configuration {0}";
    }
    @Override
    public final void jmsDeployerStartError(final Exception e) {
        super.log.logv(FQCN, ERROR, e, jmsDeployerStartError$str());
    }
    protected String jmsDeployerStartError$str() {
        return "AMQ124002: Failed to start JMS deployer";
    }
}
