package org.apache.activemq.artemis.jms.server;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.apache.activemq.artemis.api.core.ActiveMQAddressExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import java.lang.String;
import java.util.Arrays;
import java.lang.Exception;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2022-06-07T12:51:03-0400")
public class ActiveMQJMSServerBundle_$bundle implements ActiveMQJMSServerBundle, Serializable {
    private static final long serialVersionUID = 1L;
    protected ActiveMQJMSServerBundle_$bundle() {}
    public static final ActiveMQJMSServerBundle_$bundle INSTANCE = new ActiveMQJMSServerBundle_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String cfDoesntExist$str() {
        return "AMQ129000: Connection Factory {0} does not exist";
    }
    @Override
    public final ActiveMQInternalErrorException cfDoesntExist(final String name) {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(_formatMessage(cfDoesntExist$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String discoveryGroupDoesntExist$str() {
        return "AMQ129003: Discovery Group ''{0}'' does not exist on main config";
    }
    @Override
    public final ActiveMQIllegalStateException discoveryGroupDoesntExist(final String name) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(discoveryGroupDoesntExist$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConnectorNameOnCF$str() {
        return "AMQ129004: No Connector name configured on create ConnectionFactory";
    }
    @Override
    public final ActiveMQIllegalStateException noConnectorNameOnCF() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), noConnectorNameOnCF$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConnectorNameConfiguredOnCF$str() {
        return "AMQ129005: Connector ''{0}'' not found on the main configuration file";
    }
    @Override
    public final ActiveMQIllegalStateException noConnectorNameConfiguredOnCF(final String name) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(noConnectorNameConfiguredOnCF$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cfBindingsExists$str() {
        return "AMQ129006: Binding {0} is already being used by another connection factory";
    }
    @Override
    public final ActiveMQAddressExistsException cfBindingsExists(final String name) {
        final ActiveMQAddressExistsException result = new ActiveMQAddressExistsException(_formatMessage(cfBindingsExists$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorDecodingPassword$str() {
        return "AMQ129007: Error decoding password using codec instance";
    }
    @Override
    public final ActiveMQIllegalStateException errorDecodingPassword(final Exception e) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), errorDecodingPassword$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
