/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import org.apache.activemq.artemis.core.io.mapped.BytesUtils;

final class MappedByteBufferCache
implements AutoCloseable {
    public static final int PAGE_SIZE = Integer.parseInt(System.getProperty("os_page_size", "4096"));
    private static final Object FILE_LOCK = new Object();
    private final RandomAccessFile raf;
    private final FileChannel fileChannel;
    private final long chunkBytes;
    private final long overlapBytes;
    private final ArrayList<WeakReference<MappedByteBuffer>> byteBuffers = new ArrayList();
    private final File file;
    private final long mappedSize;
    private boolean closed;

    private MappedByteBufferCache(File file, RandomAccessFile raf, long chunkBytes, long overlapBytes, long alignment) {
        this.file = file;
        this.raf = raf;
        this.fileChannel = raf.getChannel();
        this.chunkBytes = BytesUtils.align(chunkBytes, alignment);
        this.overlapBytes = BytesUtils.align(overlapBytes, alignment);
        this.closed = false;
        this.mappedSize = this.chunkBytes + this.overlapBytes;
    }

    public static MappedByteBufferCache of(File file, long chunkSize, long overlapSize) throws FileNotFoundException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        return new MappedByteBufferCache(file, raf, chunkSize, overlapSize, PAGE_SIZE);
    }

    public static boolean inside(long position, long mappedPosition, long mappedLimit) {
        return mappedPosition <= position && position < mappedLimit;
    }

    public File file() {
        return this.file;
    }

    public long chunkBytes() {
        return this.chunkBytes;
    }

    public long overlapBytes() {
        return this.overlapBytes;
    }

    public int indexFor(long position) {
        int chunk = (int)(position / this.chunkBytes);
        return chunk;
    }

    public long mappedPositionFor(int index) {
        return (long)index * this.chunkBytes;
    }

    public long mappedLimitFor(long mappedPosition) {
        return mappedPosition + this.chunkBytes;
    }

    public MappedByteBuffer acquireMappedByteBuffer(int index) throws IOException, IllegalArgumentException, IllegalStateException {
        MappedByteBuffer mbb;
        if (this.closed) {
            throw new IOException("Closed");
        }
        if (index < 0) {
            throw new IOException("Attempt to access a negative index: " + index);
        }
        while (this.byteBuffers.size() <= index) {
            this.byteBuffers.add(null);
        }
        WeakReference<MappedByteBuffer> mbbRef = this.byteBuffers.get(index);
        if (mbbRef != null && (mbb = (MappedByteBuffer)mbbRef.get()) != null) {
            return mbb;
        }
        return this.mapAndAcquire(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MappedByteBuffer mapAndAcquire(int index) throws IOException {
        long chunkStartPosition = this.mappedPositionFor(index);
        long minSize = chunkStartPosition + this.mappedSize;
        if (this.fileChannel.size() < minSize) {
            try {
                Object object = FILE_LOCK;
                synchronized (object) {
                    try (FileLock lock = this.fileChannel.lock();){
                        long size = this.fileChannel.size();
                        if (size < minSize) {
                            this.raf.setLength(minSize);
                        }
                    }
                }
            }
            catch (IOException ioe) {
                throw new IOException("Failed to resize to " + minSize, ioe);
            }
        }
        MappedByteBuffer mbb = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, chunkStartPosition, this.mappedSize);
        mbb.order(ByteOrder.nativeOrder());
        this.byteBuffers.set(index, new WeakReference<MappedByteBuffer>(mbb));
        return mbb;
    }

    public long fileSize() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        return this.fileChannel.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeAndResize(long length) {
        if (this.closed) return;
        for (WeakReference<MappedByteBuffer> mbbRef : this.byteBuffers) {
            MappedByteBuffer mbb;
            if (mbbRef == null || (mbb = (MappedByteBuffer)mbbRef.get()) == null) continue;
            try {
                PlatformDependent.freeDirectBuffer((ByteBuffer)mbb);
            }
            catch (Throwable t) {}
        }
        this.byteBuffers.clear();
        try {
            if (this.fileChannel.size() == length) return;
            try {
                Object object = FILE_LOCK;
                synchronized (object) {
                    try (FileLock lock = this.fileChannel.lock();){
                        long size = this.fileChannel.size();
                        if (size == length) return;
                        this.raf.setLength(length);
                    }
                    return;
                }
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Failed to resize to " + length, ioe);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to get size", ex);
        }
        finally {
            try {
                this.fileChannel.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to close channel", e);
            }
            finally {
                try {
                    this.raf.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to close RandomAccessFile", e);
                }
            }
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (WeakReference<MappedByteBuffer> mbbRef : this.byteBuffers) {
                MappedByteBuffer mbb;
                if (mbbRef == null || (mbb = (MappedByteBuffer)mbbRef.get()) == null) continue;
                try {
                    PlatformDependent.freeDirectBuffer((ByteBuffer)mbb);
                }
                catch (Throwable t) {}
            }
            this.byteBuffers.clear();
            try {
                this.fileChannel.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to close channel", e);
            }
            finally {
                try {
                    this.raf.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to close RandomAccessFile", e);
                }
            }
            this.closed = true;
        }
    }
}

