/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.nio;

import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.core.io.AbstractSequentialFileFactory;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFile;

public class NIOSequentialFileFactory
extends AbstractSequentialFileFactory {
    public NIOSequentialFileFactory(File journalDir, int maxIO) {
        this(journalDir, null, maxIO);
    }

    public NIOSequentialFileFactory(File journalDir, IOCriticalErrorListener listener, int maxIO) {
        this(journalDir, false, 501760, 3333333, maxIO, false, listener);
    }

    public NIOSequentialFileFactory(File journalDir, boolean buffered, int maxIO) {
        this(journalDir, buffered, null, maxIO);
    }

    public NIOSequentialFileFactory(File journalDir, boolean buffered, IOCriticalErrorListener listener, int maxIO) {
        this(journalDir, buffered, 501760, 3333333, maxIO, false, listener);
    }

    public NIOSequentialFileFactory(File journalDir, boolean buffered, int bufferSize, int bufferTimeout, int maxIO, boolean logRates) {
        this(journalDir, buffered, bufferSize, bufferTimeout, maxIO, logRates, null);
    }

    public NIOSequentialFileFactory(File journalDir, boolean buffered, int bufferSize, int bufferTimeout, int maxIO, boolean logRates, IOCriticalErrorListener listener) {
        super(journalDir, buffered, bufferSize, bufferTimeout, maxIO, logRates, listener);
    }

    public static ByteBuffer allocateDirectByteBuffer(int size) {
        ByteBuffer buffer2 = null;
        try {
            buffer2 = ByteBuffer.allocateDirect(size);
        }
        catch (OutOfMemoryError error) {
            WeakReference<Object> obj = new WeakReference<Object>(new Object());
            try {
                long timeout = System.currentTimeMillis() + 5000L;
                while (System.currentTimeMillis() > timeout && obj.get() != null) {
                    System.gc();
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            buffer2 = ByteBuffer.allocateDirect(size);
        }
        return buffer2;
    }

    @Override
    public SequentialFile createSequentialFile(String fileName) {
        return new NIOSequentialFile(this, this.journalDir, fileName, this.maxIO, this.writeExecutor);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return this.timedBuffer != null;
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        return NIOSequentialFileFactory.allocateDirectByteBuffer(size);
    }

    @Override
    public void releaseDirectBuffer(ByteBuffer buffer) {
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    @Override
    public void clearBuffer(ByteBuffer buffer) {
        int limit = buffer.limit();
        buffer.rewind();
        for (int i = 0; i < limit; ++i) {
            buffer.put((byte)0);
        }
        buffer.rewind();
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    public int calculateBlockSize(int bytes) {
        return bytes;
    }
}

