/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.nio;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.core.io.AbstractSequentialFile;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.journal.ActiveMQJournalBundle;

public final class NIOSequentialFile
extends AbstractSequentialFile {
    private FileChannel channel;
    private RandomAccessFile rfile;
    private final int defaultMaxIO;
    private int maxIO;

    public NIOSequentialFile(SequentialFileFactory factory, File directory, String file, int maxIO, Executor writerExecutor) {
        super(directory, file, factory, writerExecutor);
        this.defaultMaxIO = maxIO;
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    public int calculateBlockStart(int position) {
        return position;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.channel != null;
    }

    @Override
    public synchronized void open() throws IOException {
        this.open(this.defaultMaxIO, true);
    }

    @Override
    public void open(int maxIO, boolean useExecutor) throws IOException {
        try {
            this.rfile = new RandomAccessFile(this.getFile(), "rw");
            this.channel = this.rfile.getChannel();
            this.fileSize = this.channel.size();
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    @Override
    public void fill(int size) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(size);
        bb.limit(size);
        bb.position(0);
        try {
            this.channel.position(0L);
            this.channel.write(bb);
            this.channel.force(false);
            this.channel.position(0L);
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
        this.channel.force(true);
        this.fileSize = this.channel.size();
    }

    public synchronized void waitForClose() throws InterruptedException {
        while (this.isOpen()) {
            this.wait();
        }
    }

    @Override
    public synchronized void close() throws IOException, InterruptedException, ActiveMQException {
        super.close();
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.rfile != null) {
                this.rfile.close();
            }
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
        this.channel = null;
        this.rfile = null;
        this.notifyAll();
    }

    @Override
    public int read(ByteBuffer bytes) throws Exception {
        return this.read(bytes, null);
    }

    @Override
    public synchronized int read(ByteBuffer bytes, IOCallback callback) throws IOException, ActiveMQIllegalStateException {
        try {
            if (this.channel == null) {
                throw new ActiveMQIllegalStateException("File " + this.getFileName() + " has a null channel");
            }
            int bytesRead = this.channel.read(bytes);
            if (callback != null) {
                callback.done();
            }
            bytes.flip();
            return bytesRead;
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            if (callback != null) {
                callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getLocalizedMessage());
            }
            this.factory.onIOError((Exception)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    @Override
    public void sync() throws IOException {
        if (this.factory.isDatasync() && this.channel != null) {
            try {
                this.channel.force(false);
            }
            catch (ClosedChannelException e) {
                throw e;
            }
            catch (IOException e) {
                this.factory.onIOError((Exception)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
                throw e;
            }
        }
    }

    @Override
    public long size() throws IOException {
        if (this.channel == null) {
            return this.getFile().length();
        }
        try {
            return this.channel.size();
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    @Override
    public void position(long pos) throws IOException {
        try {
            super.position(pos);
            this.channel.position(pos);
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    public String toString() {
        return "NIOSequentialFile " + this.getFile();
    }

    @Override
    public SequentialFile cloneFile() {
        return new NIOSequentialFile(this.factory, this.directory, this.getFileName(), this.maxIO, null);
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync, IOCallback callback) {
        if (callback == null) {
            throw new NullPointerException("callback parameter need to be set");
        }
        try {
            this.internalWrite(bytes, sync, callback);
        }
        catch (Exception e) {
            callback.onError(ActiveMQExceptionType.GENERIC_EXCEPTION.getCode(), e.getMessage());
        }
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
        this.internalWrite(bytes, sync, null);
    }

    public void writeInternal(ByteBuffer bytes) throws Exception {
        this.internalWrite(bytes, true, null);
    }

    @Override
    protected ByteBuffer newBuffer(int size, int limit) {
        size = limit;
        return super.newBuffer(size, limit);
    }

    private void internalWrite(ByteBuffer bytes, boolean sync, IOCallback callback) throws IOException, ActiveMQIOErrorException, InterruptedException {
        if (!this.isOpen()) {
            if (callback == null) {
                throw ActiveMQJournalBundle.BUNDLE.fileNotOpened();
            }
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), "File not opened");
            return;
        }
        this.position.addAndGet(bytes.limit());
        try {
            this.doInternalWrite(bytes, sync, callback);
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
        }
    }

    private void doInternalWrite(ByteBuffer bytes, boolean sync, IOCallback callback) throws IOException {
        this.channel.write(bytes);
        if (sync) {
            this.sync();
        }
        if (callback != null) {
            callback.done();
        }
    }
}

