/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;

public class JournalFileImpl
implements JournalFile {
    private final SequentialFile file;
    private final long fileID;
    private final int recordID;
    private long offset;
    private final AtomicInteger posCount = new AtomicInteger(0);
    private final AtomicInteger liveBytes = new AtomicInteger(0);
    private boolean posReclaimCriteria = false;
    private boolean negReclaimCriteria = false;
    private final AtomicInteger totalNegativeToOthers = new AtomicInteger(0);
    private final int version;
    private final ConcurrentMap<JournalFile, AtomicInteger> negCounts = new ConcurrentHashMap<JournalFile, AtomicInteger>();

    public JournalFileImpl(SequentialFile file, long fileID, int version) {
        this.file = file;
        this.fileID = fileID;
        this.version = version;
        this.recordID = (int)(fileID & Integer.MAX_VALUE);
    }

    @Override
    public int getPosCount() {
        return this.posCount.intValue();
    }

    @Override
    public boolean isPosReclaimCriteria() {
        return this.posReclaimCriteria;
    }

    @Override
    public void setPosReclaimCriteria() {
        this.posReclaimCriteria = true;
    }

    @Override
    public boolean isNegReclaimCriteria() {
        return this.negReclaimCriteria;
    }

    @Override
    public void setNegReclaimCriteria() {
        this.negReclaimCriteria = true;
    }

    @Override
    public boolean isCanReclaim() {
        return this.posReclaimCriteria && this.negReclaimCriteria;
    }

    @Override
    public void incNegCount(JournalFile file) {
        AtomicInteger previous;
        if (file != this) {
            this.totalNegativeToOthers.incrementAndGet();
        }
        if ((previous = this.negCounts.putIfAbsent(file, new AtomicInteger(1))) != null) {
            previous.incrementAndGet();
        }
    }

    @Override
    public int getNegCount(JournalFile file) {
        AtomicInteger count = (AtomicInteger)this.negCounts.get(file);
        if (count == null) {
            return 0;
        }
        return count.intValue();
    }

    @Override
    public int getJournalVersion() {
        return this.version;
    }

    @Override
    public void incPosCount() {
        this.posCount.incrementAndGet();
    }

    @Override
    public void decPosCount() {
        this.posCount.decrementAndGet();
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getFileID() {
        return this.fileID;
    }

    @Override
    public int getRecordID() {
        return this.recordID;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public SequentialFile getFile() {
        return this.file;
    }

    public String toString() {
        try {
            return "JournalFileImpl: (" + this.file.getFileName() + " id = " + this.fileID + ", recordID = " + this.recordID + ")";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error:" + e.toString();
        }
    }

    public String debug() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.negCounts.entrySet()) {
            builder.append(" file = " + entry.getKey() + " negcount value = " + entry.getValue() + "\n");
        }
        return builder.toString();
    }

    @Override
    public void addSize(int bytes) {
        this.liveBytes.addAndGet(bytes);
    }

    @Override
    public void decSize(int bytes) {
        this.liveBytes.addAndGet(-bytes);
    }

    @Override
    public int getLiveSize() {
        return this.liveBytes.get();
    }

    @Override
    public int getTotalNegativeToOthers() {
        return this.totalNegativeToOthers.get();
    }
}

