/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.core.io.mapped.MappedFile;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.journal.ActiveMQJournalBundle;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;

final class MappedSequentialFile
implements SequentialFile {
    private final File directory;
    private final long chunkBytes;
    private final long overlapBytes;
    private final IOCriticalErrorListener criticalErrorListener;
    private File file;
    private File absoluteFile;
    private String fileName;
    private MappedFile mappedFile;
    private ActiveMQBuffer pooledActiveMQBuffer;
    private final MappedSequentialFileFactory factory;

    MappedSequentialFile(MappedSequentialFileFactory factory, File directory, File file, long chunkBytes, long overlapBytes, IOCriticalErrorListener criticalErrorListener) {
        this.factory = factory;
        this.directory = directory;
        this.file = file;
        this.absoluteFile = null;
        this.fileName = null;
        this.chunkBytes = chunkBytes;
        this.overlapBytes = overlapBytes;
        this.mappedFile = null;
        this.pooledActiveMQBuffer = null;
        this.criticalErrorListener = criticalErrorListener;
    }

    private void checkIsOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("must be open!");
        }
    }

    private void checkIsNotOpen() {
        if (this.isOpen()) {
            throw new IllegalStateException("must be closed!");
        }
    }

    @Override
    public boolean isOpen() {
        return this.mappedFile != null;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public void open() throws IOException {
        if (this.mappedFile == null) {
            this.mappedFile = MappedFile.of(this.file, this.chunkBytes, this.overlapBytes);
        }
    }

    @Override
    public void open(int maxIO, boolean useExecutor) throws IOException {
        ActiveMQJournalLogger.LOGGER.warn("ignoring maxIO and useExecutor unsupported parameters!");
        this.open();
    }

    @Override
    public boolean fits(int size) {
        this.checkIsOpen();
        long newPosition = this.mappedFile.position() + (long)size;
        boolean hasRemaining = newPosition <= this.mappedFile.length();
        return hasRemaining;
    }

    @Override
    public int getAlignment() {
        return 0;
    }

    @Override
    public int calculateBlockStart(int position) {
        return position;
    }

    @Override
    public String getFileName() {
        if (this.fileName == null) {
            this.fileName = this.file.getName();
        }
        return this.fileName;
    }

    @Override
    public void fill(int size) throws IOException {
        this.checkIsOpen();
        this.mappedFile.zeros(this.mappedFile.position(), size);
    }

    @Override
    public void delete() {
        this.checkIsNotOpen();
        if (this.file.exists() && !this.file.delete()) {
            ActiveMQJournalLogger.LOGGER.errorDeletingFile(this);
        }
    }

    @Override
    public void write(ActiveMQBuffer bytes, boolean sync, IOCallback callback) throws IOException {
        this.checkIsOpen();
        if (callback == null) {
            throw new NullPointerException("callback parameter need to be set");
        }
        try {
            ByteBuf byteBuf = bytes.byteBuf();
            int writerIndex = byteBuf.writerIndex();
            int readerIndex = byteBuf.readerIndex();
            int readableBytes = writerIndex - readerIndex;
            if (readableBytes > 0) {
                this.mappedFile.write(byteBuf, readerIndex, readableBytes);
                if (this.factory.isDatasync() && sync) {
                    this.mappedFile.force();
                }
            }
            callback.done();
        }
        catch (IOException e) {
            if (this.criticalErrorListener != null) {
                this.criticalErrorListener.onIOException((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            }
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
            throw e;
        }
    }

    @Override
    public void write(ActiveMQBuffer bytes, boolean sync) throws IOException {
        this.checkIsOpen();
        ByteBuf byteBuf = bytes.byteBuf();
        int writerIndex = byteBuf.writerIndex();
        int readerIndex = byteBuf.readerIndex();
        int readableBytes = writerIndex - readerIndex;
        if (readableBytes > 0) {
            this.mappedFile.write(byteBuf, readerIndex, readableBytes);
            if (this.factory.isDatasync() && sync) {
                this.mappedFile.force();
            }
        }
    }

    private ActiveMQBuffer acquiresActiveMQBufferWithAtLeast(int size) {
        if (this.pooledActiveMQBuffer == null || this.pooledActiveMQBuffer.capacity() < size) {
            this.pooledActiveMQBuffer = new ChannelBufferWrapper(Unpooled.directBuffer((int)size, (int)size).order(ByteOrder.nativeOrder()));
        } else {
            this.pooledActiveMQBuffer.clear();
        }
        return this.pooledActiveMQBuffer;
    }

    @Override
    public void write(EncodingSupport bytes, boolean sync, IOCallback callback) throws IOException {
        this.checkIsOpen();
        if (callback == null) {
            throw new NullPointerException("callback parameter need to be set");
        }
        try {
            int encodedSize = bytes.getEncodeSize();
            ActiveMQBuffer outBuffer = this.acquiresActiveMQBufferWithAtLeast(encodedSize);
            bytes.encode(outBuffer);
            ByteBuf byteBuf = outBuffer.byteBuf();
            int writerIndex = byteBuf.writerIndex();
            int readerIndex = byteBuf.readerIndex();
            int readableBytes = writerIndex - readerIndex;
            if (readableBytes > 0) {
                this.mappedFile.write(byteBuf, readerIndex, readableBytes);
                if (this.factory.isDatasync() && sync) {
                    this.mappedFile.force();
                }
            }
            callback.done();
        }
        catch (IOException e) {
            if (this.criticalErrorListener != null) {
                this.criticalErrorListener.onIOException((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            }
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
            throw e;
        }
    }

    @Override
    public void write(EncodingSupport bytes, boolean sync) throws IOException {
        this.checkIsOpen();
        int encodedSize = bytes.getEncodeSize();
        ActiveMQBuffer outBuffer = this.acquiresActiveMQBufferWithAtLeast(encodedSize);
        bytes.encode(outBuffer);
        ByteBuf byteBuf = outBuffer.byteBuf();
        int writerIndex = byteBuf.writerIndex();
        int readerIndex = byteBuf.readerIndex();
        int readableBytes = writerIndex - readerIndex;
        if (readableBytes > 0) {
            this.mappedFile.write(byteBuf, readerIndex, readableBytes);
            if (this.factory.isDatasync() && sync) {
                this.mappedFile.force();
            }
        }
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync, IOCallback callback) {
        this.checkIsOpen();
        if (callback == null) {
            throw new NullPointerException("callback parameter need to be set");
        }
        try {
            int position = bytes.position();
            int limit = bytes.limit();
            int remaining = limit - position;
            if (remaining > 0) {
                this.mappedFile.write(bytes, position, remaining);
                if (this.factory.isDatasync() && sync) {
                    this.mappedFile.force();
                }
            }
            callback.done();
        }
        catch (IOException e) {
            if (this.criticalErrorListener != null) {
                this.criticalErrorListener.onIOException((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            }
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync) throws IOException {
        this.checkIsOpen();
        int position = bytes.position();
        int limit = bytes.limit();
        int remaining = limit - position;
        if (remaining > 0) {
            this.mappedFile.write(bytes, position, remaining);
            if (this.factory.isDatasync() && sync) {
                this.mappedFile.force();
            }
        }
    }

    @Override
    public int read(ByteBuffer bytes, IOCallback callback) throws IOException {
        this.checkIsOpen();
        if (callback == null) {
            throw new NullPointerException("callback parameter need to be set");
        }
        try {
            int position = bytes.position();
            int limit = bytes.limit();
            int remaining = limit - position;
            if (remaining > 0) {
                int bytesRead = this.mappedFile.read(bytes, position, remaining);
                int newPosition = position + bytesRead;
                bytes.position(newPosition);
                bytes.flip();
                callback.done();
                return bytesRead;
            }
            return 0;
        }
        catch (IOException e) {
            if (this.criticalErrorListener != null) {
                this.criticalErrorListener.onIOException((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            }
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
            throw e;
        }
    }

    @Override
    public int read(ByteBuffer bytes) throws IOException {
        this.checkIsOpen();
        int position = bytes.position();
        int limit = bytes.limit();
        int remaining = limit - position;
        if (remaining > 0) {
            int bytesRead = this.mappedFile.read(bytes, position, remaining);
            int newPosition = position + bytesRead;
            bytes.position(newPosition);
            bytes.flip();
            return bytesRead;
        }
        return 0;
    }

    @Override
    public void position(long pos) {
        this.checkIsOpen();
        this.mappedFile.position(pos);
    }

    @Override
    public long position() {
        this.checkIsOpen();
        return this.mappedFile.position();
    }

    @Override
    public void close() {
        if (this.mappedFile != null) {
            this.mappedFile.closeAndResize(this.mappedFile.length());
            this.mappedFile = null;
        }
    }

    @Override
    public void sync() throws IOException {
        this.checkIsOpen();
        this.mappedFile.force();
    }

    @Override
    public long size() {
        if (this.mappedFile != null) {
            return this.mappedFile.length();
        }
        return this.file.length();
    }

    @Override
    public void renameTo(String newFileName) throws Exception {
        this.checkIsNotOpen();
        if (this.fileName == null) {
            this.fileName = this.file.getName();
        }
        if (!this.fileName.contentEquals(newFileName)) {
            File newFile = new File(this.directory, newFileName);
            if (!this.file.renameTo(newFile)) {
                throw ActiveMQJournalBundle.BUNDLE.ioRenameFileError(this.file.getName(), newFileName);
            }
            this.file = newFile;
            this.fileName = newFileName;
            this.absoluteFile = null;
        }
    }

    @Override
    public SequentialFile cloneFile() {
        this.checkIsNotOpen();
        return new MappedSequentialFile(this.factory, this.directory, this.file, this.chunkBytes, this.overlapBytes, this.criticalErrorListener);
    }

    @Override
    public void copyTo(SequentialFile dstFile) throws IOException {
        block74: {
            this.checkIsNotOpen();
            if (dstFile.isOpen()) {
                throw new IllegalArgumentException("dstFile must be closed too");
            }
            try (RandomAccessFile src = new RandomAccessFile(this.file, "rw");
                 FileChannel srcChannel = src.getChannel();
                 FileLock srcLock = srcChannel.lock();){
                long readableBytes = srcChannel.size();
                if (readableBytes <= 0L) break block74;
                try (RandomAccessFile dst = new RandomAccessFile(dstFile.getJavaFile(), "rw");
                     FileChannel dstChannel = dst.getChannel();
                     FileLock dstLock = dstChannel.lock();){
                    long oldLength = dst.length();
                    long newLength = oldLength + readableBytes;
                    dst.setLength(newLength);
                    long transferred = dstChannel.transferFrom(srcChannel, oldLength, readableBytes);
                    if (transferred != readableBytes) {
                        dstChannel.truncate(oldLength);
                        throw new IOException("copied less then expected");
                    }
                }
            }
        }
    }

    @Override
    @Deprecated
    public void setTimedBuffer(TimedBuffer buffer) {
        throw new UnsupportedOperationException("the timed buffer is not currently supported");
    }

    @Override
    public File getJavaFile() {
        if (this.absoluteFile == null) {
            this.absoluteFile = this.file.getAbsoluteFile();
        }
        return this.absoluteFile;
    }
}

