/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.mapped.BytesUtils;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFile;

public final class MappedSequentialFileFactory
implements SequentialFileFactory {
    private static long DEFAULT_BLOCK_SIZE = 0x4000000L;
    private final File directory;
    private final IOCriticalErrorListener criticalErrorListener;
    private long chunkBytes;
    private long overlapBytes;
    private boolean useDataSync;

    public MappedSequentialFileFactory(File directory, IOCriticalErrorListener criticalErrorListener) {
        this.directory = directory;
        this.criticalErrorListener = criticalErrorListener;
        this.chunkBytes = DEFAULT_BLOCK_SIZE;
        this.overlapBytes = DEFAULT_BLOCK_SIZE / 4L;
    }

    public MappedSequentialFileFactory(File directory) {
        this.directory = directory;
        this.criticalErrorListener = null;
        this.chunkBytes = DEFAULT_BLOCK_SIZE;
        this.overlapBytes = DEFAULT_BLOCK_SIZE / 4L;
    }

    public long chunkBytes() {
        return this.chunkBytes;
    }

    public MappedSequentialFileFactory chunkBytes(long chunkBytes) {
        this.chunkBytes = chunkBytes;
        return this;
    }

    public long overlapBytes() {
        return this.overlapBytes;
    }

    public MappedSequentialFileFactory overlapBytes(long overlapBytes) {
        this.overlapBytes = overlapBytes;
        return this;
    }

    @Override
    public SequentialFile createSequentialFile(String fileName) {
        return new MappedSequentialFile(this, this.directory, new File(this.directory, fileName), this.chunkBytes, this.overlapBytes, this.criticalErrorListener);
    }

    @Override
    public SequentialFileFactory setDatasync(boolean enabled) {
        this.useDataSync = enabled;
        return this;
    }

    @Override
    public boolean isDatasync() {
        return this.useDataSync;
    }

    @Override
    public int getMaxIO() {
        return 0;
    }

    @Override
    public List<String> listFiles(final String extension) throws Exception {
        FilenameFilter extensionFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith("." + extension);
            }
        };
        String[] fileNames = this.directory.list(extensionFilter);
        if (fileNames == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(fileNames);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return false;
    }

    @Override
    public void onIOError(Exception exception, String message, SequentialFile file) {
        if (this.criticalErrorListener != null) {
            this.criticalErrorListener.onIOException(exception, message, file);
        }
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
    }

    @Override
    public void releaseDirectBuffer(ByteBuffer buffer) {
        PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
        }
    }

    @Override
    public void activateBuffer(SequentialFile file) {
    }

    @Override
    public void deactivateBuffer() {
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder());
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    public int calculateBlockSize(int bytes) {
        return bytes;
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public void clearBuffer(ByteBuffer buffer) {
        buffer.clear();
        if (buffer.isDirect()) {
            BytesUtils.zerosDirect(buffer);
        } else if (buffer.hasArray()) {
            byte[] array = buffer.array();
            Arrays.fill(array, (byte)0);
        } else {
            int capacity = buffer.capacity();
            for (int i = 0; i < capacity; ++i) {
                buffer.put(i, (byte)0);
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void createDirs() throws Exception {
        boolean ok = this.directory.mkdirs();
        if (!ok) {
            throw new IOException("Failed to create directory " + this.directory);
        }
    }

    @Override
    public void flush() {
    }
}

