/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.io.DummyCallback;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.impl.SimpleWaitIOCallback;
import org.apache.activemq.artemis.core.journal.impl.SyncIOCompletion;
import org.apache.activemq.artemis.core.journal.impl.dataformat.ByteArrayEncoding;
import org.apache.activemq.artemis.core.persistence.Persister;

abstract class JournalBase
implements Journal {
    protected final int fileSize;
    private final boolean supportsCallback;

    JournalBase(boolean supportsCallback, int fileSize) {
        if (fileSize < 1024) {
            throw new IllegalArgumentException("File size cannot be less than 1024 bytes");
        }
        this.supportsCallback = supportsCallback;
        this.fileSize = fileSize;
    }

    @Override
    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendAddRecord(id, recordType, new ByteArrayEncoding(record), sync);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        SyncIOCompletion callback = this.getSyncCallback(sync);
        this.appendAddRecord(id, recordType, persister, record, sync, callback);
        if (callback != null) {
            callback.waitCompletion();
        }
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync) throws Exception {
        SyncIOCompletion syncCompletion = this.getSyncCallback(sync);
        this.appendCommitRecord(txID, sync, syncCompletion, true);
        if (syncCompletion != null) {
            syncCompletion.waitCompletion();
        }
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.appendCommitRecord(txID, sync, callback, true);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendUpdateRecord(id, recordType, new ByteArrayEncoding(record), sync);
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendUpdateRecordTransactional(txID, id, recordType, new ByteArrayEncoding(record));
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendAddRecordTransactional(txID, id, recordType, new ByteArrayEncoding(record));
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id) throws Exception {
        this.appendDeleteRecordTransactional(txID, id, NullEncoding.instance);
    }

    @Override
    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync) throws Exception {
        this.appendPrepareRecord(txID, new ByteArrayEncoding(transactionData), sync);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync) throws Exception {
        SyncIOCompletion syncCompletion = this.getSyncCallback(sync);
        this.appendPrepareRecord(txID, transactionData, sync, syncCompletion);
        if (syncCompletion != null) {
            syncCompletion.waitCompletion();
        }
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, byte[] record) throws Exception {
        this.appendDeleteRecordTransactional(txID, id, new ByteArrayEncoding(record));
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        SyncIOCompletion callback = this.getSyncCallback(sync);
        this.appendUpdateRecord(id, recordType, persister, record, sync, callback);
        if (callback != null) {
            callback.waitCompletion();
        }
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync) throws Exception {
        SyncIOCompletion syncCompletion = this.getSyncCallback(sync);
        this.appendRollbackRecord(txID, sync, syncCompletion);
        if (syncCompletion != null) {
            syncCompletion.waitCompletion();
        }
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync) throws Exception {
        SyncIOCompletion callback = this.getSyncCallback(sync);
        this.appendDeleteRecord(id, sync, callback);
        if (callback != null) {
            callback.waitCompletion();
        }
    }

    abstract void scheduleReclaim();

    protected SyncIOCompletion getSyncCallback(boolean sync) {
        if (this.supportsCallback) {
            if (sync) {
                return new SimpleWaitIOCallback();
            }
            return DummyCallback.getInstance();
        }
        return null;
    }

    @Override
    public int getFileSize() {
        return this.fileSize;
    }

    private static final class NullEncoding
    implements EncodingSupport {
        private static NullEncoding instance = new NullEncoding();

        private NullEncoding() {
        }

        @Override
        public void decode(ActiveMQBuffer buffer) {
        }

        @Override
        public void encode(ActiveMQBuffer buffer) {
        }

        @Override
        public int getEncodeSize() {
            return 0;
        }
    }
}

