/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.core.io.mapped.BytesUtils;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFile;
import org.apache.activemq.artemis.core.io.mapped.TimedSequentialFile;

public final class MappedSequentialFileFactory
implements SequentialFileFactory {
    private static long DEFAULT_BLOCK_SIZE = 0x4000000L;
    private final File directory;
    private final IOCriticalErrorListener criticalErrorListener;
    private final TimedBuffer timedBuffer;
    private long chunkBytes;
    private long overlapBytes;
    private boolean useDataSync;
    private boolean supportCallbacks;
    protected volatile int alignment = -1;

    public MappedSequentialFileFactory(File directory, IOCriticalErrorListener criticalErrorListener, boolean supportCallbacks) {
        this.directory = directory;
        this.criticalErrorListener = criticalErrorListener;
        this.chunkBytes = DEFAULT_BLOCK_SIZE;
        this.overlapBytes = DEFAULT_BLOCK_SIZE / 4L;
        this.useDataSync = true;
        this.timedBuffer = null;
        this.supportCallbacks = supportCallbacks;
    }

    public MappedSequentialFileFactory(File directory, IOCriticalErrorListener criticalErrorListener) {
        this(directory, criticalErrorListener, false);
    }

    public MappedSequentialFileFactory(File directory) {
        this(directory, null);
    }

    public long chunkBytes() {
        return this.chunkBytes;
    }

    public MappedSequentialFileFactory chunkBytes(long chunkBytes) {
        this.chunkBytes = chunkBytes;
        return this;
    }

    public long overlapBytes() {
        return this.overlapBytes;
    }

    public MappedSequentialFileFactory overlapBytes(long overlapBytes) {
        this.overlapBytes = overlapBytes;
        return this;
    }

    @Override
    public SequentialFile createSequentialFile(String fileName) {
        MappedSequentialFile mappedSequentialFile = new MappedSequentialFile(this, this.directory, new File(this.directory, fileName), this.chunkBytes, this.overlapBytes, this.criticalErrorListener);
        if (this.timedBuffer == null) {
            return mappedSequentialFile;
        }
        return new TimedSequentialFile(this, mappedSequentialFile);
    }

    @Override
    public SequentialFileFactory setDatasync(boolean enabled) {
        this.useDataSync = enabled;
        return this;
    }

    @Override
    public boolean isDatasync() {
        return this.useDataSync;
    }

    @Override
    public int getMaxIO() {
        return 1;
    }

    @Override
    public List<String> listFiles(String extension) throws Exception {
        FilenameFilter extensionFilter = (file, name) -> name.endsWith("." + extension);
        String[] fileNames = this.directory.list(extensionFilter);
        if (fileNames == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(fileNames);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return this.supportCallbacks;
    }

    @Override
    public void onIOError(Exception exception, String message, SequentialFile file) {
        if (this.criticalErrorListener != null) {
            this.criticalErrorListener.onIOException(exception, message, file);
        }
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    @Override
    public void releaseDirectBuffer(ByteBuffer buffer) {
        PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
        }
    }

    @Override
    public void activateBuffer(SequentialFile file) {
        if (this.timedBuffer != null) {
            file.setTimedBuffer(this.timedBuffer);
        }
    }

    @Override
    public void deactivateBuffer() {
        if (this.timedBuffer != null) {
            this.timedBuffer.flush();
            this.timedBuffer.setObserver(null);
        }
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    public MappedSequentialFileFactory setAlignment(int alignment) {
        this.alignment = alignment;
        return this;
    }

    @Override
    public int calculateBlockSize(int bytes) {
        return bytes;
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public void clearBuffer(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            BytesUtils.zerosDirect(buffer);
        } else if (buffer.hasArray()) {
            byte[] array = buffer.array();
            Arrays.fill(array, (byte)0);
        } else {
            int capacity = buffer.capacity();
            for (int i = 0; i < capacity; ++i) {
                buffer.put(i, (byte)0);
            }
        }
        buffer.rewind();
    }

    @Override
    public void start() {
        if (this.timedBuffer != null) {
            this.timedBuffer.start();
        }
    }

    @Override
    public void stop() {
        if (this.timedBuffer != null) {
            this.timedBuffer.stop();
        }
    }

    @Override
    public void createDirs() throws Exception {
        boolean ok = this.directory.mkdirs();
        if (!ok) {
            throw new IOException("Failed to create directory " + this.directory);
        }
    }

    @Override
    public void flush() {
        if (this.timedBuffer != null) {
            this.timedBuffer.flush();
        }
    }
}

