package org.apache.activemq.artemis.journal;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import java.lang.String;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2022-06-07T12:46:46-0400")
public class ActiveMQJournalBundle_$bundle implements ActiveMQJournalBundle, Serializable {
    private static final long serialVersionUID = 1L;
    protected ActiveMQJournalBundle_$bundle() {}
    public static final ActiveMQJournalBundle_$bundle INSTANCE = new ActiveMQJournalBundle_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String ioRenameFileError$str() {
        return "AMQ149000: failed to rename file {0} to {1}";
    }
    @Override
    public final ActiveMQIOErrorException ioRenameFileError(final String name, final String newFileName) {
        final ActiveMQIOErrorException result = new ActiveMQIOErrorException(_formatMessage(ioRenameFileError$str(), name, newFileName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String journalDifferentVersion$str() {
        return "AMQ149001: Journal data belong to a different version";
    }
    @Override
    public final ActiveMQIOErrorException journalDifferentVersion() {
        final ActiveMQIOErrorException result = new ActiveMQIOErrorException(String.format(getLoggingLocale(), journalDifferentVersion$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String journalFileMisMatch$str() {
        return "AMQ149002: Journal files version mismatch. You should export the data from the previous version and import it as explained on the user's manual";
    }
    @Override
    public final ActiveMQIOErrorException journalFileMisMatch() {
        final ActiveMQIOErrorException result = new ActiveMQIOErrorException(String.format(getLoggingLocale(), journalFileMisMatch$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileNotOpened$str() {
        return "AMQ149003: File not opened";
    }
    @Override
    public final ActiveMQIOErrorException fileNotOpened() {
        final ActiveMQIOErrorException result = new ActiveMQIOErrorException(String.format(getLoggingLocale(), fileNotOpened$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToOpenFile$str() {
        return "AMQ149004: unable to open file";
    }
    @Override
    public final String unableToOpenFile() {
        return String.format(getLoggingLocale(), unableToOpenFile$str());
    }
    protected String recordLargerThanStoreMax$str() {
        return "AMQ149005: Message of {0} bytes is bigger than the max record size of {1} bytes. You should try to move large application properties to the message body.";
    }
    @Override
    public final ActiveMQIOErrorException recordLargerThanStoreMax(final long recordSize, final long maxRecordSize) {
        final ActiveMQIOErrorException result = new ActiveMQIOErrorException(_formatMessage(recordLargerThanStoreMax$str(), recordSize, maxRecordSize));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
