package org.apache.activemq.artemis.journal;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Double;
import java.lang.Exception;
import java.lang.Integer;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.jboss.logging.BasicLogger;
import java.lang.Long;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Boolean;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-06-14T15:44:43-0400")
public class ActiveMQJournalLogger_$logger extends DelegatingBasicLogger implements ActiveMQJournalLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQJournalLogger_$logger.class.getName();
    public ActiveMQJournalLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void runningJournalBlast(final Integer numIts) {
        super.log.logv(FQCN, INFO, null, runningJournalBlast$str(), numIts);
    }
    protected String runningJournalBlast$str() {
        return "AMQ141000: *** running direct journal blast: {0}";
    }
    @Override
    public final void startingThread() {
        super.log.logv(FQCN, INFO, null, startingThread$str());
    }
    protected String startingThread$str() {
        return "AMQ141002: starting thread for sync speed test";
    }
    @Override
    public final void writeRate(final Double rate, final Long l) {
        super.log.logv(FQCN, INFO, null, writeRate$str(), rate, l);
    }
    protected String writeRate$str() {
        return "AMQ141003: Write rate = {0} bytes / sec or {1} MiB / sec";
    }
    @Override
    public final void flushRate(final Double rate) {
        super.log.logv(FQCN, INFO, null, flushRate$str(), rate);
    }
    protected String flushRate$str() {
        return "AMQ141004: Flush rate = {0} flushes / sec";
    }
    @Override
    public final void checkFiles() {
        super.log.logv(FQCN, INFO, null, checkFiles$str());
    }
    protected String checkFiles$str() {
        return "AMQ141005: Check Data Files:";
    }
    @Override
    public final void seqOutOfOrder() {
        super.log.logv(FQCN, INFO, null, seqOutOfOrder$str());
    }
    protected String seqOutOfOrder$str() {
        return "AMQ141006: Sequence out of order on journal";
    }
    @Override
    public final void currentFile(final Long fileID, final Long id, final Long fileFileID, final Boolean b) {
        super.log.logv(FQCN, INFO, null, currentFile$str(), fileID, id, fileFileID, b);
    }
    protected String currentFile$str() {
        return "AMQ141007: Current File on the journal is <= the sequence file.getFileID={0} on the dataFiles\nCurrentfile.getFileId={1} while the file.getFileID()={2}\nIs same = ({3})";
    }
    @Override
    public final void fileIdOutOfOrder() {
        super.log.logv(FQCN, INFO, null, fileIdOutOfOrder$str());
    }
    protected String fileIdOutOfOrder$str() {
        return "AMQ141008: Free File ID out of order";
    }
    @Override
    public final void fileTooSmall() {
        super.log.logv(FQCN, INFO, null, fileTooSmall$str());
    }
    protected String fileTooSmall$str() {
        return "AMQ141009: A Free File is less than the maximum data";
    }
    @Override
    public final void initializingJdbcDataSource(final String dataSourceClassName, final String dataSourceProperties) {
        super.log.logv(FQCN, INFO, null, initializingJdbcDataSource$str(), dataSourceClassName, dataSourceProperties);
    }
    protected String initializingJdbcDataSource$str() {
        return "AMQ141010: Initialising JDBC data source {0} with properties {1}";
    }
    @Override
    public final void incompatibleNativeLibrary() {
        super.log.logv(FQCN, WARN, null, incompatibleNativeLibrary$str());
    }
    protected String incompatibleNativeLibrary$str() {
        return "AMQ142000: You have a native library with a different version than expected";
    }
    @Override
    public final void couldNotGetLock(final String fileName) {
        super.log.logv(FQCN, WARN, null, couldNotGetLock$str(), fileName);
    }
    protected String couldNotGetLock$str() {
        return "AMQ142001: Could not get lock after 60 seconds on closing Asynchronous File: {0}";
    }
    @Override
    public final void fileFinalizedWhileOpen(final String fileName) {
        super.log.logv(FQCN, WARN, null, fileFinalizedWhileOpen$str(), fileName);
    }
    protected String fileFinalizedWhileOpen$str() {
        return "AMQ142002: Asynchronous File: {0} being finalized with opened state";
    }
    @Override
    public final void callbackError(final String error) {
        super.log.logv(FQCN, WARN, null, callbackError$str(), error);
    }
    protected String callbackError$str() {
        return "AMQ142003: AIO Callback Error: {0}";
    }
    @Override
    public final void inconsistencyDuringCompacting(final Long transactionID) {
        super.log.logv(FQCN, WARN, null, inconsistencyDuringCompacting$str(), transactionID);
    }
    protected String inconsistencyDuringCompacting$str() {
        return "AMQ142004: Inconsistency during compacting: CommitRecord ID = {0} for an already committed transaction during compacting";
    }
    @Override
    public final void inconsistencyDuringCompactingDelete(final Long recordID) {
        super.log.logv(FQCN, WARN, null, inconsistencyDuringCompactingDelete$str(), recordID);
    }
    protected String inconsistencyDuringCompactingDelete$str() {
        return "AMQ142005: Inconsistency during compacting: Delete record being read on an existent record (id={0})";
    }
    @Override
    public final void compactingWithNoAddRecord(final Long id) {
        super.log.logv(FQCN, WARN, null, compactingWithNoAddRecord$str(), id);
    }
    protected String compactingWithNoAddRecord$str() {
        return "AMQ142006: Could not find add Record information for record {0} during compacting";
    }
    @Override
    public final void noRecordDuringCompactReplay(final Long id) {
        super.log.logv(FQCN, WARN, null, noRecordDuringCompactReplay$str(), id);
    }
    protected String noRecordDuringCompactReplay$str() {
        return "AMQ142007: Can not find record {0} during compact replay";
    }
    @Override
    public final void couldNotRemoveFile(final JournalFile file) {
        super.log.logv(FQCN, WARN, null, couldNotRemoveFile$str(), file);
    }
    protected String couldNotRemoveFile$str() {
        return "AMQ142008: Could not remove file {0} from the list of data files";
    }
    @Override
    public final void deletingFile(final JournalFile file) {
        super.log.logv(FQCN, WARN, null, deletingFile$str(), file);
    }
    protected String deletingFile$str() {
        return "AMQ142009: *******************************************************************************************************************************\nThe File Storage Attic is full, as the file {0}  does not have the configured size, and the file will be removed\n*******************************************************************************************************************************";
    }
    @Override
    public final void failedToAddFile(final JournalFile nextOpenedFile) {
        super.log.logv(FQCN, WARN, null, failedToAddFile$str(), nextOpenedFile);
    }
    protected String failedToAddFile$str() {
        return "AMQ142010: Failed to add file to opened files queue: {0}. This should NOT happen!";
    }
    @Override
    public final void compactReadError(final JournalFile file) {
        super.log.logv(FQCN, WARN, null, compactReadError$str(), file);
    }
    protected String compactReadError$str() {
        return "AMQ142011: Error on reading compacting for {0}";
    }
    @Override
    public final void compactMergeError(final Long id) {
        super.log.logv(FQCN, WARN, null, compactMergeError$str(), id);
    }
    protected String compactMergeError$str() {
        return "AMQ142012: Couldn''t find tx={0} to merge after compacting";
    }
    @Override
    public final void preparedTXIncomplete(final Long id) {
        super.log.logv(FQCN, WARN, null, preparedTXIncomplete$str(), id);
    }
    protected String preparedTXIncomplete$str() {
        return "AMQ142013: Prepared transaction {0} was not considered completed, it will be ignored";
    }
    @Override
    public final void txMissingElements(final Long id) {
        super.log.logv(FQCN, WARN, null, txMissingElements$str(), id);
    }
    protected String txMissingElements$str() {
        return "AMQ142014: Transaction {0} is missing elements so the transaction is being ignored";
    }
    @Override
    public final void uncomittedTxFound(final Long id) {
        super.log.logv(FQCN, WARN, null, uncomittedTxFound$str(), id);
    }
    protected String uncomittedTxFound$str() {
        return "AMQ142015: Uncommitted transaction with id {0} found and discarded";
    }
    @Override
    public final void couldNotStopCompactor() {
        super.log.logv(FQCN, WARN, null, couldNotStopCompactor$str());
    }
    protected String couldNotStopCompactor$str() {
        return "AMQ142016: Could not stop compactor executor after 120 seconds";
    }
    @Override
    public final void couldNotStopJournalExecutor() {
        super.log.logv(FQCN, WARN, null, couldNotStopJournalExecutor$str());
    }
    protected String couldNotStopJournalExecutor$str() {
        return "AMQ142017: Could not stop journal executor after 60 seconds";
    }
    @Override
    public final void tempFilesLeftOpen() {
        super.log.logv(FQCN, WARN, null, tempFilesLeftOpen$str());
    }
    protected String tempFilesLeftOpen$str() {
        return "AMQ142018: Temporary files were left unattended after a crash on journal directory, deleting invalid files now";
    }
    @Override
    public final void deletingOrphanedFile(final String fileToDelete) {
        super.log.logv(FQCN, WARN, null, deletingOrphanedFile$str(), fileToDelete);
    }
    protected String deletingOrphanedFile$str() {
        return "AMQ142019: Deleting orphaned file {0}";
    }
    @Override
    public final void errorClosingFile(final String fileToDelete) {
        super.log.logv(FQCN, WARN, null, errorClosingFile1$str(), fileToDelete);
    }
    protected String errorClosingFile1$str() {
        return "AMQ142020: Could not get lock after 60 seconds on closing Asynchronous File: {0}";
    }
    @Override
    public final void errorOnIOCallback(final String errorMessage) {
        super.log.logv(FQCN, WARN, null, errorOnIOCallback$str(), errorMessage);
    }
    protected String errorOnIOCallback$str() {
        return "AMQ142021: Error on IO callback, {0}";
    }
    @Override
    public final void timeoutOnPollerShutdown(final Exception e) {
        super.log.logv(FQCN, WARN, e, timeoutOnPollerShutdown$str());
    }
    protected String timeoutOnPollerShutdown$str() {
        return "AMQ142022: Timed out on AIO poller shutdown";
    }
    @Override
    public final void couldNotCompleteTask(final Exception e, final String name) {
        super.log.logv(FQCN, WARN, e, couldNotCompleteTask$str(), name);
    }
    protected String couldNotCompleteTask$str() {
        return "AMQ142023: Executor on file {0} couldn''t complete its tasks in 60 seconds.";
    }
    @Override
    public final void errorCompletingCallback(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorCompletingCallback$str());
    }
    protected String errorCompletingCallback$str() {
        return "AMQ142024: Error completing callback";
    }
    @Override
    public final void errorCallingErrorCallback(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorCallingErrorCallback$str());
    }
    protected String errorCallingErrorCallback$str() {
        return "AMQ142025: Error calling onError callback";
    }
    @Override
    public final void timeoutOnWriterShutdown(final Throwable e) {
        super.log.logv(FQCN, WARN, e, timeoutOnWriterShutdown$str());
    }
    protected String timeoutOnWriterShutdown$str() {
        return "AMQ142026: Timed out on AIO writer shutdown";
    }
    @Override
    public final void errorWritingData(final Throwable e, final String errorMessage, final Integer errorCode) {
        super.log.logv(FQCN, WARN, e, errorWritingData$str(), errorMessage, errorCode);
    }
    protected String errorWritingData$str() {
        return "AMQ142027: Error on writing data! {0} code - {1}";
    }
    @Override
    public final void errorReplayingCommands(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorReplayingCommands$str());
    }
    protected String errorReplayingCommands$str() {
        return "AMQ142028: Error replaying pending commands after compacting";
    }
    @Override
    public final void errorClosingFile(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorClosingFile0$str());
    }
    protected String errorClosingFile0$str() {
        return "AMQ142029: Error closing file";
    }
    @Override
    public final void errorOpeningFile(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorOpeningFile$str());
    }
    protected String errorOpeningFile$str() {
        return "AMQ142030: Could not open a file in 60 Seconds";
    }
    @Override
    public final void errorRetrievingID(final Throwable e, final String fileName) {
        super.log.logv(FQCN, WARN, e, errorRetrievingID$str(), fileName);
    }
    protected String errorRetrievingID$str() {
        return "AMQ142031: Error retrieving ID part of the file name {0}";
    }
    @Override
    public final void errorReadingFile(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorReadingFile$str());
    }
    protected String errorReadingFile$str() {
        return "AMQ142032: Error reading journal file";
    }
    @Override
    public final void errorReinitializingFile(final Throwable e, final JournalFile file) {
        super.log.logv(FQCN, WARN, e, errorReinitializingFile$str(), file);
    }
    protected String errorReinitializingFile$str() {
        return "AMQ142033: Error reinitializing file {0}";
    }
    @Override
    public final void errorSubmittingWrite(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorSubmittingWrite$str());
    }
    protected String errorSubmittingWrite$str() {
        return "AMQ142034: Exception on submitting write";
    }
    @Override
    public final void couldNotStopJournalAppendExecutor() {
        super.log.logv(FQCN, WARN, null, couldNotStopJournalAppendExecutor$str());
    }
    protected String couldNotStopJournalAppendExecutor$str() {
        return "AMQ142035: Could not stop journal append executor after 60 seconds";
    }
    @Override
    public final void errorDeletingFile(final Object e) {
        super.log.logv(FQCN, ERROR, null, errorDeletingFile$str(), e);
    }
    protected String errorDeletingFile$str() {
        return "AMQ144000: Failed to delete file {0}";
    }
    @Override
    public final void errorStartingPoller(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorStartingPoller$str());
    }
    protected String errorStartingPoller$str() {
        return "AMQ144001: Error starting poller";
    }
    @Override
    public final void errorPushingFile(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorPushingFile$str());
    }
    protected String errorPushingFile$str() {
        return "AMQ144002: Error pushing opened file";
    }
    @Override
    public final void errorCompacting(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorCompacting$str());
    }
    protected String errorCompacting$str() {
        return "AMQ144003: Error compacting";
    }
    @Override
    public final void errorSchedulingCompacting(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorSchedulingCompacting$str());
    }
    protected String errorSchedulingCompacting$str() {
        return "AMQ144004: Error scheduling compacting";
    }
    @Override
    public final void failedToPerfBlast(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, failedToPerfBlast$str());
    }
    protected String failedToPerfBlast$str() {
        return "AMQ144005: Failed to performance blast";
    }
    @Override
    public final void ioError(final int errorCode, final String errorMessage) {
        super.log.logv(FQCN, ERROR, null, ioError$str(), errorCode, errorMessage);
    }
    protected String ioError$str() {
        return "AMQ144006: IOError code {0}, {1}";
    }
    @Override
    public final void ignoringShortFile(final String fileName) {
        super.log.logv(FQCN, WARN, null, ignoringShortFile$str(), fileName);
    }
    protected String ignoringShortFile$str() {
        return "AMQ144007: Ignoring journal file {0}: file is shorter then minimum header size. This file is being removed.";
    }
    @Override
    public final void movingFileToAttic(final String fileName) {
        super.log.logv(FQCN, WARN, null, movingFileToAttic$str(), fileName);
    }
    protected String movingFileToAttic$str() {
        return "AMQ144008: *******************************************************************************************************************************\nFile {0}: was moved under attic, please review it and remove it.\n*******************************************************************************************************************************";
    }
    @Override
    public final void cantOpenFileTimeout(final long timeout) {
        super.log.logv(FQCN, WARN, null, cantOpenFileTimeout$str(), timeout);
    }
    protected String cantOpenFileTimeout$str() {
        return "AMQ144009: Could not get a file in {0} seconds, System will retry the open but you may see increased latency in your system";
    }
    @Override
    public final void criticalIO(final String message, final Exception error) {
        super.log.logv(FQCN, WARN, error, criticalIO$str(), message);
    }
    protected String criticalIO$str() {
        return "AMQ144010: Critical IO Exception happened: {0}";
    }
}
