/** This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
    and it inherits whatever license is declared at org.apache.activemq.artemis.journal.ActiveMQJournalLogger */

package org.apache.activemq.artemis.journal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(regexID="14[0-9]{4}", projectCode="AMQ")
public class ActiveMQJournalLogger_impl implements ActiveMQJournalLogger
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public ActiveMQJournalLogger_impl(Logger logger ) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=141000, value=\"*** running direct journal blast: {}\", level=INFO)
   @Override
   public void runningJournalBlast(java.lang.Integer numIts) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ141000: *** running direct journal blast: {}", numIts);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=141002, value=\"starting thread for sync speed test\", level=INFO)
   @Override
   public void startingThread() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ141002: starting thread for sync speed test");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=141003, value=\"Write rate = {} bytes / sec or {} MiB / sec\", level=INFO)
   @Override
   public void writeRate(java.lang.Double rate, java.lang.Long l) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ141003: Write rate = {} bytes / sec or {} MiB / sec", rate, l);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=141004, value=\"Flush rate = {} flushes / sec\", level=INFO)
   @Override
   public void flushRate(java.lang.Double rate) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ141004: Flush rate = {} flushes / sec", rate);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=141005, value=\"Check Data Files:\", level=INFO)
   @Override
   public void checkFiles() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ141005: Check Data Files:");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=141006, value=\"Sequence out of order on journal\", level=INFO)
   @Override
   public void seqOutOfOrder() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ141006: Sequence out of order on journal");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=141007, value=\"Current File on the journal is <= the sequence file.getFileID={} on the dataFiles\nCurrentfile.getFileId={} while the file.getFileID()={}\nIs same = ({})\", level=INFO)
   @Override
   public void currentFile(java.lang.Long fileID, java.lang.Long id, java.lang.Long fileFileID, java.lang.Boolean b) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ141007: Current File on the journal is <= the sequence file.getFileID={} on the dataFiles\nCurrentfile.getFileId={} while the file.getFileID()={}\nIs same = ({})", fileID, id, fileFileID, b);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=141008, value=\"Free File ID out of order\", level=INFO)
   @Override
   public void fileIdOutOfOrder() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ141008: Free File ID out of order");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=141009, value=\"A Free File is less than the maximum data\", level=INFO)
   @Override
   public void fileTooSmall() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ141009: A Free File is less than the maximum data");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=141010, value=\"Initialising JDBC data source {} with properties {}\", level=INFO)
   @Override
   public void initializingJdbcDataSource(java.lang.String dataSourceClassName, java.lang.String dataSourceProperties) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ141010: Initialising JDBC data source {} with properties {}", dataSourceClassName, dataSourceProperties);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142000, value=\"You have a native library with a different version than expected\", level=WARN)
   @Override
   public void incompatibleNativeLibrary() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142000: You have a native library with a different version than expected");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142001, value=\"Could not get lock after 60 seconds on closing Asynchronous File: {}\", level=WARN)
   @Override
   public void couldNotGetLock(java.lang.String fileName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142001: Could not get lock after 60 seconds on closing Asynchronous File: {}", fileName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142002, value=\"Asynchronous File: {} being finalized with opened state\", level=WARN)
   @Override
   public void fileFinalizedWhileOpen(java.lang.String fileName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142002: Asynchronous File: {} being finalized with opened state", fileName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142003, value=\"AIO Callback Error: {}\", level=WARN)
   @Override
   public void callbackError(java.lang.String error) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142003: AIO Callback Error: {}", error);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142004, value=\"Inconsistency during compacting: CommitRecord ID = {} for an already committed transaction during compacting\", level=WARN)
   @Override
   public void inconsistencyDuringCompacting(java.lang.Long transactionID) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142004: Inconsistency during compacting: CommitRecord ID = {} for an already committed transaction during compacting", transactionID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142005, value=\"Inconsistency during compacting: Delete record being read on an existent record (id={})\", level=WARN)
   @Override
   public void inconsistencyDuringCompactingDelete(java.lang.Long recordID) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142005: Inconsistency during compacting: Delete record being read on an existent record (id={})", recordID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142006, value=\"Could not find add Record information for record {} during compacting\", level=WARN)
   @Override
   public void compactingWithNoAddRecord(java.lang.Long id) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142006: Could not find add Record information for record {} during compacting", id);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142007, value=\"Can not find record {} during compact replay\", level=WARN)
   @Override
   public void noRecordDuringCompactReplay(java.lang.Long id) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142007: Can not find record {} during compact replay", id);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142008, value=\"Could not remove file {} from the list of data files\", level=WARN)
   @Override
   public void couldNotRemoveFile(org.apache.activemq.artemis.core.journal.impl.JournalFile file) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142008: Could not remove file {} from the list of data files", file);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142009, value=\"*******************************************************************************************************************************\nThe File Storage Attic is full, as the file {}  does not have the configured size, and the file will be removed\n*******************************************************************************************************************************\", level=WARN)
   @Override
   public void deletingFile(org.apache.activemq.artemis.core.journal.impl.JournalFile file) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142009: *******************************************************************************************************************************\nThe File Storage Attic is full, as the file {}  does not have the configured size, and the file will be removed\n*******************************************************************************************************************************", file);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142010, value=\"Failed to add file to opened files queue: {}. This should NOT happen!\", level=WARN)
   @Override
   public void failedToAddFile(org.apache.activemq.artemis.core.journal.impl.JournalFile nextOpenedFile) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142010: Failed to add file to opened files queue: {}. This should NOT happen!", nextOpenedFile);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142011, value=\"Error on reading compacting for {}\", level=WARN)
   @Override
   public void compactReadError(org.apache.activemq.artemis.core.journal.impl.JournalFile file) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142011: Error on reading compacting for {}", file);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142012, value=\"Couldn't find tx={} to merge after compacting\", level=WARN)
   @Override
   public void compactMergeError(java.lang.Long id) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142012: Couldn't find tx={} to merge after compacting", id);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142013, value=\"Prepared transaction {} was not considered completed, it will be ignored\", level=WARN)
   @Override
   public void preparedTXIncomplete(java.lang.Long id) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142013: Prepared transaction {} was not considered completed, it will be ignored", id);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142014, value=\"Transaction {} is missing elements so the transaction is being ignored\", level=WARN)
   @Override
   public void txMissingElements(java.lang.Long id) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142014: Transaction {} is missing elements so the transaction is being ignored", id);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142015, value=\"Uncommitted transaction with id {} found and discarded\", level=WARN)
   @Override
   public void uncomittedTxFound(java.lang.Long id) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142015: Uncommitted transaction with id {} found and discarded", id);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142016, value=\"Could not stop compactor executor after 120 seconds\", level=WARN)
   @Override
   public void couldNotStopCompactor() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142016: Could not stop compactor executor after 120 seconds");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142017, value=\"Could not stop journal executor after 60 seconds\", level=WARN)
   @Override
   public void couldNotStopJournalExecutor() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142017: Could not stop journal executor after 60 seconds");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142018, value=\"Temporary files were left unattended after a crash on journal directory, deleting invalid files now\", level=WARN)
   @Override
   public void tempFilesLeftOpen() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142018: Temporary files were left unattended after a crash on journal directory, deleting invalid files now");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142019, value=\"Deleting orphaned file {}\", level=WARN)
   @Override
   public void deletingOrphanedFile(java.lang.String fileToDelete) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142019: Deleting orphaned file {}", fileToDelete);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142020, value=\"Could not get lock after 60 seconds on closing Asynchronous File: {}\", level=WARN)
   @Override
   public void errorClosingFile(java.lang.String fileToDelete) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142020: Could not get lock after 60 seconds on closing Asynchronous File: {}", fileToDelete);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142021, value=\"Error on IO callback, {}\", level=WARN)
   @Override
   public void errorOnIOCallback(java.lang.String errorMessage) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142021: Error on IO callback, {}", errorMessage);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142022, value=\"Timed out on AIO poller shutdown\", level=WARN)
   @Override
   public void timeoutOnPollerShutdown(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142022: Timed out on AIO poller shutdown", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142023, value=\"Executor on file {} couldn't complete its tasks in 60 seconds.\", level=WARN)
   @Override
   public void couldNotCompleteTask(java.lang.String name, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142023: Executor on file {} couldn't complete its tasks in 60 seconds.", name, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142024, value=\"Error completing callback\", level=WARN)
   @Override
   public void errorCompletingCallback(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142024: Error completing callback", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142025, value=\"Error calling onError callback\", level=WARN)
   @Override
   public void errorCallingErrorCallback(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142025: Error calling onError callback", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142026, value=\"Timed out on AIO writer shutdown\", level=WARN)
   @Override
   public void timeoutOnWriterShutdown(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142026: Timed out on AIO writer shutdown", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142027, value=\"Error on writing data! {} code - {}\", level=WARN)
   @Override
   public void errorWritingData(java.lang.String errorMessage, int errorCode, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142027: Error on writing data! {} code - {}", errorMessage, errorCode, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142028, value=\"Error replaying pending commands after compacting\", level=WARN)
   @Override
   public void errorReplayingCommands(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142028: Error replaying pending commands after compacting", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142029, value=\"Error closing file\", level=WARN)
   @Override
   public void errorClosingFile(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142029: Error closing file", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142030, value=\"Could not open a file in 60 Seconds\", level=WARN)
   @Override
   public void errorOpeningFile(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142030: Could not open a file in 60 Seconds", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142031, value=\"Error retrieving ID part of the file name {}\", level=WARN)
   @Override
   public void errorRetrievingID(java.lang.String fileName, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142031: Error retrieving ID part of the file name {}", fileName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142032, value=\"Error reading journal file\", level=WARN)
   @Override
   public void errorReadingFile(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142032: Error reading journal file", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142033, value=\"Error reinitializing file {}\", level=WARN)
   @Override
   public void errorReinitializingFile(org.apache.activemq.artemis.core.journal.impl.JournalFile file, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142033: Error reinitializing file {}", file, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142034, value=\"Exception on submitting write\", level=WARN)
   @Override
   public void errorSubmittingWrite(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142034: Exception on submitting write", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=142035, value=\"Could not stop journal append executor after 60 seconds\", level=WARN)
   @Override
   public void couldNotStopJournalAppendExecutor() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ142035: Could not stop journal append executor after 60 seconds");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=144000, value=\"Failed to delete file {}\", level=ERROR)
   @Override
   public void errorDeletingFile(java.lang.Object e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ144000: Failed to delete file {}", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=144001, value=\"Error starting poller\", level=ERROR)
   @Override
   public void errorStartingPoller(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ144001: Error starting poller", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=144002, value=\"Error pushing opened file\", level=ERROR)
   @Override
   public void errorPushingFile(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ144002: Error pushing opened file", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=144003, value=\"Error compacting\", level=ERROR)
   @Override
   public void errorCompacting(java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ144003: Error compacting", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=144004, value=\"Error scheduling compacting\", level=ERROR)
   @Override
   public void errorSchedulingCompacting(java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ144004: Error scheduling compacting", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=144005, value=\"Failed to performance blast\", level=ERROR)
   @Override
   public void failedToPerfBlast(java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ144005: Failed to performance blast", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=144006, value=\"IOError code {}, {}\", level=ERROR)
   @Override
   public void ioError(int errorCode, java.lang.String errorMessage) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ144006: IOError code {}, {}", errorCode, errorMessage);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=144007, value=\"Ignoring journal file {}: file is shorter then minimum header size. This file is being removed.\", level=WARN)
   @Override
   public void ignoringShortFile(java.lang.String fileName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ144007: Ignoring journal file {}: file is shorter then minimum header size. This file is being removed.", fileName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=144008, value=\"*******************************************************************************************************************************\nFile {}: was moved under attic, please review it and remove it.\n*******************************************************************************************************************************\", level=WARN)
   @Override
   public void movingFileToAttic(java.lang.String fileName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ144008: *******************************************************************************************************************************\nFile {}: was moved under attic, please review it and remove it.\n*******************************************************************************************************************************", fileName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=144009, value=\"Could not get a file in {} seconds, System will retry the open but you may see increased latency in your system\", level=WARN)
   @Override
   public void cantOpenFileTimeout(long timeout) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ144009: Could not get a file in {} seconds, System will retry the open but you may see increased latency in your system", timeout);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=144010, value=\"Critical IO Exception happened: {}\", level=WARN)
   @Override
   public void criticalIO(java.lang.String message, java.lang.Throwable error) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ144010: Critical IO Exception happened: {}", message, error);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=144011, value=\"Critical IO Exception happened: {} on {}\", level=WARN)
   @Override
   public void criticalIOFile(java.lang.String message, java.lang.String fileName, java.lang.Throwable error) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ144011: Critical IO Exception happened: {} on {}", message, fileName, error);
      }
   }

}
